/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import admin.astor.ServArchitectureDialog;
import admin.astor.tools.DevBrowser;
import admin.astor.tools.PollingProfiler;
import admin.astor.tools.PropertyDialog;
import admin.astor.tools.TreePopupMenu;
import admin.astor.tools.Utils;
import atkpanel.MainPanel;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.AttributeProxy;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jive.ExecDev;

public class DevBrowserTree
extends JTree
implements TangoConst {
    private static final int INSTANCE = 3;
    private static final int CLASS = 4;
    private static final int DEVICE = 5;
    private static final int ATTRIB = 6;
    private static final int DOMAIN = 3;
    private static final int FAMILY = 4;
    private static final int MEMBER = 5;
    private DefaultTreeModel treeModel;
    private DevBrowser browser;
    private TreePopupMenu attributeMenu = null;
    private TreePopupMenu deviceMenu = null;
    private TreePopupMenu serverMenu = null;
    private DefaultMutableTreeNode root;
    private boolean obj_has_polling;

    public DevBrowserTree(DevBrowser parent) throws DevFailed {
        this.browser = parent;
        String tango_host = ApiUtil.get_db_obj().get_tango_host();
        this.initComponent(tango_host);
        this.attributeMenu = new TreePopupMenu(this, 1);
        this.deviceMenu = new TreePopupMenu(this, 0);
        this.serverMenu = new TreePopupMenu(this, 2);
    }

    private void initComponent(String title) throws DevFailed {
        this.root = new DefaultMutableTreeNode(title);
        this.createServerNodes(this.root);
        this.createDeviceNodes(this.root);
        this.createAliasNodes(this.root);
        this.getSelectionModel().setSelectionMode(1);
        this.treeModel = new DefaultTreeModel(this.root);
        this.setModel(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new TangoRenderer());
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                DevBrowserTree.this.expandedPerformed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DevBrowserTree.this.treeMouseClicked(evt);
            }
        });
    }

    private boolean createChildNodes(DefaultMutableTreeNode node, String[] str) {
        boolean create = false;
        if (node.getChildCount() != str.length) {
            create = true;
        } else {
            for (int i = 0; i < str.length; ++i) {
                if (node.getChildAt(i).toString().equals(str[i])) continue;
                create = true;
            }
        }
        return create;
    }

    private void createAliasNodes(DefaultMutableTreeNode root) throws DevFailed {
        String[] aliases;
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Aliases");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        for (String alias : aliases = db.get_device_alias_list("*")) {
            try {
                String deviceName = ApiUtil.get_db_obj().get_device_from_alias(alias);
                DefaultMutableTreeNode al_node = new DefaultMutableTreeNode((Object)new BrowserDevice(deviceName, alias));
                al_node.add(new DefaultMutableTreeNode("dummy"));
                c_node.add(al_node);
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }
    }

    private void createServerNodes(DefaultMutableTreeNode root) throws DevFailed {
        String[] servers;
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Servers");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        for (String server : servers = db.get_server_name_list()) {
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(server);
            d_node.add(new DefaultMutableTreeNode("dummy"));
            c_node.add(d_node);
        }
    }

    private void createInstanceNodes(DefaultMutableTreeNode node) {
        try {
            String binaryFile = (String)node.getUserObject();
            String[] instances = ApiUtil.get_db_obj().get_instance_name_list(binaryFile);
            if (!this.createChildNodes(node, instances)) {
                return;
            }
            for (int i = 0; i < instances.length; ++i) {
                DefaultMutableTreeNode s_node = new DefaultMutableTreeNode(new BrowserServer(binaryFile, instances[i]));
                s_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(s_node, node, i);
            }
            this.removePreviousNode(node, instances.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createClassNodes(DefaultMutableTreeNode node) {
        try {
            BrowserServer server = (BrowserServer)node.getUserObject();
            String[] classes = ApiUtil.get_db_obj().get_server_class_list(server.name);
            if (!this.createChildNodes(node, classes)) {
                return;
            }
            for (int i = 0; i < classes.length; ++i) {
                DefaultMutableTreeNode i_node = new DefaultMutableTreeNode(classes[i]);
                i_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(i_node, node, i);
            }
            this.removePreviousNode(node, classes.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createDeviceNodesFromServer(DefaultMutableTreeNode node) {
        try {
            DefaultMutableTreeNode s_node = (DefaultMutableTreeNode)node.getParent();
            BrowserServer server = (BrowserServer)s_node.getUserObject();
            String serverName = server.name;
            String className = (String)node.getUserObject();
            String[] devices = ApiUtil.get_db_obj().get_device_name(serverName, className);
            if (!this.createChildNodes(node, devices)) {
                return;
            }
            for (int i = 0; i < devices.length; ++i) {
                DefaultMutableTreeNode d_node = new DefaultMutableTreeNode((Object)new BrowserDevice_2(devices[i]));
                d_node.add(new DefaultMutableTreeNode("dummy"));
                this.treeModel.insertNodeInto(d_node, node, i);
            }
            this.removePreviousNode(node, devices.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createDeviceNodes(DefaultMutableTreeNode root) throws DevFailed {
        String[] domains;
        DefaultMutableTreeNode c_node = new DefaultMutableTreeNode("Devices");
        root.add(c_node);
        Database db = ApiUtil.get_db_obj();
        for (String domain : domains = db.get_device_domain("*")) {
            DefaultMutableTreeNode d_node = new DefaultMutableTreeNode(domain);
            d_node.add(new DefaultMutableTreeNode("dummy"));
            c_node.add(d_node);
        }
    }

    private void createFamilyNodes(DefaultMutableTreeNode node) {
        try {
            String domain = (String)node.getUserObject();
            String[] families = ApiUtil.get_db_obj().get_device_family(domain + "/*");
            if (!this.createChildNodes(node, families)) {
                return;
            }
            for (int f = 0; f < families.length; ++f) {
                DefaultMutableTreeNode f_node = new DefaultMutableTreeNode(families[f]);
                f_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(f_node, node, f);
            }
            this.removePreviousNode(node, families.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createMemberNodes(String tango_path, DefaultMutableTreeNode node) {
        try {
            tango_path = tango_path + (String)node.getUserObject();
            String[] members = ApiUtil.get_db_obj().get_device_member(tango_path + "/*");
            if (!this.createChildNodes(node, members)) {
                return;
            }
            for (int m = 0; m < members.length; ++m) {
                DefaultMutableTreeNode m_node = new DefaultMutableTreeNode((Object)new BrowserDevice(tango_path + "/" + members[m]));
                m_node.add(new DefaultMutableTreeNode("Dummy"));
                this.treeModel.insertNodeInto(m_node, node, m);
            }
            this.removePreviousNode(node, members.length);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void createAttributeNodes(DefaultMutableTreeNode node) {
        try {
            BrowserDevice dev = (BrowserDevice)((Object)node.getUserObject());
            String[] attnames = dev.get_attribute_list();
            if (!this.createChildNodes(node, attnames)) {
                return;
            }
            for (int a = 0; a < attnames.length; ++a) {
                BrowserAttribute attr = new BrowserAttribute(attnames[a], dev);
                DefaultMutableTreeNode a_node = new DefaultMutableTreeNode(attr);
                this.treeModel.insertNodeInto(a_node, node, a);
            }
            this.removePreviousNode(node, attnames.length);
        }
        catch (DevFailed e) {
            this.removePreviousNode(node, 0);
            this.displayException((Exception)((Object)e));
        }
    }

    private void removePreviousNode(DefaultMutableTreeNode node, int offset) {
        while (node.getChildCount() > offset) {
            DefaultMutableTreeNode leaf = (DefaultMutableTreeNode)node.getChildAt(offset);
            this.treeModel.removeNodeFromParent(leaf);
        }
    }

    private String tangoPath(TreePath path, int nb) {
        String p = "";
        for (int i = 3; i < 3 + nb; ++i) {
            p = p + path.getPathComponent(i - 1).toString();
            p = p + "/";
        }
        return p;
    }

    public void expandedPerformed(TreeExpansionEvent evt) {
        TreePath tp = evt.getPath();
        Object[] path = tp.getPath();
        if (path.length < 2) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getPathComponent(path.length - 1);
        if (path[1].toString().equals("Servers")) {
            switch (path.length) {
                case 3: {
                    this.createInstanceNodes(node);
                    break;
                }
                case 4: {
                    this.createClassNodes(node);
                    break;
                }
                case 5: {
                    this.createDeviceNodesFromServer(node);
                    break;
                }
                case 6: {
                    this.createAttributeNodes(node);
                }
            }
        } else if (path[1].toString().equals("Devices")) {
            switch (path.length) {
                case 3: {
                    this.createFamilyNodes(node);
                    break;
                }
                case 4: {
                    String tango_path = this.tangoPath(tp, 1);
                    this.createMemberNodes(tango_path, node);
                    break;
                }
                case 5: {
                    this.createAttributeNodes(node);
                }
            }
        } else if (path[1].toString().equals("Aliases") && path.length == 3) {
            this.createAttributeNodes(node);
        }
    }

    private void treeMouseClicked(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) < 1) {
            return;
        }
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object o = node.getUserObject();
        int mask = evt.getModifiers();
        this.clearDisplay();
        this.obj_has_polling = false;
        if (evt.getClickCount() == 2 && node.isLeaf()) {
            if (o instanceof BrowserDevice) {
                this.createAttributeNodes(node);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandPath(new TreePath(child.getPath()));
                }
            }
        } else if ((mask & 4) != 0) {
            if (o instanceof BrowserAttribute) {
                this.attributeMenu.showMenu(evt);
                BrowserAttribute attr = (BrowserAttribute)o;
                this.displayEventProperties(attr);
            } else if (o instanceof BrowserDevice) {
                boolean running = this.displayDeviceInfo((BrowserDevice)((Object)o));
                this.deviceMenu.showMenu(evt, this.obj_has_polling, running);
            } else if (o instanceof BrowserServer) {
                boolean running = this.displayDeviceInfo(((BrowserServer)o).dev);
                this.serverMenu.showMenu(evt, this.obj_has_polling, running);
            }
        } else if ((mask & 0x10) != 0) {
            if (o instanceof BrowserServer) {
                this.displayDeviceInfo(((BrowserServer)o).dev);
            } else if (o instanceof BrowserDevice) {
                this.displayDeviceInfo((BrowserDevice)((Object)o));
            } else if (o instanceof BrowserAttribute) {
                this.displayEventProperties((BrowserAttribute)o);
            }
        }
    }

    private void clearDisplay() {
        this.browser.setText("");
    }

    private boolean displayDeviceInfo(BrowserDevice dev) {
        String message;
        try {
            DeviceInfo info = dev.get_info();
            message = info + "\n\n";
        }
        catch (DevFailed e) {
            this.browser.setText(e.toString());
            return false;
        }
        boolean ok = false;
        try {
            String str = "\n=======================================\n";
            str = str + "           Polling Status:\n\n";
            if (dev.name().startsWith("dserver/")) {
                String[] devlist;
                DeviceData argout = dev.command_inout("QueryDevice");
                for (String device : devlist = argout.extractStringArray()) {
                    String devname = device.substring(device.indexOf("::") + 2);
                    DeviceData argin = new DeviceData();
                    argin.insert(devname);
                    argout = dev.command_inout("DevPollStatus", argin);
                    String[] s = argout.extractStringArray();
                    str = str + "----------------- " + devname + " ------------------\n";
                    for (String line : s) {
                        str = str + line + "\n\n";
                    }
                    if (s.length <= 0) continue;
                    this.obj_has_polling = true;
                }
                ok = true;
            } else {
                String[] poll_st;
                for (String line : poll_st = dev.polling_status()) {
                    str = str + line + "\n\n";
                }
                ok = true;
                if (poll_st.length > 0) {
                    this.obj_has_polling = true;
                }
            }
            message = message + str;
        }
        catch (DevFailed e) {
            try {
                dev.ping();
                ok = true;
            }
            catch (DevFailed ex) {
                message = message + "\n=======================================\n";
                message = message + AstorUtil.strException((Exception)((Object)ex));
            }
        }
        this.browser.setText(message);
        return ok;
    }

    void showProfiler() {
        try {
            Object o = this.getSelectedNode().getUserObject();
            if (o instanceof BrowserDevice) {
                new PollingProfiler((JFrame)this.browser, ((BrowserDevice)((Object)o)).name).setVisible(true);
            } else if (o instanceof BrowserServer) {
                DeviceData argOut = ((BrowserServer)o).dev.command_inout("QueryDevice");
                String[] deviceNames = argOut.extractStringArray();
                String s = "::";
                for (int i = 0; i < deviceNames.length; ++i) {
                    int idx = deviceNames[i].indexOf(s);
                    if (idx <= 0) continue;
                    deviceNames[i] = deviceNames[i].substring(idx + s.length());
                }
                new PollingProfiler((JFrame)this.browser, deviceNames).setVisible(true);
            }
        }
        catch (DevFailed e) {
            Utils.popupError(this.browser, null, (Exception)((Object)e));
        }
    }

    String getSelectedName() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            return ((BrowserAttribute)o).name;
        }
        if (o instanceof BrowserDevice) {
            return ((BrowserDevice)((Object)o)).name;
        }
        if (o instanceof BrowserServer) {
            return ((BrowserServer)o).name;
        }
        return "??";
    }

    private String getAttPollingInfo() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserAttribute) {
            try {
                String[] poll_status;
                BrowserAttribute att = (BrowserAttribute)o;
                String header = "Polled attribute name = ";
                for (String line : poll_status = att.dev.polling_status()) {
                    String s = line.substring(header.length(), line.indexOf(10));
                    if (!s.toLowerCase().equals(att.name.toLowerCase())) continue;
                    return line;
                }
            }
            catch (DevFailed e) {
                return e.toString();
            }
        }
        return "";
    }

    private void displayEventProperties(BrowserAttribute attr) {
        this.displayEventProperties(attr.attname);
    }

    void displayEventProperties(String attname) {
        String str = "";
        try {
            AttributeProxy ap = new AttributeProxy(attname);
            int att_idl_version = ap.get_idl_version();
            if (att_idl_version < 3) {
                this.browser.setText("Device_" + att_idl_version + "Impl not supported.");
                return;
            }
            AttributeInfoEx info = ap.get_info_ex();
            if (info.events != null) {
                str = attname;
                str = str + "\n\nChange event properties:\n";
                if (info.events.ch_event != null) {
                    str = str + "abs_change :   " + info.events.ch_event.abs_change + "\n";
                    str = str + "rel_change :   " + info.events.ch_event.rel_change + "\n";
                } else {
                    str = str + "rel_change :   Not specified\n";
                    str = str + "abs_change :   Not specified\n";
                }
                str = str + "\n\nPeriodic event properties:\n";
                str = info.events.per_event != null ? str + "period     :   " + info.events.per_event.period : str + "period     :   Not specified";
                str = str + "\n\nArchive event properties:\n";
                if (info.events.arch_event != null) {
                    str = str + "abs_change :   " + info.events.arch_event.abs_change + "\n";
                    str = str + "rel_change :   " + info.events.arch_event.rel_change + "\n";
                    str = str + "period     :   " + info.events.arch_event.period;
                } else {
                    str = str + "rel_change :   Not specified\n";
                    str = str + "abs_change :   Not specified\n";
                    str = str + "period     :   Not specified";
                }
            }
            str = str + "\n\n\n" + this.getAttPollingInfo();
            this.browser.setText(str);
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    void deviceTest() {
        Object o = this.getSelectedNode().getUserObject();
        String deviceName = null;
        if (o instanceof BrowserDevice) {
            deviceName = ((BrowserDevice)((Object)o)).name;
        } else if (o instanceof BrowserServer) {
            deviceName = "dserver/" + ((BrowserServer)o).name;
        }
        if (deviceName != null) {
            try {
                JDialog d = new JDialog((Frame)this.browser, false);
                d.setTitle(deviceName + " Device Panel");
                d.setContentPane((Container)new ExecDev(deviceName));
                ATKGraphicsUtils.centerDialog((Dialog)d);
                d.setVisible(true);
            }
            catch (DevFailed e) {
                Utils.popupError(this.browser, null, (Exception)((Object)e));
            }
        }
    }

    void serverArchitecture() {
        Object o = this.getSelectedNode().getUserObject();
        String serverName = null;
        try {
            if (o instanceof BrowserDevice) {
                BrowserDevice dev = (BrowserDevice)((Object)o);
                DeviceInfo info = dev.get_info();
                serverName = info.server;
            } else if (o instanceof BrowserServer) {
                serverName = ((BrowserServer)o).name;
            }
            if (serverName != null) {
                ServArchitectureDialog sad = new ServArchitectureDialog(this.browser, serverName);
                ATKGraphicsUtils.centerDialog((Dialog)sad);
                sad.setVisible(true);
            }
        }
        catch (DevFailed e) {
            this.displayException((Exception)((Object)e));
        }
    }

    private void displayException(Exception e) {
        this.browser.setText(AstorUtil.strException(e));
    }

    void deviceMonitor() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserDevice) {
            String devname = ((BrowserDevice)((Object)o)).name;
            MainPanel atkpanel = new MainPanel(devname, false, true);
            ATKGraphicsUtils.centerFrameOnScreen((Frame)atkpanel);
        }
    }

    DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    private BrowserAttribute getAttribute(Object o) {
        if (o == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
        Object obj = node.getUserObject();
        if (obj instanceof BrowserAttribute) {
            return (BrowserAttribute)obj;
        }
        return null;
    }

    void add(int mode) {
        BrowserAttribute attr = this.getAttribute(this.getSelectedNode());
        if (attr != null) {
            this.browser.add(attr.attname, mode);
        }
    }

    void editProperties(int mode) {
        BrowserAttribute attr = this.getAttribute(this.getSelectedNode());
        if (attr != null) {
            new PropertyDialog(this.browser, attr.attname, mode).showDialog();
            this.displayEventProperties(attr);
        }
    }

    void managePolling() {
        BrowserAttribute attr = this.getAttribute(this.getSelectedNode());
        if (attr != null) {
            this.browser.managePolling(attr.dev, attr.name);
        } else {
            Object o = this.getSelectedNode().getUserObject();
            if (o instanceof BrowserDevice_2) {
                this.browser.managePolling(((BrowserDevice_2)((Object)o)).name);
            } else if (o instanceof BrowserDevice) {
                this.browser.managePolling(((BrowserDevice)((Object)o)).name);
            }
        }
    }

    void displayHostPanel() {
        Object o = this.getSelectedNode().getUserObject();
        String deviceName = null;
        if (o instanceof BrowserDevice) {
            deviceName = ((BrowserDevice)((Object)o)).name;
        } else if (o instanceof BrowserServer) {
            deviceName = "dserver/" + ((BrowserServer)o).name;
        }
        if (deviceName != null) {
            this.browser.displayHostPanel(deviceName);
        }
    }

    void gotoServer() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserDevice) {
            BrowserDevice dev = (BrowserDevice)((Object)o);
            try {
                DefaultMutableTreeNode node;
                int i;
                DeviceInfo info = dev.get_info();
                String serverName = info.server;
                String binaryFile = serverName.substring(0, serverName.indexOf(47));
                String instance = serverName.substring(serverName.indexOf(47) + 1);
                Object[] path = new DefaultMutableTreeNode[4];
                int idx = 0;
                path[idx] = this.root;
                boolean found = false;
                for (i = 0; !found && i < path[idx].getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)path[idx].getChildAt(i);
                    found = node.toString().equals("Servers");
                    if (!found) continue;
                    path[++idx] = node;
                }
                found = false;
                for (i = 0; !found && i < path[idx].getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)path[idx].getChildAt(i);
                    found = node.toString().equals(binaryFile);
                    if (!found) continue;
                    path[++idx] = node;
                }
                if (!found) {
                    this.browser.setText(binaryFile + " Not Found !");
                    return;
                }
                if (path[idx].getChildCount() == 1 && path[idx].getChildAt(0).toString().equals("dummy")) {
                    this.createInstanceNodes((DefaultMutableTreeNode)path[idx]);
                }
                found = false;
                for (i = 0; !found && i < path[idx].getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)((DefaultMutableTreeNode)path[idx]).getChildAt(i);
                    Object obj = node.getUserObject();
                    if (!(obj instanceof BrowserServer)) continue;
                    BrowserServer serv = (BrowserServer)obj;
                    found = serv.instance.equals(instance);
                    if (!found) continue;
                    path[++idx] = node;
                }
                if (!found) {
                    this.browser.setText(instance + " Not Found !");
                    return;
                }
                TreePath tp = new TreePath(path);
                this.setSelectionPath(tp);
                this.scrollPathToVisible(tp);
            }
            catch (DevFailed e) {
                this.displayException((Exception)((Object)e));
            }
        }
    }

    String getCollection() {
        Object o = this.getSelectedNode().getUserObject();
        if (o instanceof BrowserDevice_2) {
            return "Servers";
        }
        return "Devices";
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon tangoIcon = Utils.getInstance().getIcon("TransparentTango.gif", 0.15);
        private ImageIcon serv_icon = Utils.getInstance().getIcon("server.gif");
        private ImageIcon dev_icon = Utils.getInstance().getIcon("device.gif");
        private ImageIcon attr_icon = Utils.getInstance().getIcon("leaf.gif");
        private ImageIcon class_icon = Utils.getInstance().getIcon("class.gif");
        private Font[] fonts = new Font[3];
        private final int TITLE = 0;
        private final int DEVICE = 1;
        private final int ATTR = 2;

        public TangoRenderer() {
            this.fonts[0] = new Font("courrier", 1, 18);
            this.fonts[1] = new Font("Monospaced", 1, 12);
            this.fonts[2] = new Font("Monospaced", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(this.tangoIcon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof String) {
                    this.setFont(this.fonts[0]);
                    if (obj.toString().equals("Servers")) {
                        this.setIcon(this.serv_icon);
                    } else if (obj.toString().equals("Devices")) {
                        this.setIcon(this.dev_icon);
                    } else if (obj.toString().equals("Aliases")) {
                        this.setIcon(this.dev_icon);
                    } else {
                        this.setFont(this.fonts[1]);
                        this.setIcon(this.class_icon);
                    }
                } else if (node.getUserObject() instanceof BrowserAttribute) {
                    this.setFont(this.fonts[2]);
                    this.setIcon(this.attr_icon);
                } else if (node.getUserObject() instanceof BrowserDevice) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.dev_icon);
                } else if (node.getUserObject() instanceof BrowserServer) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(this.serv_icon);
                }
            }
            return this;
        }
    }

    private class BrowserAttribute {
        BrowserDevice dev;
        String name;
        String attname;

        BrowserAttribute(String name, BrowserDevice dev) {
            this.name = name;
            this.dev = dev;
            this.attname = dev.name + "/" + name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice_2
    extends BrowserDevice {
        BrowserDevice_2(String name) throws DevFailed {
            super(name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class BrowserDevice
    extends DeviceProxy {
        String name;
        String member;

        BrowserDevice(String name) throws DevFailed {
            super(name);
            this.name = name;
            int idx = name.lastIndexOf(47);
            this.member = idx < 0 ? name : name.substring(idx + 1);
        }

        BrowserDevice(String name, String aliasname) throws DevFailed {
            super(name);
            this.name = name;
            this.member = aliasname;
        }

        public String toString() {
            return this.member;
        }
    }

    private class BrowserServer {
        String name;
        String instance;
        BrowserDevice_2 dev;

        BrowserServer(String binfile, String instance) {
            this.name = binfile + "/" + instance;
            this.instance = instance;
            try {
                this.dev = new BrowserDevice_2("dserver/" + this.name);
            }
            catch (DevFailed e) {
                // empty catch block
            }
        }

        public String toString() {
            return this.instance;
        }
    }
}

