/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoClassRelease;
import admin.astor.tango_release.TangoServerRelease;
import admin.astor.tango_release.TangoServerReleaseList;
import admin.astor.tools.PopupText;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TangoReleaseTree
extends JTree
implements TangoConst {
    private JFrame appli;
    private DefaultMutableTreeNode root;
    private TangoReleaseTreePopupMenu menu;
    private int mode;
    private TangoServerReleaseList serverReleaseList;
    private static JFileChooser fileChooser = null;
    private static final double[] tangoReleases = new double[]{1.0, 2.0, 5.0, 5.2, 7.0, 8.0, 8.1};
    private static final int[] idlReleases = new int[]{1, 2, 3, 4, 5};
    private static ImageIcon networkIcon;
    private static ImageIcon tangoIcon;
    private static ImageIcon serverIcon;
    private static ImageIcon classIcon;
    private static final int ROOT_OPTION = 0;
    private static final int IN_TEXT_AREA = 1;
    private static final int SAVE = 2;
    private static final int OPEN_PANEL = 3;
    private static final int OFFSET = 2;
    private static String[] menuLabels;

    public TangoReleaseTree(JFrame frame, String rootName, TangoServerReleaseList serverReleaseList, int mode) {
        this.appli = frame;
        this.mode = mode;
        this.serverReleaseList = serverReleaseList;
        networkIcon = Utils.getInstance().getIcon("TangoClass.gif", 0.33);
        tangoIcon = Utils.getInstance().getIcon("TangoClass.gif", 0.125);
        serverIcon = Utils.getInstance().getIcon("server.gif");
        classIcon = Utils.getInstance().getIcon("class.gif");
        this.buildTree(rootName);
        this.menu = new TangoReleaseTreePopupMenu(this);
        this.setSelectionPath(null);
        fileChooser = new JFileChooser(new File("").getAbsolutePath());
    }

    private void buildTree(String rootName) {
        this.root = new DefaultMutableTreeNode(rootName);
        this.createCollectionClassNodes();
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
        this.setModel(treeModel);
        ToolTipManager.sharedInstance().registerComponent(this);
        TangoRenderer renderer = new TangoRenderer();
        this.setCellRenderer(renderer);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent e) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent e) {
                TangoReleaseTree.this.expandedPerformed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TangoReleaseTree.this.treeMouseClicked(evt);
            }
        });
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath selectedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getPathComponent(selectedPath.getPathCount() - 1);
        Object userObject = node.getUserObject();
        int mask = evt.getModifiers();
        if ((mask & 4) != 0) {
            if (userObject instanceof ServerCollectionClass) {
                this.menu.showMenu(evt, (ServerCollectionClass)userObject);
            } else if (userObject instanceof IdlCollectionClass) {
                this.menu.showMenu(evt, (IdlCollectionClass)userObject);
            } else if (userObject instanceof Executable) {
                this.menu.showMenu(evt, (Executable)userObject);
            } else if (userObject instanceof Instance && this.appli instanceof Astor) {
                this.menu.showMenu(evt, (Instance)userObject);
            }
        }
    }

    public void expandedPerformed(TreeExpansionEvent evt) {
    }

    private List<ServerCollectionClass> initCollectionsByTangoRelease() {
        ArrayList<ServerCollectionClass> serverCollectionClasses = new ArrayList<ServerCollectionClass>();
        for (double tangoRelease : tangoReleases) {
            List<TangoServerRelease> servers = this.serverReleaseList.getServersForTangoRelease(tangoRelease);
            if (servers.size() <= 0) continue;
            String text = "Tango-" + tangoRelease;
            if (tangoRelease == 7.0) {
                text = "Tango-7.x";
            } else if (tangoRelease == 5.2) {
                text = text + " or 6.x";
            }
            serverCollectionClasses.add(new ServerCollectionClass(text, servers));
        }
        for (int i = 90; i < 150; ++i) {
            double tangoRelease = 0.1 * (double)i;
            List<TangoServerRelease> servers = this.serverReleaseList.getServersForTangoRelease(tangoRelease);
            if (servers.size() <= 0) continue;
            String text = "Tango-" + tangoRelease;
            serverCollectionClasses.add(new ServerCollectionClass(text, servers));
        }
        List<TangoServerRelease> onError = this.serverReleaseList.getServersOnError();
        if (onError.size() > 0) {
            serverCollectionClasses.add(new ServerCollectionClass("Failed", onError));
        }
        return serverCollectionClasses;
    }

    private List<IdlCollectionClass> initCollectionsByIdlRelease() {
        ArrayList<IdlCollectionClass> idlCollectionClasses = new ArrayList<IdlCollectionClass>();
        for (int idlRelease : idlReleases) {
            List<TangoClassRelease> servers = this.serverReleaseList.getClassesForIdlRelease(idlRelease);
            if (servers.size() <= 0) continue;
            idlCollectionClasses.add(new IdlCollectionClass("Device_" + idlRelease + "Impl", servers));
        }
        return idlCollectionClasses;
    }

    private void createCollectionClassNodes() {
        switch (this.mode) {
            case 0: {
                List<ServerCollectionClass> serverCollectionClasses = this.initCollectionsByTangoRelease();
                for (ServerCollectionClass serverCollectionClass : serverCollectionClasses) {
                    DefaultMutableTreeNode tangoNode = new DefaultMutableTreeNode(serverCollectionClass);
                    this.root.add(tangoNode);
                    HashMap<String, DefaultMutableTreeNode> executableNodes = new HashMap<String, DefaultMutableTreeNode>();
                    for (TangoServerRelease serverRelease : serverCollectionClass.servers) {
                        DefaultMutableTreeNode exeNode = (DefaultMutableTreeNode)executableNodes.get(serverRelease.exeName);
                        if (exeNode == null) {
                            exeNode = new DefaultMutableTreeNode(new Executable(serverRelease.exeName));
                            executableNodes.put(serverRelease.exeName, exeNode);
                            tangoNode.add(exeNode);
                        }
                        DefaultMutableTreeNode instanceNode = new DefaultMutableTreeNode(new Instance(serverRelease));
                        exeNode.add(instanceNode);
                        for (TangoClassRelease classRelease : serverRelease) {
                            instanceNode.add(new DefaultMutableTreeNode(classRelease));
                        }
                    }
                }
                break;
            }
            case 1: {
                List<IdlCollectionClass> idlCollectionClasses = this.initCollectionsByIdlRelease();
                for (IdlCollectionClass idlCollectionClass : idlCollectionClasses) {
                    DefaultMutableTreeNode idlNode = new DefaultMutableTreeNode(idlCollectionClass);
                    this.root.add(idlNode);
                    for (TangoClassRelease classRelease : idlCollectionClass.classes) {
                        DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(classRelease);
                        idlNode.add(classNode);
                        classNode.add(new DefaultMutableTreeNode(classRelease.serverName));
                    }
                }
                break;
            }
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
    }

    Object getSelectedObject() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void expandChildren(DefaultMutableTreeNode node) {
        boolean level_done = false;
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (child.isLeaf()) {
                if (level_done) continue;
                this.expandNode(child);
                level_done = true;
                continue;
            }
            this.expandChildren(child);
        }
    }

    private void expandNode(DefaultMutableTreeNode node) {
        ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
        list.add(node);
        while (node != this.root) {
            node = (DefaultMutableTreeNode)node.getParent();
            list.add(0, node);
        }
        Object[] tn = list.toArray(new TreeNode[list.size()]);
        TreePath tp = new TreePath(tn);
        this.setSelectionPath(tp);
        this.scrollPathToVisible(tp);
    }

    private void saveCollection() {
        File file;
        if (fileChooser.showOpenDialog(this) == 0 && (file = fileChooser.getSelectedFile()) != null && !file.isDirectory()) {
            String fileName = file.getAbsolutePath();
            if (new File(fileName).exists() && JOptionPane.showConfirmDialog(this, "The File " + fileName + "  Already Exists !\n\n" + "Would you like to overwrite ?", "information", 0) != 0) {
                return;
            }
            String title = this.getSelectedObject().toString();
            String text = title + "\n\n" + this.getCollectionText();
            try {
                AstorUtil.writeFile(fileName, text);
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
    }

    private void displayCollection() {
        String title = this.getSelectedObject().toString();
        String text = this.getCollectionText();
        PopupText popupText = new PopupText((Frame)this.appli, true);
        popupText.setTitle(title);
        popupText.addText(text);
        popupText.setSize(400, 500);
        ATKGraphicsUtils.centerDialog((Dialog)popupText);
        popupText.setVisible(true);
    }

    private String getCollectionText() {
        StringBuilder sb;
        block5: {
            Object object;
            DefaultMutableTreeNode node;
            block6: {
                block4: {
                    node = this.getSelectedNode();
                    sb = new StringBuilder();
                    object = node.getUserObject();
                    if (!(object instanceof ServerCollectionClass)) break block4;
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        DefaultMutableTreeNode exeNode = (DefaultMutableTreeNode)node.getChildAt(i);
                        for (int j = 0; j < exeNode.getChildCount(); ++j) {
                            DefaultMutableTreeNode instanceNode = (DefaultMutableTreeNode)exeNode.getChildAt(j);
                            TangoServerRelease serverRelease = ((Instance)instanceNode.getUserObject()).server;
                            sb.append(serverRelease.toStringFull()).append("\n");
                        }
                    }
                    break block5;
                }
                if (!(object instanceof IdlCollectionClass)) break block6;
                for (int i = 0; i < node.getChildCount(); ++i) {
                    DefaultMutableTreeNode classNode = (DefaultMutableTreeNode)node.getChildAt(i);
                    sb.append(classNode.toString()).append("\n");
                }
                break block5;
            }
            if (!(object instanceof Executable)) break block5;
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode instanceNode = (DefaultMutableTreeNode)node.getChildAt(i);
                TangoServerRelease serverRelease = ((Instance)instanceNode.getUserObject()).server;
                sb.append(serverRelease.toStringFull()).append("\n");
            }
        }
        return sb.toString();
    }

    static {
        menuLabels = new String[]{"Root Options", "Display in Text Area", "Save", "Open server panel"};
    }

    private class TangoReleaseTreePopupMenu
    extends JPopupMenu {
        private JTree tree;
        private JLabel title;

        private TangoReleaseTreePopupMenu(JTree tree) {
            this.tree = tree;
            this.buildBtnPopupMenu();
        }

        private void buildBtnPopupMenu() {
            this.title = new JLabel();
            this.title.setFont(new Font("Dialog", 1, 16));
            this.add(this.title);
            this.add(new JPopupMenu.Separator());
            for (String menuLabel : menuLabels) {
                if (menuLabel == null) {
                    this.add(new JPopupMenu.Separator());
                    continue;
                }
                JMenuItem btn = new JMenuItem(menuLabel);
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        TangoReleaseTreePopupMenu.this.hostActionPerformed(evt);
                    }
                });
                this.add(btn);
            }
        }

        public void showMenu(MouseEvent evt, String name) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(2).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, ServerCollectionClass serverCollectionClass) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(serverCollectionClass.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, IdlCollectionClass idlCollectionClass) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(idlCollectionClass.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, Executable executable) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(executable.toString());
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(3).setVisible(true);
            this.getComponent(4).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        public void showMenu(MouseEvent evt, Instance instance) {
            TreePath selectedPath = this.tree.getPathForLocation(evt.getX(), evt.getY());
            if (selectedPath == null) {
                return;
            }
            this.tree.setSelectionPath(selectedPath);
            this.title.setText(instance.server.name);
            for (int i = 0; i < menuLabels.length; ++i) {
                this.getComponent(2 + i).setVisible(false);
            }
            this.getComponent(5).setVisible(true);
            this.show(this.tree, evt.getX(), evt.getY());
        }

        private void hostActionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            int commandIndex = 0;
            for (int i = 0; i < menuLabels.length; ++i) {
                if (this.getComponent(2 + i) != obj) continue;
                commandIndex = i;
            }
            switch (commandIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    TangoReleaseTree.this.displayCollection();
                    break;
                }
                case 2: {
                    TangoReleaseTree.this.saveCollection();
                    break;
                }
                case 3: {
                    Object object = TangoReleaseTree.this.getSelectedObject();
                    if (!(object instanceof Instance)) break;
                    String server = ((Instance)object).server.name;
                    if (!(TangoReleaseTree.this.appli instanceof Astor)) break;
                    ((Astor)((TangoReleaseTree)TangoReleaseTree.this).appli).tree.displayHostInfo("dserver/" + server);
                }
            }
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private Font[] fonts = new Font[4];
        private final int TITLE = 0;
        private final int COLLEC = 1;
        private final int SERVER = 2;
        private final int CLASS = 3;

        public TangoRenderer() {
            this.fonts[0] = new Font("Dialog", 1, 18);
            this.fonts[1] = new Font("Dialog", 1, 14);
            this.fonts[2] = new Font("Dialog", 1, 12);
            this.fonts[3] = new Font("Dialog", 0, 12);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setBackgroundNonSelectionColor(Color.white);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            if (row == 0) {
                this.setFont(this.fonts[0]);
                this.setIcon(networkIcon);
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                if (node.getUserObject() instanceof ServerCollectionClass || node.getUserObject() instanceof IdlCollectionClass) {
                    this.setFont(this.fonts[1]);
                    this.setIcon(tangoIcon);
                } else if (node.getUserObject() instanceof Executable || node.getUserObject() instanceof Instance) {
                    this.setFont(this.fonts[2]);
                    this.setIcon(serverIcon);
                } else if (node.getUserObject() instanceof TangoClassRelease) {
                    this.setFont(this.fonts[3]);
                    this.setIcon(classIcon);
                }
            }
            return this;
        }
    }

    private class IdlCollectionClass {
        String name;
        List<TangoClassRelease> classes;

        private IdlCollectionClass(String name, List<TangoClassRelease> classes) {
            this.name = name;
            this.classes = classes;
        }

        public String toString() {
            return this.name + "  (" + this.classes.size() + ")";
        }
    }

    private class ServerCollectionClass {
        String name;
        List<TangoServerRelease> servers;

        private ServerCollectionClass(String name, List<TangoServerRelease> servers) {
            this.name = name;
            this.servers = servers;
        }

        public String toString() {
            return this.name + "  (" + this.servers.size() + ")";
        }
    }

    private class Instance {
        String name;
        TangoServerRelease server;

        private Instance(TangoServerRelease server) {
            this.server = server;
            this.name = server.instanceName;
            this.name = server.releaseNumber >= 1.0 ? this.name + "  (Tango-" + String.format("%1.1f", server.releaseNumber) + ")" : this.name + "  (" + server.error + ")";
        }

        public String toString() {
            return this.name;
        }
    }

    private class Executable {
        String name;

        private Executable(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

