/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.tools.BlackBoxTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import javax.swing.JFrame;

public class TACobject
extends DeviceProxy
implements AstorDefs {
    private AstorTree parent;
    private String deviceName;
    private StateThread state_thread;
    int state = 0;
    DevFailed except = null;

    public TACobject(AstorTree parent, String deviceName) throws DevFailed {
        super(deviceName);
        this.parent = parent;
        this.deviceName = deviceName;
        this.state_thread = new StateThread();
        this.state_thread.start();
    }

    String getCvsTag() throws DevFailed {
        int end;
        String tagName = null;
        DevInfo info = this.info();
        String servinfo = info.doc_url;
        String tag = "CVS Tag = ";
        int start = servinfo.indexOf(tag);
        if (start > 0 && (end = servinfo.indexOf(10, start += tag.length())) > start) {
            tagName = servinfo.substring(start, end);
        }
        if (tagName == null) {
            return "";
        }
        return "CVS Tag:   " + tagName + "\n";
    }

    String getServerInfo() throws DevFailed {
        String str = "Tango Access Control:\n\n";
        str = str + this.get_info() + "\n\n";
        str = str + this.getCvsTag();
        str = str + "\n\n";
        return str;
    }

    void start() {
        this.state_thread.start();
    }

    void blackbox(JFrame parent) {
        try {
            new BlackBoxTable(parent, this.deviceName).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    public String toString() {
        return "Access Control";
    }

    private class StateThread
    extends Thread {
        private StateThread() {
            this.setName("TAC State Thread");
        }

        private synchronized void wait_next_loop() {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void updateParent(int tmp_state, DevFailed tmp_except) {
            if (TACobject.this.state != tmp_state || TACobject.this.except != tmp_except) {
                TACobject.this.state = tmp_state;
                TACobject.this.except = tmp_except;
                TACobject.this.parent.updateState();
            }
        }

        private void manageState() {
            DevFailed tmp_except;
            int tmp_state;
            try {
                TACobject.this.ping();
                tmp_state = 4;
                tmp_except = null;
            }
            catch (DevFailed e) {
                tmp_state = 1;
                tmp_except = e;
            }
            this.updateParent(tmp_state, tmp_except);
        }

        @Override
        public void run() {
            while (true) {
                this.manageState();
                this.wait_next_loop();
            }
        }
    }
}

