/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.Astor;
import admin.astor.AstorUtil;
import admin.astor.GetTextDialog;
import admin.astor.tools.LastBranchesListDialog;
import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;

public class PreferenceDialog
extends JDialog {
    private JFrame parent;
    private String csName = "";
    private boolean lastCollectionsChanged = false;
    private String[] lastCollections = new String[0];
    private String[] known_tango_hosts = new String[0];
    private String[] tools = new String[0];
    private String[] pages = new String[]{"Device Servers", "http://www.esrf.fr/computing/cs/tango/tango_doc/ds_doc/index.html"};
    private boolean jiveReadOnly = false;
    private boolean starterStart = true;
    private JTextField hostDlgHeighttTxt;
    private JTextField hostDlgWidthtTxt;
    private JRadioButton jiveRObtn;
    private JTextField nameText;
    private JTextField rshCmdTxt;
    private JTextField rshUserTxt;
    private JRadioButton starterStartupBtn;
    private JLabel titleLabel;
    private JTextField treeHeighttTxt;
    private JTextField treeWidthtTxt;

    PreferenceDialog(JFrame parent) {
        super((Frame)parent, true);
        this.parent = parent;
        this.initComponents();
        this.initialize();
        try {
            this.csName = AstorUtil.getControlSystemName();
            if (this.csName != null) {
                this.nameText.setText(this.csName);
            }
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        this.titleLabel.setText(AstorUtil.getTangoHost() + "  preferences");
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    public boolean isLastCollectionsChanged() {
        return this.lastCollectionsChanged;
    }

    private void storePreferences() {
        String rl_user = this.rshUserTxt.getText();
        String rl_cmd = this.rshCmdTxt.getText();
        if (rl_user == null) {
            rl_user = "";
        }
        if (rl_cmd == null) {
            rl_cmd = "";
        }
        if (this.tools == null) {
            this.tools = new String[0];
        }
        if (this.lastCollections == null) {
            this.lastCollections = new String[0];
        }
        if (this.known_tango_hosts == null) {
            this.known_tango_hosts = new String[0];
        }
        if (this.pages == null) {
            this.pages = new String[0];
        }
        AstorUtil util = AstorUtil.getInstance();
        util.setJiveReadOnly(this.jiveReadOnly);
        util.setStarterStartup(this.starterStart);
        AstorUtil.setRloginUser(rl_user);
        AstorUtil.setRloginCmd(rl_cmd);
        util.setLastCollectionList(this.lastCollections);
        AstorUtil.setKnownTangoHosts(this.known_tango_hosts);
        AstorUtil.setTools(this.tools);
        AstorUtil.setHtmlHelps(this.pages);
        if (this.parent instanceof Astor) {
            try {
                int w = Integer.parseInt(this.treeWidthtTxt.getText());
                int h = Integer.parseInt(this.treeHeighttTxt.getText());
                Dimension d = new Dimension(w, h);
                ((Astor)this.parent).setTreeSize(d);
                AstorUtil.setPreferredSize(d);
                w = Integer.parseInt(this.hostDlgWidthtTxt.getText());
                h = Integer.parseInt(this.hostDlgHeighttTxt.getText());
                d = new Dimension(w, h);
                AstorUtil.setHostDialogPreferredSize(d);
                ((Astor)this.parent).tree.hostDialogs.setDialogPreferredSize(d);
            }
            catch (NumberFormatException e) {
                ErrorPane.showErrorMessage((Component)this, null, (Exception)e);
            }
        }
        try {
            AstorUtil.putAstorProperties();
            Utils.popupMessage(this, "The preferences have been saved for " + AstorUtil.getTangoHost());
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, (String)"Cannot put Astor properties", (DevFailed)e);
        }
        try {
            String name = this.nameText.getText();
            if (!name.equals(this.csName)) {
                AstorUtil.setControlSystemName(name);
                this.csName = name;
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void initialize() {
        String rl_cmd;
        AstorUtil util = AstorUtil.getInstance();
        this.lastCollections = util.getLastCollectionList();
        this.known_tango_hosts = AstorUtil.getDbaseKnownTangoHosts();
        this.tools = AstorUtil.getTools();
        this.pages = AstorUtil.getHtmlHelps();
        this.jiveReadOnly = util.jiveIsReadOnly();
        this.manageToggleBtn(this.jiveRObtn, this.jiveReadOnly);
        this.starterStart = util.getStarterStartup();
        this.manageToggleBtn(this.starterStartupBtn, this.starterStart);
        String rl_user = AstorUtil.getRloginUser();
        if (rl_user != null) {
            this.rshUserTxt.setText(rl_user);
        }
        if ((rl_cmd = AstorUtil.getRloginCmd()) != null) {
            this.rshCmdTxt.setText(rl_cmd);
        }
        if (this.parent instanceof Astor) {
            Dimension d = ((Astor)this.parent).getTreeSize();
            this.treeWidthtTxt.setText(Integer.toString(d.width));
            this.treeHeighttTxt.setText(Integer.toString(d.height));
            d = AstorUtil.getHostDialogPreferredSize();
            this.hostDlgWidthtTxt.setText(Integer.toString(d.width));
            this.hostDlgHeighttTxt.setText(Integer.toString(d.height));
        }
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JPanel topTopPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomTopPanel = new JPanel();
        JLabel nameLabel = new JLabel();
        this.nameText = new JTextField();
        JPanel prefPanel = new JPanel();
        JLabel treeWidthLbl = new JLabel();
        this.treeWidthtTxt = new JTextField();
        JLabel treeHeightLbl = new JLabel();
        this.treeHeighttTxt = new JTextField();
        JSeparator jSeparator1 = new JSeparator();
        JLabel jLabel1 = new JLabel();
        this.rshUserTxt = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.rshCmdTxt = new JTextField();
        JSeparator jSeparator2 = new JSeparator();
        JSeparator jSeparator3 = new JSeparator();
        JLabel jLabel5 = new JLabel();
        this.jiveRObtn = new JRadioButton();
        JSeparator jSeparator5 = new JSeparator();
        JSeparator jSeparator7 = new JSeparator();
        JButton lastCollectionBtn = new JButton();
        JButton tangoHostsBtn = new JButton();
        JButton toolsBtn = new JButton();
        JButton helpPagesBtn = new JButton();
        JLabel hostDlgWidthLbl = new JLabel();
        JLabel hostDlgHeightLbl = new JLabel();
        this.hostDlgWidthtTxt = new JTextField();
        this.hostDlgHeighttTxt = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.starterStartupBtn = new JRadioButton();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferenceDialog.this.closeDialog(evt);
            }
        });
        topPanel.setLayout(new BorderLayout());
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topTopPanel.add(this.titleLabel);
        topPanel.add((Component)topTopPanel, "North");
        nameLabel.setFont(new Font("Dialog", 1, 14));
        nameLabel.setText("name:");
        bottomTopPanel.add(nameLabel);
        this.nameText.setColumns(20);
        this.nameText.setFont(new Font("Dialog", 1, 12));
        bottomTopPanel.add(this.nameText);
        topPanel.add((Component)bottomTopPanel, "South");
        this.getContentPane().add((Component)topPanel, "North");
        prefPanel.setLayout(new GridBagLayout());
        treeWidthLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        treeWidthLbl.setHorizontalAlignment(4);
        treeWidthLbl.setText("Hosts Tree Width:  ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)treeWidthLbl, gridBagConstraints);
        this.treeWidthtTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)this.treeWidthtTxt, gridBagConstraints);
        treeHeightLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        treeHeightLbl.setHorizontalAlignment(4);
        treeHeightLbl.setText("Hosts Tree Height:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)treeHeightLbl, gridBagConstraints);
        this.treeHeighttTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)this.treeHeighttTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        prefPanel.add((Component)jSeparator1, gridBagConstraints);
        jLabel1.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel1.setHorizontalAlignment(4);
        jLabel1.setText("Remote login user :  ");
        jLabel1.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)jLabel1, gridBagConstraints);
        this.rshUserTxt.setColumns(12);
        this.rshUserTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshUserTxt.setToolTipText("Default user name used for remote login on a host.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)this.rshUserTxt, gridBagConstraints);
        jLabel2.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText("Remote login command :  ");
        jLabel2.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)jLabel2, gridBagConstraints);
        this.rshCmdTxt.setColumns(12);
        this.rshCmdTxt.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.rshCmdTxt.setText("rlogin");
        this.rshCmdTxt.setToolTipText("Command used for remote login on a host (rlogin, ssh, ...).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)this.rshCmdTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        prefPanel.add((Component)jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        prefPanel.add((Component)jSeparator3, gridBagConstraints);
        jLabel5.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel5.setText("Start Jive in READ_ONLY mode :");
        jLabel5.setToolTipText("Mode to start jive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        prefPanel.add((Component)jLabel5, gridBagConstraints);
        this.jiveRObtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.jiveRObtn.setText("false");
        this.jiveRObtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jiveRObtn.setMargin(new Insets(0, 0, 0, 0));
        this.jiveRObtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.jiveRObtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        prefPanel.add((Component)this.jiveRObtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        prefPanel.add((Component)jSeparator5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        prefPanel.add((Component)jSeparator7, gridBagConstraints);
        lastCollectionBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        lastCollectionBtn.setText("Last Collections :");
        lastCollectionBtn.setToolTipText("List of collections (families) displayed at the end of the control system tree.");
        lastCollectionBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.lastCollectionBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)lastCollectionBtn, gridBagConstraints);
        tangoHostsBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        tangoHostsBtn.setText("Known Tango Hosts");
        tangoHostsBtn.setToolTipText("List of   TANGO_HOST known (used to change during execution).");
        tangoHostsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.tangoHostsBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)tangoHostsBtn, gridBagConstraints);
        toolsBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        toolsBtn.setText("Additional tools :");
        toolsBtn.setToolTipText("List of  additiannal tools (see  Astor pages).");
        toolsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.toolsBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)toolsBtn, gridBagConstraints);
        helpPagesBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        helpPagesBtn.setText("Help pages");
        helpPagesBtn.setToolTipText("List of   help  pages (as tools see Astor pages).");
        helpPagesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.helpPagesBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)helpPagesBtn, gridBagConstraints);
        hostDlgWidthLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        hostDlgWidthLbl.setHorizontalAlignment(4);
        hostDlgWidthLbl.setText("Host Panel Width:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)hostDlgWidthLbl, gridBagConstraints);
        hostDlgHeightLbl.setFont(new Font("Microsoft Sans Serif", 1, 12));
        hostDlgHeightLbl.setHorizontalAlignment(4);
        hostDlgHeightLbl.setText("Host Panel Height:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)hostDlgHeightLbl, gridBagConstraints);
        this.hostDlgWidthtTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)this.hostDlgWidthtTxt, gridBagConstraints);
        this.hostDlgHeighttTxt.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        prefPanel.add((Component)this.hostDlgHeighttTxt, gridBagConstraints);
        jLabel6.setFont(new Font("Microsoft Sans Serif", 1, 12));
        jLabel6.setText("Starter starts servers at startup:");
        jLabel6.setToolTipText("Mode to start jive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        prefPanel.add((Component)jLabel6, gridBagConstraints);
        this.starterStartupBtn.setFont(new Font("Microsoft Sans Serif", 1, 12));
        this.starterStartupBtn.setSelected(true);
        this.starterStartupBtn.setText("true");
        this.starterStartupBtn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.starterStartupBtn.setMargin(new Insets(0, 0, 0, 0));
        this.starterStartupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.starterStartupBtnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        prefPanel.add((Component)this.starterStartupBtn, gridBagConstraints);
        this.getContentPane().add((Component)prefPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferenceDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void helpPagesBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.pages);
        if (dlg.showDialog() == 0) {
            this.pages = dlg.getTextLinesAsArray();
        }
    }

    private void toolsBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.tools);
        if (dlg.showDialog() == 0) {
            this.tools = dlg.getTextLinesAsArray();
        }
    }

    private void tangoHostsBtnActionPerformed(ActionEvent evt) {
        JButton btn = (JButton)evt.getSource();
        GetTextDialog dlg = new GetTextDialog(this, btn.getText(), btn.getToolTipText(), this.known_tango_hosts);
        if (dlg.showDialog() == 0) {
            this.known_tango_hosts = dlg.getTextLinesAsArray();
        }
    }

    private void lastCollectionBtnActionPerformed(ActionEvent evt) {
        try {
            LastBranchesListDialog dialog = new LastBranchesListDialog(this.parent, AstorUtil.getInstance().getCollectionList(), this.lastCollections);
            if (dialog.showDialog() == 0) {
                String[] tmp = dialog.getLastBranches();
                this.lastCollectionsChanged = tmp != this.lastCollections;
                this.lastCollections = tmp;
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
    }

    private void manageToggleBtn(JToggleButton btn, boolean b) {
        btn.setSelected(b);
        btn.setText("" + b);
    }

    private void jiveRObtnActionPerformed(ActionEvent evt) {
        this.jiveReadOnly = this.jiveRObtn.getSelectedObjects() != null;
        this.manageToggleBtn(this.jiveRObtn, this.jiveReadOnly);
    }

    private void starterStartupBtnActionPerformed(ActionEvent evt) {
        this.starterStart = this.starterStartupBtn.getSelectedObjects() != null;
        this.manageToggleBtn(this.starterStartupBtn, this.starterStart);
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.storePreferences();
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        if (this.parent instanceof Astor) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        new PreferenceDialog(new JFrame()).setVisible(true);
    }
}

