/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class MkStarter {
    private final String[] polled_obj_names = new String[]{"HostState", "RunningServers", "StoppedServers"};
    private final String[] logging_properties = new String[]{"logging_level", "logging_target", "logging_rft"};
    private String hostname;
    private String[] ds_path;
    private boolean use_events = false;
    private String classname = "Starter";
    private String serverName;
    private String deviceName;
    private DeviceProxy dev;
    private static final int polling_period = 1000;

    public MkStarter() throws DevFailed {
        this.getEnvironment();
        this.serverName = this.classname + "/" + this.hostname;
        this.deviceName = AstorUtil.getStarterDeviceHeader() + this.hostname;
    }

    public MkStarter(String hostname, String[] ds_path, boolean use_events) throws DevFailed {
        this.hostname = hostname;
        this.ds_path = ds_path;
        this.use_events = use_events;
        this.serverName = this.classname + "/" + hostname;
        this.deviceName = AstorUtil.getStarterDeviceHeader() + hostname;
    }

    public void create() throws DevFailed {
        boolean exists = false;
        try {
            new DeviceProxy(this.deviceName);
            exists = true;
        }
        catch (DevFailed e) {
            // empty catch block
        }
        if (exists) {
            Except.throw_exception((String)"DeviceAlreadyExists", (String)(this.serverName + " is already exits in database."), (String)"MkStarter.MkStarter()");
        }
        Database db = ApiUtil.get_db_obj();
        db.add_device(this.deviceName, this.classname, this.serverName);
    }

    public void setProperties() throws DevFailed {
        this.dev = new DeviceProxy(this.deviceName);
        this.dev.put_property(new DbDatum("StartDsPath", this.ds_path));
        String[] valStr = new String[]{"WARNING", "file::/tmp/ds.log/starter_" + this.hostname + ".log", Integer.toString(500)};
        DbDatum[] datum = new DbDatum[this.logging_properties.length];
        for (int i = 0; i < this.logging_properties.length; ++i) {
            datum[i] = new DbDatum(this.logging_properties[i], valStr[i]);
        }
        this.dev.put_property(datum);
        this.setPollProperty();
        DbDatum data = new DbDatum("UseEvents", this.use_events ? 1 : 0);
        this.dev.put_property(data);
    }

    private void setPollProperty() throws DevFailed {
        String str_period = "1000";
        String[] pollProp = new String[2 * this.polled_obj_names.length];
        for (int i = 0; i < this.polled_obj_names.length; ++i) {
            pollProp[2 * i] = this.polled_obj_names[i].toLowerCase();
            pollProp[2 * i + 1] = str_period;
        }
        DbDatum data = new DbDatum("polled_attr");
        data.insert(pollProp);
        this.dev.put_property(data);
    }

    public void setAdditionalProperties(String propertyName, String propertyValue, boolean create) throws DevFailed {
        if (propertyValue.length() > 0) {
            this.dev.put_property(new DbDatum(propertyName, propertyValue));
        } else if (!create) {
            this.dev.delete_property(propertyName);
        }
    }

    private void getEnvironment() throws DevFailed {
        String dp;
        this.hostname = System.getProperty("HOST_NAME");
        if (this.hostname == null) {
            Except.throw_exception((String)"EnvironmentException", (String)"HOST_NAME is not defined.", (String)"MkStarter.getEnvironment()");
        }
        if ((dp = System.getProperty("DS_PATH")) == null) {
            Except.throw_exception((String)"EnvironmentException", (String)"DS_PATH is not defined.", (String)"MkStarter.getEnvironment()");
        }
        this.ds_path = new String[1];
        this.ds_path[0] = dp;
        String str = System.getProperty("USE_EVENTS");
        if (str != null && str.toLowerCase().equals("true")) {
            this.use_events = true;
        }
    }

    public static void main(String[] args) {
        try {
            MkStarter starter = new MkStarter();
            starter.create();
            starter.setProperties();
        }
        catch (DevFailed e) {
            System.out.println();
            Except.print_exception((Exception)((Object)e));
            System.exit(-1);
        }
        System.exit(0);
    }
}

