/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorDefs;
import admin.astor.AstorTree;
import admin.astor.tools.BlackBoxTable;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import javax.swing.JFrame;

public class DbaseObject
implements AstorDefs {
    private AstorTree parent;
    private String tango_host;
    private DbaseState state_thread;
    int state = 0;
    DevFailed except = null;

    public DbaseObject(AstorTree parent, String tango_host) {
        this.parent = parent;
        this.tango_host = tango_host;
        this.state_thread = new DbaseState();
        this.state_thread.start();
    }

    void start() {
        this.state_thread.start();
    }

    String getCvsTag(DeviceProxy dev) throws DevFailed {
        int end;
        String tagName = null;
        DevInfo info = dev.info();
        String servinfo = info.doc_url;
        String tag = "CVS Tag = ";
        int start = servinfo.indexOf(tag);
        if (start > 0 && (end = servinfo.indexOf(10, start += tag.length())) > start) {
            tagName = servinfo.substring(start, end);
        }
        if (tagName == null) {
            return "";
        }
        return "CVS Tag:   " + tagName + "\n";
    }

    String getServerInfo() throws DevFailed {
        String devname = this.state_thread.db.get_name();
        DeviceProxy dev = new DeviceProxy(devname);
        String str = "TANGO_HOST:    " + this.tango_host + "\n\n";
        str = str + dev.get_info() + "\n\n";
        str = str + this.getCvsTag(dev);
        try {
            DeviceAttribute att = dev.read_attribute("StoredProcedureRelease");
            str = str + "Stored Procedure: " + att.extractString();
        }
        catch (DevFailed e) {
            // empty catch block
        }
        str = str + "\n\n";
        return str;
    }

    String getInfo() throws DevFailed {
        Database db = ApiUtil.get_db_obj((String)this.tango_host);
        return db.get_info();
    }

    void blackbox(JFrame parent) {
        try {
            new BlackBoxTable(parent, this.state_thread.db.getDeviceName()).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)parent, null, (DevFailed)e);
        }
    }

    public String toString() {
        return this.tango_host;
    }

    private class DbaseState
    extends Thread {
        private String host;
        private String port;
        private DbConnection db = null;

        private DbaseState() {
            this.setName("Database State Thread");
            int idx = DbaseObject.this.tango_host.indexOf(":");
            this.host = DbaseObject.this.tango_host.substring(0, idx);
            this.port = DbaseObject.this.tango_host.substring(idx + 1);
        }

        private synchronized void wait_next_loop() {
            try {
                this.wait(2000L);
            }
            catch (InterruptedException e) {
                System.err.println(e.toString());
            }
        }

        private void updateParent(int tmp_state, DevFailed tmp_except) {
            if (DbaseObject.this.state != tmp_state || DbaseObject.this.except != tmp_except) {
                DbaseObject.this.state = tmp_state;
                DbaseObject.this.except = tmp_except;
                DbaseObject.this.parent.updateState();
            }
        }

        private void manageState() {
            DevFailed tmp_except;
            int tmp_state;
            try {
                if (this.db == null) {
                    this.db = new DbConnection(this.host, this.port);
                }
                this.db.ping();
                tmp_state = 4;
                tmp_except = null;
            }
            catch (DevFailed e) {
                tmp_state = 1;
                tmp_except = e;
            }
            this.updateParent(tmp_state, tmp_except);
        }

        @Override
        public void run() {
            while (true) {
                this.manageState();
                this.wait_next_loop();
            }
        }
    }

    private class DbConnection
    extends Connection {
        private String devname;

        private DbConnection(String host, String port) throws DevFailed {
            super(host, port, false);
            this.devname = this.get_name();
        }

        private String getDeviceName() {
            return this.devname;
        }
    }
}

