/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import zmq.SocketBase;

public class PollItem {
    private SocketBase s;
    private SelectableChannel c;
    private int zinterest;
    private int interest;
    private int ready;

    public PollItem(SocketBase s_) {
        this.s = s_;
        this.c = null;
        this.interest = -1;
        this.zinterest = -1;
    }

    public PollItem(SocketBase s_, int ops) {
        this.s = s_;
        this.c = null;
        this.init(ops);
    }

    public PollItem(SelectableChannel c_, int ops) {
        this.s = null;
        this.c = c_;
        this.init(ops);
    }

    private void init(int ops) {
        this.zinterest = ops;
        int interest_ = 0;
        if ((ops & 1) > 0) {
            interest_ |= 1;
        }
        if ((ops & 2) > 0) {
            interest_ = this.s != null ? (interest_ |= 1) : (interest_ |= 4);
        }
        this.interest = interest_;
        this.ready = 0;
    }

    public final boolean isReadable() {
        return (this.ready & 1) > 0;
    }

    public final boolean isWritable() {
        return (this.ready & 2) > 0;
    }

    public final boolean isError() {
        return (this.ready & 4) > 0;
    }

    public final SocketBase getSocket() {
        return this.s;
    }

    public final SelectableChannel getRawSocket() {
        return this.c;
    }

    protected final SelectableChannel getChannel() {
        if (this.s != null) {
            return this.s.get_fd();
        }
        return this.c;
    }

    public final int interestOps() {
        return this.interest;
    }

    public final int interestOps(int ops) {
        this.init(ops);
        return this.interest;
    }

    public final int readyOps(SelectionKey key, int nevents) {
        this.ready = 0;
        if (this.s != null) {
            int events = this.s.getsockopt(15);
            if (events < 0) {
                return -1;
            }
            if ((this.zinterest & 2) > 0 && (events & 2) > 0) {
                this.ready |= 2;
            }
            if ((this.zinterest & 1) > 0 && (events & 1) > 0) {
                this.ready |= 1;
            }
        } else if (nevents > 0) {
            if (key.isReadable()) {
                this.ready |= 1;
            }
            if (key.isWritable()) {
                this.ready |= 2;
            }
            if (!key.isValid() || key.isAcceptable() || key.isConnectable()) {
                this.ready |= 4;
            }
        }
        return this.ready;
    }

    public final int readyOps() {
        return this.ready;
    }
}

