/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.servant;

import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeValue;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevAttrHistory_4;
import fr.esrf.Tango.DevAttrHistory_5;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevCmdHistory_4;
import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevCmdInfo_2;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevInfo;
import fr.esrf.Tango.DevInfo_3;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.Device_5POA;
import fr.esrf.Tango.MultiDevFailed;
import fr.esrf.Tango.PipeConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.omg.CORBA.Any;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.DeviceState;
import org.tango.logging.LoggingLevel;
import org.tango.logging.LoggingManager;
import org.tango.server.Constants;
import org.tango.server.InvocationContext;
import org.tango.server.ServerManager;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.TransactionType;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.cache.PollingManager;
import org.tango.server.cache.TangoCacheManager;
import org.tango.server.command.CommandImpl;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;
import org.tango.server.device.InitImpl;
import org.tango.server.device.StateImpl;
import org.tango.server.device.StatusImpl;
import org.tango.server.events.DeviceInterfaceChangedSender;
import org.tango.server.idl.CleverAnyCommand;
import org.tango.server.idl.TangoIDLAttributeUtil;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.server.lock.ClientLocking;
import org.tango.server.monitoring.DeviceMonitoring;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.properties.ClassPropertyImpl;
import org.tango.server.properties.DevicePropertiesImpl;
import org.tango.server.properties.DevicePropertyImpl;
import org.tango.server.properties.PropertiesUtils;
import org.tango.server.schedule.DeviceScheduler;
import org.tango.server.servant.AttributeGetterSetter;
import org.tango.server.servant.CommandGetter;
import org.tango.utils.DevFailedUtils;

public final class DeviceImpl
extends Device_5POA {
    public static final String INIT_CMD = "Init";
    private final Logger logger = LoggerFactory.getLogger(DeviceImpl.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(DeviceImpl.class);
    private static final String NOT_IMPORTANT_ERROR = "not important error";
    private static final String READ_ASKED_FOR_0_ATTRIBUTES = "read asked for 0 attributes";
    private static final String READ_ERROR = "READ_ERROR";
    public static final int SERVER_VERSION = 5;
    public static final String MDC_KEY = "deviceName";
    public static final String ALL_ATTR = "All attributes";
    public static final String ALL_PIPES = "All pipes";
    public static final String STATE_NAME = "State";
    public static final String STATUS_NAME = "Status";
    private final String name;
    private InitImpl initImpl;
    private final Object businessObject;
    private Method deleteMethod;
    private StateImpl stateImpl;
    private StatusImpl statusImpl;
    private AroundInvokeImpl aroundInvokeImpl;
    @Attribute(name="State")
    private DevState state = DevState.UNKNOWN;
    @Attribute(name="Status")
    private String status = "default status";
    private byte[] objId;
    private final DeviceLocker deviceLock;
    private final List<PipeImpl> pipeList = new ArrayList<PipeImpl>();
    private final List<AttributeImpl> attributeList = new ArrayList<AttributeImpl>();
    private final List<CommandImpl> commandList = new ArrayList<CommandImpl>();
    private final List<DevicePropertyImpl> devicePropertyList = new ArrayList<DevicePropertyImpl>();
    private final List<ClassPropertyImpl> classPropertyList = new ArrayList<ClassPropertyImpl>();
    private DevicePropertiesImpl deviceProperties;
    private final DeviceMonitoring deviceMonitoring;
    private final String className;
    private volatile boolean isInitializing;
    private final AtomicBoolean isCorrectlyInit = new AtomicBoolean(false);
    private boolean stateCheckAttrAlarm = false;
    private final ThreadLocal<ClntIdent> clientIdentity = new ThreadLocal();
    private static final Map<String, ClientLocking> CLIENT_LOCKING_MAP = new HashMap<String, ClientLocking>();
    private final ClientLocking clientLocking;
    private final Map<String, Integer> pollAttributes = new HashMap<String, Integer>();
    private final Map<String, Integer> minCommandPolling = new HashMap<String, Integer>();
    private int minPolling = 0;
    private final Map<String, Integer> minAttributePolling = new HashMap<String, Integer>();
    private final Map<String, Integer> cmdPollRingDepth = new HashMap<String, Integer>();
    private final Map<String, Integer> attrPollRingDepth = new HashMap<String, Integer>();
    private final String deviceType;
    private DeviceScheduler deviceScheduler;
    private PollingManager pollingManager;
    private DeviceInterfaceChangedSender interfaceChangeSender;
    private int pollRingDepth = 10;

    public DeviceImpl(String deviceName, String className, TransactionType txType, Object businessObject, String deviceType) throws DevFailed {
        this.name = deviceName;
        this.className = className;
        this.deviceType = deviceType;
        this.deviceMonitoring = new DeviceMonitoring(deviceName);
        this.deviceLock = new DeviceLocker(txType, businessObject.getClass());
        this.businessObject = businessObject;
        if (CLIENT_LOCKING_MAP.containsKey(deviceName)) {
            this.clientLocking = CLIENT_LOCKING_MAP.get(deviceName);
            this.clientLocking.init();
        } else {
            this.clientLocking = new ClientLocking(deviceName, className);
            CLIENT_LOCKING_MAP.put(deviceName, this.clientLocking);
        }
        try {
            DevicePropertyImpl property = new DevicePropertyImpl("StateCheckAttrAlarm", "boolean. If true, all attributes will be read at each state/status request to check if alarm is present", this.getClass().getMethod("setStateCheckAttrAlarm", Boolean.TYPE), this, this.name, className, false, Constants.STATE_CHECK_ALARMS_DEFAULT);
            this.addDeviceProperty(property);
            DevicePropertyImpl property2 = new DevicePropertyImpl("cmd_min_poll_period", "min poll value for commands", this.getClass().getMethod("setMinCommandPolling", String[].class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property2);
            DevicePropertyImpl property3 = new DevicePropertyImpl("min_poll_period", "min poll value", this.getClass().getMethod("setMinPolling", Integer.TYPE), this, this.name, className, false, "0");
            this.addDeviceProperty(property3);
            DevicePropertyImpl property4 = new DevicePropertyImpl("attr_min_poll_period", "min poll value for attributes", this.getClass().getMethod("setMinAttributePolling", String[].class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property4);
            DevicePropertyImpl property10 = new DevicePropertyImpl("poll_ring_depth", "default poll ring depth", this.getClass().getMethod("setPollRingDepth", Integer.TYPE), this, this.name, className, false, "poll_ring_depth");
            this.addDeviceProperty(property10);
            DevicePropertyImpl property5 = new DevicePropertyImpl("cmd_poll_ring_depth", "command poll ring depth", this.getClass().getMethod("setCmdPollRingDepth", String[].class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property5);
            DevicePropertyImpl property6 = new DevicePropertyImpl("attr_poll_ring_depth", "attribute poll ring depth", this.getClass().getMethod("setAttrPollRingDepth", String[].class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property6);
            DevicePropertyImpl property7 = new DevicePropertyImpl("polled_attr", "poll attributes", this.getClass().getMethod("setPolledAttributes", String[].class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property7);
            DevicePropertyImpl property9 = new DevicePropertyImpl("logging_target", "logging target", this.getClass().getMethod("setLoggingTarget", String.class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property9);
            DevicePropertyImpl property8 = new DevicePropertyImpl("logging_level", "logging level", this.getClass().getMethod("setLoggingLevel", String.class), this, this.name, className, false, new String[0]);
            this.addDeviceProperty(property8);
        }
        catch (SecurityException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        catch (NoSuchMethodException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        MDC.put(MDC_KEY, this.name);
        this.logger.debug("Device {} of of {} created with tx type: {}", new Object[]{deviceName, businessObject.getClass(), txType});
    }

    public void setStateCheckAttrAlarm(boolean stateCheckAttrAlarm) {
        this.logger.debug("update all attributes when reading state of status {}", stateCheckAttrAlarm);
        this.stateCheckAttrAlarm = stateCheckAttrAlarm;
    }

    public void setPolledAttributes(String[] pollAttributes) {
        for (int i = 0; i < pollAttributes.length; i += 2) {
            if (i + 1 >= pollAttributes.length) continue;
            this.pollAttributes.put(pollAttributes[i].toLowerCase(Locale.ENGLISH), Integer.parseInt(pollAttributes[i + 1]));
        }
        if (this.pollingManager != null) {
            this.pollingManager.setPollAttributes(this.pollAttributes);
        }
    }

    public void setMinCommandPolling(String[] minCommandPolling) {
        for (int i = 0; i < minCommandPolling.length; i += 2) {
            if (i + 1 >= minCommandPolling.length) continue;
            this.minCommandPolling.put(minCommandPolling[i].toLowerCase(Locale.ENGLISH), Integer.parseInt(minCommandPolling[i + 1]));
        }
    }

    public void setMinAttributePolling(String[] minAttributePolling) {
        for (int i = 0; i < minAttributePolling.length; i += 2) {
            if (i + 1 >= minAttributePolling.length) continue;
            this.minAttributePolling.put(minAttributePolling[i].toLowerCase(Locale.ENGLISH), Integer.parseInt(minAttributePolling[i + 1]));
        }
    }

    public void setMinPolling(int minPolling) {
        this.minPolling = minPolling;
    }

    public void setCmdPollRingDepth(String[] cmdPollRingDepth) {
        for (int i = 0; i < cmdPollRingDepth.length; i += 2) {
            if (i + 1 >= cmdPollRingDepth.length) continue;
            this.cmdPollRingDepth.put(cmdPollRingDepth[i].toLowerCase(Locale.ENGLISH), Integer.parseInt(cmdPollRingDepth[i + 1]));
        }
    }

    public void setAttrPollRingDepth(String[] attrPollRingDepth) {
        for (int i = 0; i < attrPollRingDepth.length; i += 2) {
            if (i + 1 >= attrPollRingDepth.length) continue;
            this.attrPollRingDepth.put(attrPollRingDepth[i].toLowerCase(Locale.ENGLISH), Integer.parseInt(attrPollRingDepth[i + 1]));
        }
    }

    public void setPollRingDepth(int pollRingDepth) {
        if (pollRingDepth > 0) {
            this.pollRingDepth = pollRingDepth;
            if (this.pollingManager != null) {
                this.pollingManager.setPollRingDepth(pollRingDepth);
            }
        }
    }

    public void setLoggingLevel(String level) {
        LoggingLevel l = LoggingLevel.getLevelFromString(level);
        if (l != null) {
            LoggingManager.getInstance().setLoggingLevel(this.name, l.toInt());
        }
    }

    public void setLoggingTarget(String target) throws DevFailed, ClassNotFoundException {
        String[] config = target.split("::");
        if (config.length == 2) {
            if (config[0].equalsIgnoreCase("device")) {
                LoggingManager.getInstance().addDeviceAppender(config[1], Class.forName(this.className), this.name);
            } else {
                LoggingManager.getInstance().addFileAppender(config[1], this.name);
            }
        }
    }

    @Command(name="State", outTypeDesc="Device state")
    public DevState executeStateCmd() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.xlogger.exit();
        return this.getState();
    }

    @Command(name="Status", outTypeDesc="Device status")
    public String executeStatusCmd() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.xlogger.exit();
        return this.getStatus();
    }

    @Command(name="Init")
    public synchronized void initCmd() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (!this.isInitializing) {
            this.isInitializing = true;
            this.isCorrectlyInit.set(false);
            this.deleteDevice();
            this.doInit();
            try {
                this.pushInterfaceChangeEvent(false);
            }
            catch (DevFailed e) {
                this.logger.error("error pushing event", e);
            }
        }
        this.xlogger.exit();
    }

    public synchronized void addAttribute(AttributeImpl attribute) throws DevFailed {
        AttributeImpl result = null;
        for (AttributeImpl attr : this.attributeList) {
            if (!attr.getName().equalsIgnoreCase(attribute.getName())) continue;
            result = attribute;
            break;
        }
        if (result == null) {
            this.attributeList.add(attribute);
            if (this.attrPollRingDepth.containsKey(attribute.getName().toLowerCase(Locale.ENGLISH))) {
                attribute.setPollRingDepth(this.attrPollRingDepth.get(attribute.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                attribute.setPollRingDepth(this.pollRingDepth);
            }
        }
    }

    public synchronized void removeAttribute(AttributeImpl attribute) throws DevFailed {
        if (attribute.getName().equalsIgnoreCase(STATUS_NAME) || attribute.getName().equalsIgnoreCase(STATE_NAME)) {
            return;
        }
        this.pollingManager.removeAttributePolling(attribute.getName());
        this.statusImpl.removeAttributeAlarm(attribute.getName());
        this.stateImpl.removeAttributeAlarm(attribute.getName());
        this.attributeList.remove(attribute);
    }

    public void addPipe(PipeImpl pipe) throws DevFailed {
        PipeImpl result = null;
        for (PipeImpl pipeElt : this.pipeList) {
            if (!pipeElt.getName().equalsIgnoreCase(pipe.getName())) continue;
            result = pipe;
            break;
        }
        if (result == null) {
            this.pipeList.add(pipe);
        }
    }

    public synchronized void removePipe(PipeImpl pipe) throws DevFailed {
        this.pipeList.remove(pipe);
    }

    public List<PipeImpl> getPipeList() {
        return new ArrayList<PipeImpl>(this.pipeList);
    }

    public List<AttributeImpl> getAttributeList() {
        return new ArrayList<AttributeImpl>(this.attributeList);
    }

    public CommandImpl getCommand(String name) throws DevFailed {
        return CommandGetter.getCommand(name, this.commandList);
    }

    public void addDeviceProperty(DevicePropertyImpl property) {
        this.devicePropertyList.add(property);
    }

    public void addClassProperty(ClassPropertyImpl property) {
        this.classPropertyList.add(property);
    }

    public synchronized void setDeviceProperties(DevicePropertiesImpl properties) {
        this.deviceProperties = properties;
    }

    public void configurePolling(CommandImpl command) throws DevFailed {
        this.pollingManager.configurePolling(command);
    }

    public void configurePolling(AttributeImpl attribute) throws DevFailed {
        this.pollingManager.configurePolling(attribute);
    }

    private synchronized void doInit() {
        this.isCorrectlyInit.set(false);
        try {
            if (this.deviceScheduler != null) {
                this.deviceScheduler.triggerJob();
            }
            if (this.deviceProperties != null) {
                this.deviceProperties.update();
            }
            for (DevicePropertyImpl devicePropertyImpl : this.devicePropertyList) {
                devicePropertyImpl.update();
            }
            for (ClassPropertyImpl classPropertyImpl : this.classPropertyList) {
                classPropertyImpl.update();
            }
            for (PipeImpl pipeImpl : this.pipeList) {
                pipeImpl.loadConfiguration();
            }
            this.initImpl.execute(this.stateImpl, this.statusImpl);
            this.isCorrectlyInit.set(true);
        }
        catch (DevFailed e) {
            this.deviceMonitoring.addError();
            this.isCorrectlyInit.set(false);
            try {
                this.stateImpl.stateMachine(DeviceState.FAULT);
                this.statusImpl.statusMachine(DevFailedUtils.toString(e), DeviceState.FAULT);
            }
            catch (DevFailed devFailed) {
                this.logger.debug("not important", devFailed);
            }
        }
        this.logger.debug("end with isCorrectlyInit={}", this.isCorrectlyInit);
    }

    public synchronized void initDevice() {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (this.stateImpl == null) {
            this.stateImpl = new StateImpl(this.businessObject, null, null);
        }
        if (this.statusImpl == null) {
            this.statusImpl = new StatusImpl(this.businessObject, null, null);
        }
        if (this.initImpl == null) {
            this.buildInit(null, false);
        }
        this.doInit();
        try {
            this.pushInterfaceChangeEvent(true);
        }
        catch (DevFailed e) {
            this.logger.error("error pushing event", e);
        }
        this.logger.debug("device init done");
        this.xlogger.exit();
    }

    public synchronized void pushInterfaceChangeEvent(boolean isStarted) throws DevFailed {
        DevIntrChange devInterface = new DevIntrChange(isStarted, this.command_list_query_2(), this.get_attribute_config_5(new String[]{ALL_ATTR}));
        if (this.interfaceChangeSender == null) {
            this.interfaceChangeSender = new DeviceInterfaceChangedSender(this.name);
        }
        this.interfaceChangeSender.pushEvent(devInterface, isStarted);
    }

    public void deleteDevice() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        PropertiesUtils.clearCache();
        PropertiesUtils.clearDeviceCache(this.name);
        PropertiesUtils.clearClassCache(this.className);
        this.stopPolling();
        this.pollingManager.removeAll();
        if (this.deviceScheduler != null) {
            this.deviceScheduler.stop();
        }
        if (this.interfaceChangeSender != null) {
            this.interfaceChangeSender.stop();
        }
        if (this.deleteMethod != null) {
            try {
                this.deleteMethod.invoke(this.businessObject, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (IllegalAccessException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof DevFailed) {
                    throw (DevFailed)e.getCause();
                }
                DevFailedUtils.throwDevFailed(e.getCause());
            }
        }
        this.xlogger.exit();
    }

    private synchronized void checkInitialization() throws DevFailed {
        this.isInitializing = this.initImpl != null ? this.initImpl.isInitInProgress() : false;
        if (this.isInitializing) {
            DevFailedUtils.throwDevFailed("CONCURRENT_ERROR", this.name + " in Init command ");
        }
    }

    @Override
    public DevInfo info() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("Operation info");
        DevInfo info = new DevInfo();
        info.dev_class = this.className;
        info.doc_url = "Doc URL = http://www.tango-controls.org";
        info.server_host = ServerManager.getInstance().getHostName();
        info.server_id = ServerManager.getInstance().getServerName();
        info.server_version = 5;
        this.xlogger.exit();
        return info;
    }

    @Override
    public DevInfo_3 info_3() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("Operation info_3");
        DevInfo_3 info3 = new DevInfo_3();
        DevInfo info = this.info();
        info3.dev_class = info.dev_class;
        info3.doc_url = info.doc_url;
        info3.server_host = info.server_host;
        info3.server_id = info.server_id;
        info3.server_version = info.server_version;
        info3.dev_type = this.deviceType;
        this.xlogger.exit();
        return info3;
    }

    @Override
    public void ping() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("Operation ping");
        this.xlogger.exit();
    }

    @Override
    public String adm_name() {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("Attribute adm_name");
        this.xlogger.exit();
        return this.getAdminDeviceName();
    }

    public String getAdminDeviceName() {
        return "dserver/" + ServerManager.getInstance().getServerName();
    }

    @Override
    public String[] black_box(int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (maxSize <= 0) {
            DevFailedUtils.throwDevFailed("API_BlackBoxArgument", maxSize + " is not a good size");
        }
        this.xlogger.exit();
        return this.deviceMonitoring.getBlackBox(maxSize);
    }

    @Override
    public String description() {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("Attribute description requested ");
        String desc = "A TANGO device";
        if (this.name.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName())) {
            desc = "A device server device !!";
        }
        return desc;
    }

    @Override
    public String name() {
        MDC.put(MDC_KEY, this.name);
        this.deviceMonitoring.startRequest("Device name");
        this.xlogger.entry(new Object[0]);
        return this.name;
    }

    @Override
    public DevAttrHistory[] read_attribute_history_2(String attributeName, int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("read_attribute_history_2");
        return new DevAttrHistory[0];
    }

    @Override
    public DevAttrHistory_3[] read_attribute_history_3(String attributeName, int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("read_attribute_history_3");
        return new DevAttrHistory_3[0];
    }

    @Override
    public DevAttrHistory_4 read_attribute_history_4(String attributeName, int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("read_attribute_history_4");
        DevAttrHistory_4 result = null;
        try {
            AttributeImpl attr = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
            if (!attr.isPolled()) {
                throw DevFailedUtils.newDevFailed("API_AttrNotPolled", attr.getName() + " is not polled");
            }
            result = attr.getHistory().getAttrHistory4(maxSize);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        return result;
    }

    @Override
    public AttributeValue[] read_attributes(String[] attributeNames) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (attributeNames.length != 1 || !attributeNames[0].equalsIgnoreCase(STATE_NAME) && !attributeNames[0].equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        this.deviceMonitoring.startRequest("read_attributes");
        this.clientIdentity.set(null);
        if (attributeNames.length == 0) {
            throw DevFailedUtils.newDevFailed(READ_ERROR, READ_ASKED_FOR_0_ATTRIBUTES);
        }
        AttributeValue[] result = null;
        try {
            result = AttributeGetterSetter.getAttributesValues(this.name, attributeNames, this.pollingManager, this.attributeList, this.aroundInvokeImpl, DevSource.CACHE_DEV, this.deviceLock, null);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        return result;
    }

    @Override
    public AttributeValue[] read_attributes_2(String[] names, DevSource source) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (names.length != 1 || !names[0].equalsIgnoreCase(STATE_NAME) && !names[0].equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        this.deviceMonitoring.startRequest("read_attributes_2", source);
        this.clientIdentity.set(null);
        if (names.length == 0) {
            throw DevFailedUtils.newDevFailed(READ_ERROR, READ_ASKED_FOR_0_ATTRIBUTES);
        }
        AttributeValue[] result = null;
        try {
            result = AttributeGetterSetter.getAttributesValues(this.name, names, this.pollingManager, this.attributeList, this.aroundInvokeImpl, source, this.deviceLock, null);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public AttributeValue_3[] read_attributes_3(String[] names, DevSource source) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (names.length != 1 || !names[0].equalsIgnoreCase(STATE_NAME) && !names[0].equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        this.deviceMonitoring.startRequest("read_attributes_3", source);
        this.clientIdentity.set(null);
        if (names.length == 0) {
            throw DevFailedUtils.newDevFailed(READ_ERROR, READ_ASKED_FOR_0_ATTRIBUTES);
        }
        AttributeValue_3[] result = null;
        try {
            result = AttributeGetterSetter.getAttributesValues3(this.name, names, this.pollingManager, this.attributeList, this.aroundInvokeImpl, source, this.deviceLock, null);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public AttributeValue_4[] read_attributes_4(String[] names, DevSource source, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(Arrays.toString(names));
        if (names.length != 1 || !names[0].equalsIgnoreCase(STATE_NAME) && !names[0].equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        this.deviceMonitoring.startRequest("read_attributes_4 " + Arrays.toString(names), source, clIdent);
        this.clientIdentity.set(clIdent);
        if (names.length == 0) {
            throw DevFailedUtils.newDevFailed(READ_ERROR, READ_ASKED_FOR_0_ATTRIBUTES);
        }
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, names);
        }
        AttributeValue_4[] result = null;
        try {
            result = AttributeGetterSetter.getAttributesValues4(this.name, names, this.pollingManager, this.attributeList, this.aroundInvokeImpl, source, this.deviceLock, clIdent);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeValue_5[] read_attributes_5(String[] names, DevSource source, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(Arrays.toString(names));
        if (names.length != 1 || !names[0].equalsIgnoreCase(STATE_NAME) && !names[0].equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        long request = this.deviceMonitoring.startRequest("read_attributes_5 " + Arrays.toString(names), source, clIdent);
        this.clientIdentity.set(clIdent);
        if (names.length == 0) {
            throw DevFailedUtils.newDevFailed(READ_ERROR, READ_ASKED_FOR_0_ATTRIBUTES);
        }
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, names);
        }
        AttributeValue_5[] result = null;
        try {
            result = AttributeGetterSetter.getAttributesValues5(this.name, names, this.pollingManager, this.attributeList, this.aroundInvokeImpl, source, this.deviceLock, clIdent);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        finally {
            this.deviceMonitoring.endRequest(request);
        }
        this.xlogger.exit();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write_attributes(AttributeValue[] values) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("write_attributes");
        this.clientIdentity.set(null);
        String[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = values[i].name;
            this.logger.debug("writing {}", (Object)names[i]);
        }
        Object lock = this.deviceLock.getAttributeLock();
        try {
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                AttributeGetterSetter.setAttributeValue(values, this.attributeList, this.stateImpl, this.aroundInvokeImpl, null);
            }
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write_attributes_3(AttributeValue[] values) throws MultiDevFailed, DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("write_attributes_3");
        this.clientIdentity.set(null);
        String[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = values[i].name;
            this.logger.debug("writing {}", (Object)names[i]);
        }
        Object lock = this.deviceLock.getAttributeLock();
        try {
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                AttributeGetterSetter.setAttributeValue(values, this.attributeList, this.stateImpl, this.aroundInvokeImpl, null);
            }
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write_attributes_4(AttributeValue_4[] values, ClntIdent clIdent) throws MultiDevFailed, DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        Object[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = values[i].name;
        }
        this.logger.debug("writing {}", (Object)Arrays.toString(names));
        this.deviceMonitoring.startRequest("write_attributes_4 " + Arrays.toString(names), clIdent);
        this.clientIdentity.set(clIdent);
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, (String[])names);
        }
        Object lock = this.deviceLock.getAttributeLock();
        try {
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                AttributeGetterSetter.setAttributeValue4(values, this.attributeList, this.stateImpl, this.aroundInvokeImpl, clIdent);
            }
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof MultiDevFailed) {
                throw (MultiDevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeValue_4[] write_read_attributes_4(AttributeValue_4[] values, ClntIdent clIdent) throws MultiDevFailed, DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        Object[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = values[i].name;
        }
        this.deviceMonitoring.startRequest("write_read_attributes_4 " + Arrays.toString(names), clIdent);
        this.clientIdentity.set(clIdent);
        AttributeValue_4[] val = null;
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, (String[])names);
        }
        Object lock = this.deviceLock.getAttributeLock();
        try {
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                val = this.writeRead(values);
            }
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttributeValue_5[] write_read_attributes_5(AttributeValue_4[] writeValues, String[] readNames, ClntIdent clIdent) throws MultiDevFailed, DevFailed {
        this.deviceMonitoring.startRequest("write_read_attributes_5 ", clIdent);
        this.clientIdentity.set(clIdent);
        String[] names = new String[writeValues.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = writeValues[i].name;
        }
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, names);
        }
        AttributeValue_5[] resultValues = null;
        Object lock = this.deviceLock.getAttributeLock();
        try {
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_WRITE_READ_ATTRIBUTES, InvocationContext.CallType.CACHE_DEV, clIdent, this.name));
                try {
                    AttributeGetterSetter.setAttributeValue4(writeValues, this.attributeList, this.stateImpl, this.aroundInvokeImpl, clIdent);
                }
                catch (MultiDevFailed e) {
                    throw new DevFailed(e.errors[0].err_list);
                }
                resultValues = AttributeGetterSetter.getAttributesValues5(this.name, readNames, this.pollingManager, this.attributeList, this.aroundInvokeImpl, DevSource.DEV, this.deviceLock, clIdent);
                this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_WRITE_READ_ATTRIBUTES, InvocationContext.CallType.CACHE_DEV, clIdent, this.name));
            }
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        return resultValues;
    }

    private AttributeValue_4[] writeRead(AttributeValue_4[] values) throws DevFailed {
        this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_WRITE_READ_ATTRIBUTES, InvocationContext.CallType.CACHE_DEV, null, this.name));
        try {
            AttributeGetterSetter.setAttributeValue4(values, this.attributeList, this.stateImpl, this.aroundInvokeImpl, null);
        }
        catch (MultiDevFailed e) {
            throw new DevFailed(e.errors[0].err_list);
        }
        String[] names = new String[values.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = values[i].name;
        }
        AttributeValue_4[] resultValues = AttributeGetterSetter.getAttributesValues4(this.name, names, this.pollingManager, this.attributeList, this.aroundInvokeImpl, DevSource.DEV, this.deviceLock, null);
        this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_WRITE_READ_ATTRIBUTES, InvocationContext.CallType.CACHE_DEV, null, this.name));
        return resultValues;
    }

    @Override
    public DevCmdInfo[] command_list_query() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("command_list_query");
        List<CommandImpl> cmdList = this.getCommandList();
        Collections.sort(cmdList);
        DevCmdInfo[] back = new DevCmdInfo[this.commandList.size()];
        int i = 0;
        for (CommandImpl cmd : cmdList) {
            DevCmdInfo tmp = new DevCmdInfo();
            tmp.cmd_name = cmd.getName();
            tmp.cmd_tag = cmd.getTag();
            tmp.in_type = cmd.getInType().getTangoIDLType();
            tmp.out_type = cmd.getOutType().getTangoIDLType();
            tmp.in_type_desc = cmd.getInTypeDesc();
            tmp.out_type_desc = cmd.getOutTypeDesc();
            back[i++] = tmp;
        }
        this.xlogger.exit();
        return back;
    }

    @Override
    public DevCmdInfo_2[] command_list_query_2() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("command_list_query_2");
        DevCmdInfo_2[] back = new DevCmdInfo_2[this.commandList.size()];
        int i = 0;
        List<CommandImpl> cmdList = this.getCommandList();
        Collections.sort(cmdList);
        for (CommandImpl cmd : cmdList) {
            DevCmdInfo_2 tmp = new DevCmdInfo_2();
            tmp.cmd_name = cmd.getName();
            tmp.cmd_tag = cmd.getTag();
            tmp.level = cmd.getDisplayLevel();
            tmp.in_type = cmd.getInType().getTangoIDLType();
            tmp.out_type = cmd.getOutType().getTangoIDLType();
            tmp.in_type_desc = cmd.getInTypeDesc();
            tmp.out_type_desc = cmd.getOutTypeDesc();
            back[i++] = tmp;
        }
        this.logger.debug("found {} commands ", this.commandList.size());
        this.xlogger.exit();
        return back;
    }

    @Override
    public DevCmdInfo command_query(String commandName) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("command_query " + commandName);
        CommandImpl foundCmd = this.getCommand(commandName);
        DevCmdInfo tmp = new DevCmdInfo();
        tmp.cmd_name = foundCmd.getName();
        tmp.cmd_tag = foundCmd.getTag();
        tmp.in_type = foundCmd.getInType().getTangoIDLType();
        tmp.out_type = foundCmd.getOutType().getTangoIDLType();
        tmp.in_type_desc = foundCmd.getInTypeDesc();
        tmp.out_type_desc = foundCmd.getOutTypeDesc();
        return tmp;
    }

    @Override
    public DevCmdInfo_2 command_query_2(String commandName) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("command_query_2 " + commandName);
        CommandImpl foundCmd = this.getCommand(commandName);
        DevCmdInfo_2 tmp = new DevCmdInfo_2();
        tmp.cmd_name = foundCmd.getName();
        tmp.cmd_tag = foundCmd.getTag();
        tmp.in_type = foundCmd.getInType().getTangoIDLType();
        tmp.out_type = foundCmd.getOutType().getTangoIDLType();
        tmp.in_type_desc = foundCmd.getInTypeDesc();
        tmp.out_type_desc = foundCmd.getOutTypeDesc();
        tmp.level = foundCmd.getDisplayLevel();
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Any command_inout(String command, Any argin) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (!command.equalsIgnoreCase(STATE_NAME) && !command.equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        long request = this.deviceMonitoring.startRequest("command_inout " + command);
        this.clientIdentity.set(null);
        Any argout = null;
        try {
            argout = this.commandHandler(command, argin, DevSource.CACHE_DEV, null);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        finally {
            this.deviceMonitoring.endRequest(request);
        }
        this.xlogger.exit();
        return argout;
    }

    @Override
    public Any command_inout_2(String command, Any argin, DevSource source) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (!command.equalsIgnoreCase(STATE_NAME) && !command.equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        this.deviceMonitoring.startRequest("command_inout_2 " + command, source);
        this.clientIdentity.set(null);
        Any argout = null;
        try {
            argout = this.commandHandler(command, argin, source, null);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return argout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Any command_inout_4(String commandName, Any argin, DevSource source, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(commandName);
        if (!commandName.equalsIgnoreCase(STATE_NAME) && !commandName.equalsIgnoreCase(STATUS_NAME)) {
            this.checkInitialization();
        }
        long request = this.deviceMonitoring.startRequest("Operation command_inout_4 (cmd = " + commandName + ")", source, clIdent);
        this.clientIdentity.set(clIdent);
        Any argout = null;
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, commandName);
        }
        try {
            argout = this.commandHandler(commandName, argin, source, clIdent);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        finally {
            this.deviceMonitoring.endRequest(request);
        }
        this.xlogger.exit();
        return argout;
    }

    @Override
    public DevCmdHistory[] command_inout_history_2(String commandName, int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("command_inout_history_2 " + commandName);
        return new DevCmdHistory[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DevCmdHistory_4 command_inout_history_4(String commandName, int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        long request = this.deviceMonitoring.startRequest("command_inout_history_4 " + commandName);
        CommandImpl command = this.getCommand(commandName);
        DevCmdHistory_4 history = null;
        try {
            history = command.getHistory().toDevCmdHistory4(maxSize);
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        finally {
            this.deviceMonitoring.endRequest(request);
        }
        return history;
    }

    public void triggerPolling(String objectName) throws DevFailed {
        this.pollingManager.triggerPolling(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Any commandHandler(String commandName, Any inAny, DevSource source, ClntIdent clntIdent) throws DevFailed {
        Object ret;
        DeviceState currentState;
        this.xlogger.entry(new Object[0]);
        boolean fromCache = false;
        if (source.equals(DevSource.CACHE) || source.equals(DevSource.CACHE_DEV)) {
            fromCache = true;
        }
        CommandImpl cmd = this.getCommand(commandName);
        if (!this.name.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName()) && source.equals(DevSource.CACHE) && !cmd.isPolled()) {
            DevFailedUtils.throwDevFailed("API_CmdNotPolled", "Command " + commandName + " not polled");
        }
        if (!(cmd.getName().equals(STATUS_NAME) || cmd.getName().equals(STATE_NAME) || cmd.getName().equals(INIT_CMD) || cmd.isAllowed(currentState = DeviceState.getDeviceState(this.stateImpl.updateState())))) {
            DevFailedUtils.throwDevFailed("API_CommandNotAllowed", "Command " + commandName + " not allowed when the device is in " + (Object)((Object)currentState) + " state");
        }
        InvocationContext.CallType callType = InvocationContext.CallType.getFromDevSource(source);
        if (cmd.isPolled() && fromCache) {
            this.logger.debug("execute command {} from CACHE", (Object)cmd.getName());
            ret = this.pollingManager.getCommandCacheElement(cmd);
        } else {
            this.logger.debug("execute command {} from DEVICE", (Object)cmd.getName());
            Object lock = this.deviceLock.getCommandLock();
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_COMMAND, callType, clntIdent, commandName));
                Object input = CleverAnyCommand.get(inAny, cmd.getInTangoType(), !cmd.isArginPrimitive());
                ret = cmd.execute(input);
                this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_COMMAND, callType, clntIdent, commandName));
            }
        }
        this.stateImpl.stateMachine(cmd.getEndState());
        this.xlogger.exit();
        return CleverAnyCommand.set(cmd.getOutTangoType(), ret);
    }

    @Override
    public AttributeConfig_5[] get_attribute_config_5(String[] attributeNames) throws DevFailed {
        AttributeConfig_5[] result;
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(Arrays.toString(attributeNames));
        this.deviceMonitoring.startRequest("get_attribute_config_5 " + Arrays.toString(attributeNames));
        int length = attributeNames.length;
        boolean getAllConfig = false;
        if (length == 1 && attributeNames[0].contains(ALL_ATTR)) {
            getAllConfig = true;
        }
        if (getAllConfig) {
            this.logger.debug("get All");
            List<AttributeImpl> attrList = this.getAttributeList();
            result = new AttributeConfig_5[this.attributeList.size()];
            int i = 0;
            for (AttributeImpl attribute : attrList) {
                if (attribute.getName().equals(STATE_NAME) || attribute.getName().equals(STATUS_NAME)) continue;
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig5(attribute);
            }
            result[i++] = TangoIDLAttributeUtil.toAttributeConfig5(AttributeGetterSetter.getAttribute(STATE_NAME, attrList));
            result[i++] = TangoIDLAttributeUtil.toAttributeConfig5(AttributeGetterSetter.getAttribute(STATUS_NAME, attrList));
        } else {
            result = new AttributeConfig_5[attributeNames.length];
            int i = 0;
            for (String attributeName : attributeNames) {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
                this.logger.debug("{}:{}", (Object)attributeName, (Object)attribute.getProperties());
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig5(attribute);
            }
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public AttributeConfig_3[] get_attribute_config_3(String[] attributeNames) throws DevFailed {
        AttributeConfig_3[] result;
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(Arrays.toString(attributeNames));
        this.deviceMonitoring.startRequest("get_attribute_config_3 " + Arrays.toString(attributeNames));
        int length = attributeNames.length;
        boolean getAllConfig = false;
        if (length == 1 && attributeNames[0].contains(ALL_ATTR)) {
            getAllConfig = true;
        }
        if (getAllConfig) {
            this.logger.debug("get All ");
            List<AttributeImpl> attrList = this.getAttributeList();
            result = new AttributeConfig_3[this.attributeList.size()];
            int i = 0;
            for (AttributeImpl attribute : attrList) {
                if (attribute.getName().equals(STATE_NAME) || attribute.getName().equals(STATUS_NAME)) continue;
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig3(attribute);
            }
            result[i++] = TangoIDLAttributeUtil.toAttributeConfig3(AttributeGetterSetter.getAttribute(STATE_NAME, attrList));
            result[i++] = TangoIDLAttributeUtil.toAttributeConfig3(AttributeGetterSetter.getAttribute(STATUS_NAME, attrList));
        } else {
            result = new AttributeConfig_3[attributeNames.length];
            int i = 0;
            for (String attributeName : attributeNames) {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
                this.logger.debug("{}:{}", (Object)attributeName, (Object)attribute.getProperties());
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig3(attribute);
            }
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public AttributeConfig_2[] get_attribute_config_2(String[] attributeNames) throws DevFailed {
        AttributeConfig_2[] result;
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(Arrays.toString(attributeNames));
        this.deviceMonitoring.startRequest("get_attribute_config_2 " + Arrays.toString(attributeNames));
        int length = attributeNames.length;
        boolean getAllConfig = false;
        if (length == 1 && attributeNames[0].contains(ALL_ATTR)) {
            getAllConfig = true;
        }
        if (getAllConfig) {
            this.logger.debug("get all config");
            List<AttributeImpl> attrList = this.getAttributeList();
            result = new AttributeConfig_2[this.attributeList.size()];
            int i = 0;
            for (AttributeImpl attribute : attrList) {
                if (attribute.getName().equals(STATE_NAME) || attribute.getName().equals(STATUS_NAME)) continue;
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig2(attribute);
            }
            result[i++] = TangoIDLAttributeUtil.toAttributeConfig2(AttributeGetterSetter.getAttribute(STATE_NAME, attrList));
            result[i++] = TangoIDLAttributeUtil.toAttributeConfig2(AttributeGetterSetter.getAttribute(STATUS_NAME, attrList));
        } else {
            result = new AttributeConfig_2[attributeNames.length];
            this.logger.debug("get config for " + Arrays.toString(attributeNames));
            int i = 0;
            for (String attributeName : attributeNames) {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig2(attribute);
            }
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public AttributeConfig[] get_attribute_config(String[] attributeNames) throws DevFailed {
        AttributeConfig[] result;
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.deviceMonitoring.startRequest("get_attribute_config " + Arrays.toString(attributeNames));
        int length = attributeNames.length;
        boolean getAllConfig = false;
        if (length == 1 && attributeNames[0].contains(ALL_ATTR)) {
            getAllConfig = true;
        }
        if (getAllConfig) {
            List<AttributeImpl> attrList = this.getAttributeList();
            Collections.sort(attrList);
            result = new AttributeConfig[this.attributeList.size()];
            int i = 0;
            for (AttributeImpl attribute : attrList) {
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig(attribute);
            }
        } else {
            result = new AttributeConfig[attributeNames.length];
            int i = 0;
            for (String attributeName : attributeNames) {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
                result[i++] = TangoIDLAttributeUtil.toAttributeConfig(attribute);
            }
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public void set_attribute_config_5(AttributeConfig_5[] newConf, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.clientIdentity.set(clIdent);
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, new String[0]);
        }
        this.deviceMonitoring.startRequest("set_attribute_config_5", clIdent);
        for (AttributeConfig_5 attributeConfig : newConf) {
            String attributeName = attributeConfig.name;
            AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
            if (attribute.getName().equals(STATE_NAME) || attribute.getName().equals(STATUS_NAME)) {
                DevFailedUtils.throwDevFailed("set attribute is not possible for " + attribute.getName());
            }
            if (!(attribute.getFormat().equals(attributeConfig.data_format) && attribute.getWritable().equals(attributeConfig.writable) && attribute.getDispLevel().equals(attributeConfig.level) && attribute.getTangoType() == attributeConfig.data_type)) {
                DevFailedUtils.throwDevFailed("API_AttrNotAllowed", "not a good config");
            }
            AttributePropertiesImpl props = TangoIDLAttributeUtil.toAttributeProperties(attributeConfig);
            this.logger.debug("set_attribute_config_5: {}", props);
            if (!attribute.getProperties().isEnumMutable() && !Arrays.equals(attribute.getProperties().getEnumLabels(), props.getEnumLabels())) {
                throw DevFailedUtils.newDevFailed("API_NotSupportedFeature", "It's not supported to change enumeration labels number from outside the Tango device class code");
            }
            attribute.setProperties(props);
        }
        this.xlogger.exit();
    }

    @Override
    public void set_attribute_config_4(AttributeConfig_3[] newConf, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.clientIdentity.set(clIdent);
        if (!this.name.equalsIgnoreCase(this.getAdminDeviceName())) {
            this.clientLocking.checkClientLocking(clIdent, new String[0]);
        }
        this.deviceMonitoring.startRequest("set_attribute_config_4", clIdent);
        this.set_attribute_config_3(newConf);
        this.xlogger.exit();
    }

    @Override
    public void set_attribute_config_3(AttributeConfig_3[] newConf) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("set_attribute_config_3");
        for (AttributeConfig_3 attributeConfig : newConf) {
            String attributeName = attributeConfig.name;
            AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
            if (attribute.getName().equals(STATE_NAME) || attribute.getName().equals(STATUS_NAME)) {
                DevFailedUtils.throwDevFailed("set attribute is not possible for " + attribute.getName());
            }
            if (!(attribute.getFormat().equals(attributeConfig.data_format) && attribute.getWritable().equals(attributeConfig.writable) && attribute.getDispLevel().equals(attributeConfig.level) && attribute.getTangoType() == attributeConfig.data_type)) {
                DevFailedUtils.throwDevFailed("API_AttrNotAllowed", "not a good config");
            }
            AttributePropertiesImpl props = TangoIDLAttributeUtil.toAttributeProperties(attributeConfig);
            this.logger.debug("set_attribute_config_3: {}", props);
            attribute.setProperties(props);
        }
        this.xlogger.exit();
    }

    @Override
    public void set_attribute_config(AttributeConfig[] newConf) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("set_attribute_config");
        for (AttributeConfig attributeConfig : newConf) {
            String attributeName = attributeConfig.name;
            AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
            if (attribute.getName().equals(STATE_NAME) || attribute.getName().equals(STATUS_NAME)) {
                DevFailedUtils.throwDevFailed("set attribute is not possible for " + attribute.getName());
            }
            if (!attribute.getFormat().equals(attributeConfig.data_format) || !attribute.getWritable().equals(attributeConfig.writable) || attribute.getTangoType() != attributeConfig.data_type) {
                DevFailedUtils.throwDevFailed("API_AttrNotAllowed", "not a good config");
            }
            AttributePropertiesImpl props = TangoIDLAttributeUtil.toAttributeProperties(attributeConfig);
            this.logger.debug("set_attribute_config: {}", props);
            attribute.setProperties(props);
        }
        this.xlogger.exit();
    }

    public List<CommandImpl> getCommandList() {
        return new ArrayList<CommandImpl>(this.commandList);
    }

    public synchronized void addCommand(CommandImpl command) throws DevFailed {
        CommandImpl result = null;
        for (CommandImpl cmd : this.commandList) {
            if (!command.getName().equalsIgnoreCase(cmd.getName())) continue;
            result = command;
            break;
        }
        if (result == null) {
            this.commandList.add(command);
            if (this.cmdPollRingDepth.containsKey(command.getName().toLowerCase(Locale.ENGLISH))) {
                command.setPollRingDepth(this.cmdPollRingDepth.get(command.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                command.setPollRingDepth(this.pollRingDepth);
            }
        }
    }

    public synchronized void removeCommand(CommandImpl command) throws DevFailed {
        if (!command.getName().equalsIgnoreCase(INIT_CMD)) {
            this.pollingManager.removeCommandPolling(command.getName());
            this.commandList.remove(command);
        }
    }

    public String getName() {
        return this.name;
    }

    public void addAttributePolling(String attributeName, int pollingPeriod) throws DevFailed {
        this.pollingManager.addAttributePolling(attributeName, pollingPeriod);
    }

    public void addCommandPolling(String commandName, int pollingPeriod) throws DevFailed {
        this.pollingManager.addCommandPolling(commandName, pollingPeriod);
    }

    public void stopPolling() {
        this.pollingManager.stopPolling();
    }

    public void startPolling() {
        this.pollingManager.startPolling();
    }

    public void removeAttributePolling(String attributeName) throws DevFailed {
        this.pollingManager.removeAttributePolling(attributeName);
    }

    public void removeCommandPolling(String commandName) throws DevFailed {
        this.pollingManager.removeCommandPolling(commandName);
    }

    public void lock(int validity, ClntIdent clientIdent, String hostName) throws DevFailed {
        this.clientLocking.lock(validity, clientIdent, hostName);
    }

    public void relock() throws DevFailed {
        this.clientLocking.relock();
    }

    public void unLock(boolean isForced) {
        this.clientLocking.unLock(isForced);
    }

    public DevVarLongStringArray getLockStatus() {
        return this.clientLocking.getLockStatus();
    }

    @Override
    public DevState state() {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        try {
            this.state = this.getState();
        }
        catch (DevFailed e) {
            try {
                this.stateImpl.stateMachine(DeviceState.UNKNOWN);
                this.statusImpl.statusMachine(DevFailedUtils.toString(e), DeviceState.UNKNOWN);
                this.state = DevState.UNKNOWN;
            }
            catch (DevFailed e1) {
                this.logger.debug(NOT_IMPORTANT_ERROR, e1);
            }
            this.logger.debug(NOT_IMPORTANT_ERROR, e);
        }
        return this.state;
    }

    @Override
    public String status() {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        try {
            this.status = this.getStatus();
        }
        catch (DevFailed e) {
            try {
                this.stateImpl.stateMachine(DeviceState.UNKNOWN);
                this.statusImpl.statusMachine(DevFailedUtils.toString(e), DeviceState.UNKNOWN);
                this.status = DevFailedUtils.toString(e);
            }
            catch (DevFailed e1) {
                this.logger.debug(NOT_IMPORTANT_ERROR, e1);
            }
            this.logger.debug(NOT_IMPORTANT_ERROR, e);
        }
        return this.status;
    }

    public byte[] getObjId() {
        return Arrays.copyOf(this.objId, this.objId.length);
    }

    public void setObjId(byte[] objId) {
        this.objId = Arrays.copyOf(objId, objId.length);
    }

    public void setDeleteMethod(Method deleteMethod) {
        this.deleteMethod = deleteMethod;
    }

    public void setAroundInvokeImpl(AroundInvokeImpl aroundInvokeImpl) {
        this.aroundInvokeImpl = aroundInvokeImpl;
        TangoCacheManager cacheManager = new TangoCacheManager(this.name, this.deviceLock, aroundInvokeImpl);
        this.pollingManager = new PollingManager(this.name, cacheManager, this.attributeList, this.commandList, this.minPolling, this.minCommandPolling, this.minAttributePolling, this.cmdPollRingDepth, this.attrPollRingDepth);
        if (this.initImpl != null) {
            this.initImpl.setPollingManager(this.pollingManager);
        }
    }

    public synchronized InitImpl buildInit(Method initMethod, boolean isLazy) {
        if (this.aroundInvokeImpl == null) {
            this.aroundInvokeImpl = new AroundInvokeImpl(this.businessObject, null);
        }
        if (this.pollingManager == null) {
            TangoCacheManager cacheManager = new TangoCacheManager(this.name, this.deviceLock, this.aroundInvokeImpl);
            this.pollingManager = new PollingManager(this.name, cacheManager, this.attributeList, this.commandList, this.minPolling, this.minCommandPolling, this.minAttributePolling, this.cmdPollRingDepth, this.attrPollRingDepth);
        }
        this.initImpl = new InitImpl(this.name, initMethod, isLazy, this.businessObject, this.pollingManager);
        return this.initImpl;
    }

    public DevState getState() throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        if (this.isCorrectlyInit.get() && this.initImpl.isInitDoneCorrectly()) {
            this.state = this.stateImpl.updateState();
            if (this.state == DevState.ON && this.stateCheckAttrAlarm) {
                this.checkAlarms();
            }
        } else {
            this.state = this.stateImpl.getState();
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAlarms() throws DevFailed {
        List<AttributeImpl> attrs = this.getAttributeList();
        this.logger.debug("State: Number of attribute(s) to read: {}", attrs.size() - 2);
        for (AttributeImpl attr : attrs) {
            block9: {
                try {
                    if (attr.getName().equals(STATE_NAME) || attr.getName().equals(STATUS_NAME)) break block9;
                    AttributeImpl attributeImpl = attr;
                    synchronized (attributeImpl) {
                        if (!attr.isPolled() && !attr.isFwdAttribute()) {
                            attr.updateValue();
                        }
                    }
                }
                catch (DevFailed e) {
                    // empty catch block
                }
            }
            if (attr.isOutOfLimits()) {
                this.logger.debug("{} is out of limits", (Object)attr.getName());
                this.stateImpl.addAttributeAlarm(attr.getName());
                this.statusImpl.addAttributeAlarm(attr.getName(), attr.isAlarmToHigh());
                continue;
            }
            if (attr.isDeltaAlarm()) {
                this.logger.debug("{} has a delta alarm", (Object)attr.getName());
                this.stateImpl.addAttributeAlarm(attr.getName());
                this.statusImpl.addDeltaAttributeAlarm(attr.getName());
                continue;
            }
            this.statusImpl.removeAttributeAlarm(attr.getName());
            this.stateImpl.removeAttributeAlarm(attr.getName());
        }
        this.state = this.stateImpl.getState();
    }

    public String getStatus() throws DevFailed {
        String tmp;
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.status = this.initImpl.isInitInProgress() ? ((tmp = this.statusImpl.updateStatus(DeviceState.getDeviceState(this.getState()))).equals("Init in progress") ? tmp : "Init in progress" + System.getProperty("line.separator") + tmp) : (this.isCorrectlyInit.get() && this.initImpl.isInitDoneCorrectly() ? this.statusImpl.updateStatus(DeviceState.getDeviceState(this.getState())) : this.statusImpl.getStatus());
        return this.status;
    }

    public void checkLocking(ClntIdent clIdent) throws DevFailed {
        if (!this.clientLocking.isHasBeenForced()) {
            this.clientLocking.checkClientLocking(clIdent, this.name);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setStateImpl(StateImpl stateImpl) {
        this.stateImpl = stateImpl;
    }

    public void setStatusImpl(StatusImpl statusImpl) {
        this.statusImpl = statusImpl;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("name", this.name);
        builder.append("device class", this.businessObject.getClass());
        builder.append("device tango class", this.className);
        builder.append("Commands", this.commandList);
        builder.append("Attributes", this.attributeList);
        return builder.toString();
    }

    public Object getBusinessObject() {
        return this.businessObject;
    }

    public List<DevicePropertyImpl> getDevicePropertyList() {
        return new ArrayList<DevicePropertyImpl>(this.devicePropertyList);
    }

    public List<ClassPropertyImpl> getClassPropertyList() {
        return new ArrayList<ClassPropertyImpl>(this.classPropertyList);
    }

    public int getAttributeHistorySize(AttributeImpl attribute) {
        return attribute.getHistory().size();
    }

    public int getCommandHistorySize(CommandImpl command) {
        return command.getHistory().size();
    }

    public ClntIdent getClientIdentity() {
        return this.clientIdentity.get();
    }

    public void setDeviceScheduler(Set<Method> methodList) {
        this.deviceScheduler = new DeviceScheduler(this.businessObject, methodList, this.name, this.className);
    }

    @Override
    public DevAttrHistory_5 read_attribute_history_5(String attributeName, int maxSize) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.deviceMonitoring.startRequest("read_attribute_history_5");
        DevAttrHistory_5 result = null;
        try {
            AttributeImpl attr = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
            if (attr.getBehavior() instanceof ForwardedAttribute) {
                ForwardedAttribute fwdAttr = (ForwardedAttribute)attr.getBehavior();
                result = fwdAttr.getAttributeHistory(maxSize);
            } else {
                if (!attr.isPolled()) {
                    throw DevFailedUtils.newDevFailed("API_AttrNotPolled", attr.getName() + " is not polled");
                }
                result = attr.getHistory().getAttrHistory5(maxSize);
            }
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        return result;
    }

    @Override
    public PipeConfig[] get_pipe_config_5(String[] names) throws DevFailed {
        PipeConfig[] result;
        this.xlogger.entry(Arrays.toString(names));
        this.deviceMonitoring.startRequest("get_pipe_config_5 " + Arrays.toString(names));
        int length = names.length;
        boolean getAllConfig = false;
        if (length == 1 && names[0].contains(ALL_PIPES)) {
            getAllConfig = true;
        }
        if (getAllConfig) {
            this.logger.debug("get All");
            result = new PipeConfig[this.pipeList.size()];
            int i = 0;
            for (PipeImpl pipe : this.pipeList) {
                result[i++] = TangoIDLUtil.toPipeConfig(pipe);
            }
        } else {
            result = new PipeConfig[names.length];
            int i = 0;
            for (String pipeName : names) {
                PipeImpl pipe = DeviceImpl.getPipe(pipeName, this.pipeList);
                this.logger.debug("{}:{}", (Object)pipeName, (Object)pipe.getConfiguration());
                result[i++] = TangoIDLUtil.toPipeConfig(pipe);
            }
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public void set_pipe_config_5(PipeConfig[] newConf, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(new Object[0]);
        this.checkInitialization();
        this.clientIdentity.set(clIdent);
        this.deviceMonitoring.startRequest("set_pipe_config_5", clIdent);
        for (PipeConfig config : newConf) {
            String name = config.name;
            PipeImpl pipe = DeviceImpl.getPipe(name, this.pipeList);
            pipe.setConfiguration(config.label, config.description);
        }
        this.xlogger.exit();
    }

    public static PipeImpl getPipe(String name, List<PipeImpl> pipeList) throws DevFailed {
        PipeImpl result = null;
        for (PipeImpl pipe : pipeList) {
            if (!pipe.getName().equalsIgnoreCase(name)) continue;
            result = pipe;
            break;
        }
        if (result == null) {
            DevFailedUtils.throwDevFailed("API_AttrNotFound", name + " does not exists");
        }
        return result;
    }

    @Override
    public DevPipeData read_pipe_5(String name, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, name);
        this.xlogger.entry(name);
        PipeImpl pipe = DeviceImpl.getPipe(name, this.pipeList);
        this.deviceMonitoring.startRequest("read_pipe_5 " + name, clIdent);
        this.clientIdentity.set(clIdent);
        DevPipeData result = null;
        try {
            this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_PIPE_READ, InvocationContext.CallType.UNKNOWN, clIdent, pipe.getName()));
            pipe.updateValue();
            result = TangoIDLUtil.toDevPipeData(pipe.getName(), pipe.getReadValue());
            this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_PIPE_READ, InvocationContext.CallType.UNKNOWN, clIdent, pipe.getName()));
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return result;
    }

    @Override
    public void write_pipe_5(DevPipeData value, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(value.name);
        PipeImpl pipe = DeviceImpl.getPipe(value.name, this.pipeList);
        this.deviceMonitoring.startRequest("write_pipe_5 " + value.name, clIdent);
        this.clientIdentity.set(clIdent);
        try {
            this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_PIPE_WRITE, InvocationContext.CallType.UNKNOWN, clIdent, pipe.getName()));
            pipe.setValue(TangoIDLUtil.toPipeValue(value));
            this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_PIPE_WRITE, InvocationContext.CallType.UNKNOWN, clIdent, pipe.getName()));
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
    }

    @Override
    public DevPipeData write_read_pipe_5(DevPipeData value, ClntIdent clIdent) throws DevFailed {
        MDC.put(MDC_KEY, this.name);
        this.xlogger.entry(this.name);
        PipeImpl pipe = DeviceImpl.getPipe(this.name, this.pipeList);
        this.deviceMonitoring.startRequest("write_read_pipe_5 " + this.name, clIdent);
        this.clientIdentity.set(clIdent);
        DevPipeData result = null;
        try {
            this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_PIPE_WRITE_READ, InvocationContext.CallType.UNKNOWN, clIdent, pipe.getName()));
            pipe.setValue(TangoIDLUtil.toPipeValue(value));
            pipe.updateValue();
            result = TangoIDLUtil.toDevPipeData(pipe.getName(), pipe.getReadValue());
            this.aroundInvokeImpl.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_PIPE_WRITE_READ, InvocationContext.CallType.UNKNOWN, clIdent, pipe.getName()));
        }
        catch (Exception e) {
            this.deviceMonitoring.addError();
            if (e instanceof DevFailed) {
                throw (DevFailed)e;
            }
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
        return result;
    }
}

