/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.servant;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.MultiDevFailed;
import fr.esrf.Tango.NamedDevError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.DeviceState;
import org.tango.server.InvocationContext;
import org.tango.server.ServerManager;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.cache.PollingManager;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;
import org.tango.server.device.StateImpl;
import org.tango.server.idl.CleverAnyAttribute;
import org.tango.server.idl.CleverAttrValUnion;
import org.tango.server.idl.TangoIDLAttributeUtil;
import org.tango.utils.DevFailedUtils;

public final class AttributeGetterSetter {
    private static final String ATTRIBUTE = "Attribute ";
    public static final String DOES_NOT_EXIST = " does not exist";
    private static final XLogger XLOGGER = XLoggerFactory.getXLogger(AttributeGetterSetter.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(AttributeGetterSetter.class);

    private AttributeGetterSetter() {
    }

    public static AttributeImpl getAttribute(String name, List<AttributeImpl> attributeList) throws DevFailed {
        AttributeImpl result = null;
        for (AttributeImpl attribute : attributeList) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            result = attribute;
            break;
        }
        if (result == null) {
            DevFailedUtils.throwDevFailed("API_AttrNotFound", name + DOES_NOT_EXIST);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAttributeValue4(AttributeValue_4[] values, List<AttributeImpl> attributeList, StateImpl stateImpl, AroundInvokeImpl aroundInvoke, ClntIdent clientID) throws MultiDevFailed {
        XLOGGER.entry(new Object[0]);
        ArrayList<NamedDevError> errors = new ArrayList<NamedDevError>();
        int i = 0;
        for (AttributeValue_4 value4 : values) {
            String name = value4.name;
            try {
                AttributeImpl att = AttributeGetterSetter.getAttribute(name, attributeList);
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_WRITE_ATTRIBUTE, InvocationContext.CallType.UNKNOWN, clientID, name));
                DevState s = stateImpl.updateState();
                if (!att.isAllowed(DeviceState.getDeviceState(s))) {
                    DevFailedUtils.throwDevFailed("API_CommandNotAllowed", ATTRIBUTE + att.getName() + " not allowed when the device is in " + DeviceState.toString(s));
                }
                Object obj = CleverAttrValUnion.get(value4.value, att.getFormat());
                AttributeValue attrValue = new AttributeValue(obj, value4.quality, value4.w_dim.dim_x, value4.w_dim.dim_y);
                AttributeImpl attributeImpl = att;
                synchronized (attributeImpl) {
                    att.setValue(attrValue);
                }
                stateImpl.stateMachine(att.getEndState());
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_WRITE_ATTRIBUTE, InvocationContext.CallType.UNKNOWN, clientID, name));
            }
            catch (DevFailed e) {
                errors.add(new NamedDevError(name, i, e.errors));
            }
            ++i;
        }
        if (!errors.isEmpty()) {
            throw new MultiDevFailed(errors.toArray(new NamedDevError[errors.size()]));
        }
        XLOGGER.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setAttributeValue(fr.esrf.Tango.AttributeValue[] values, List<AttributeImpl> attributeList, StateImpl stateImpl, AroundInvokeImpl aroundInvoke, ClntIdent clientID) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        for (fr.esrf.Tango.AttributeValue value3 : values) {
            String name = value3.name;
            AttributeImpl att = AttributeGetterSetter.getAttribute(name, attributeList);
            if (!att.getFormat().equals(AttrDataFormat.SCALAR)) {
                DevFailedUtils.throwDevFailed("write only supported for SCALAR attributes");
            }
            aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_WRITE_ATTRIBUTE, InvocationContext.CallType.UNKNOWN, clientID, name));
            DevState s = stateImpl.updateState();
            if (!att.isAllowed(DeviceState.getDeviceState(s))) {
                DevFailedUtils.throwDevFailed("API_CommandNotAllowed", ATTRIBUTE + att.getName() + " not allowed when the device is in " + DeviceState.toString(s));
            }
            Object obj = CleverAnyAttribute.get(value3.value, att.getTangoType(), att.getFormat());
            AttributeValue attrValue = new AttributeValue(obj, value3.quality);
            AttributeImpl attributeImpl = att;
            synchronized (attributeImpl) {
                att.setValue(attrValue);
            }
            stateImpl.stateMachine(att.getEndState());
            aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_WRITE_ATTRIBUTE, InvocationContext.CallType.UNKNOWN, clientID, name));
        }
        XLOGGER.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AttributeValue_5[] getAttributesValues5(String deviceName, String[] names, PollingManager cacheManager, List<AttributeImpl> attributeList, AroundInvokeImpl aroundInvoke, DevSource source, DeviceLocker locker, ClntIdent clientID) throws DevFailed {
        boolean fromCache = AttributeGetterSetter.isFromCache(source);
        InvocationContext.CallType callType = InvocationContext.CallType.getFromDevSource(source);
        AttributeValue_5[] back = new AttributeValue_5[names.length];
        HashMap<Integer, AttributeImpl> cacheAttributes = new HashMap<Integer, AttributeImpl>();
        HashMap<Integer, AttributeImpl> notCacheAttributes = new HashMap<Integer, AttributeImpl>();
        for (int i = 0; i < names.length; ++i) {
            AttributeImpl att = null;
            try {
                att = AttributeGetterSetter.getAttribute(names[i], attributeList);
                if (source.equals(DevSource.DEV) && att.isPolled() && att.getPollingPeriod() == 0) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue5Error(names[i], AttrDataFormat.FMT_UNKNOWN, 0, DevFailedUtils.newDevFailed("API_AttrNotAllowed", ATTRIBUTE + names[i] + " value is available only by CACHE"));
                    continue;
                }
                if (!deviceName.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName()) && source.equals(DevSource.CACHE) && !att.isPolled()) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue5Error(names[i], AttrDataFormat.FMT_UNKNOWN, 0, DevFailedUtils.newDevFailed("API_AttrNotPolled", ATTRIBUTE + names[i] + " not polled"));
                    continue;
                }
                if (att.isPolled() && fromCache) {
                    cacheAttributes.put(i, att);
                    continue;
                }
                notCacheAttributes.put(i, att);
                continue;
            }
            catch (DevFailed e) {
                back[i] = TangoIDLAttributeUtil.toAttributeValue5Error(names[i], AttrDataFormat.FMT_UNKNOWN, 0, e);
            }
        }
        for (Map.Entry attribute : cacheAttributes.entrySet()) {
            AttributeImpl att = (AttributeImpl)attribute.getValue();
            int i = (Integer)attribute.getKey();
            try {
                LOGGER.debug("read from CACHE {}", (Object)att.getName());
                AttributeValue readValue = cacheManager.getAttributeCacheElement(att);
                if (readValue == null) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue5Error(names[i], att.getFormat(), att.getTangoType(), DevFailedUtils.newDevFailed("CACHE_ERROR", names[i] + " not available from cache"));
                    continue;
                }
                back[i] = TangoIDLAttributeUtil.toAttributeValue5(att, readValue, att.getWriteValue());
            }
            catch (CacheException e) {
                if (!(e.getCause() instanceof DevFailed)) continue;
                back[i] = TangoIDLAttributeUtil.toAttributeValue5Error(names[i], AttrDataFormat.FMT_UNKNOWN, 0, (DevFailed)e.getCause());
            }
        }
        if (!notCacheAttributes.isEmpty()) {
            Object lock = locker.getAttributeLock();
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTES, callType, clientID, names));
                for (Map.Entry attribute : notCacheAttributes.entrySet()) {
                    AttributeImpl att = (AttributeImpl)attribute.getValue();
                    int i = (Integer)attribute.getKey();
                    LOGGER.debug("read from DEVICE {} ", (Object)att.getName());
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTE, callType, clientID, att.getName()));
                    try {
                        AttributeImpl attributeImpl = att;
                        synchronized (attributeImpl) {
                            if (att.getBehavior() instanceof ForwardedAttribute) {
                                ForwardedAttribute fwdAttr = (ForwardedAttribute)att.getBehavior();
                                back[i] = fwdAttr.getValue5();
                            } else {
                                att.updateValue();
                                back[i] = TangoIDLAttributeUtil.toAttributeValue5(att, att.getReadValue(), att.getWriteValue());
                            }
                        }
                    }
                    catch (DevFailed e) {
                        back[i] = TangoIDLAttributeUtil.toAttributeValue5Error(names[i], att.getFormat(), att.getTangoType(), e);
                    }
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTE, callType, clientID, att.getName()));
                }
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTES, callType, clientID, names));
            }
        }
        return back;
    }

    private static boolean isFromCache(DevSource source) {
        boolean fromCache = false;
        if (source.equals(DevSource.CACHE) || source.equals(DevSource.CACHE_DEV)) {
            fromCache = true;
        }
        return fromCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AttributeValue_4[] getAttributesValues4(String deviceName, String[] names, PollingManager cacheManager, List<AttributeImpl> attributeList, AroundInvokeImpl aroundInvoke, DevSource source, DeviceLocker locker, ClntIdent clientID) throws DevFailed {
        boolean fromCache = AttributeGetterSetter.isFromCache(source);
        InvocationContext.CallType callType = InvocationContext.CallType.getFromDevSource(source);
        AttributeValue_4[] back = new AttributeValue_4[names.length];
        HashMap<Integer, AttributeImpl> cacheAttributes = new HashMap<Integer, AttributeImpl>();
        HashMap<Integer, AttributeImpl> notCacheAttributes = new HashMap<Integer, AttributeImpl>();
        for (int i = 0; i < names.length; ++i) {
            AttributeImpl att = null;
            try {
                att = AttributeGetterSetter.getAttribute(names[i], attributeList);
                if (source.equals(DevSource.DEV) && att.isPolled() && att.getPollingPeriod() == 0) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue4Error(names[i], AttrDataFormat.FMT_UNKNOWN, DevFailedUtils.newDevFailed("API_AttrNotAllowed", ATTRIBUTE + names[i] + " value is available only by CACHE"));
                    continue;
                }
                if (!deviceName.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName()) && source.equals(DevSource.CACHE) && !att.isPolled()) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue4Error(names[i], AttrDataFormat.FMT_UNKNOWN, DevFailedUtils.newDevFailed("API_AttrNotPolled", ATTRIBUTE + names[i] + " not polled"));
                    continue;
                }
                if (att.isPolled() && fromCache) {
                    cacheAttributes.put(i, att);
                    continue;
                }
                notCacheAttributes.put(i, att);
                continue;
            }
            catch (DevFailed e) {
                back[i] = TangoIDLAttributeUtil.toAttributeValue4Error(names[i], AttrDataFormat.FMT_UNKNOWN, e);
            }
        }
        for (Map.Entry attribute : cacheAttributes.entrySet()) {
            AttributeImpl att = (AttributeImpl)attribute.getValue();
            int i = (Integer)attribute.getKey();
            try {
                LOGGER.debug("read from CACHE {}", (Object)att.getName());
                AttributeValue readValue = cacheManager.getAttributeCacheElement(att);
                if (readValue == null) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue4Error(names[i], att.getFormat(), DevFailedUtils.newDevFailed("CACHE_ERROR", names[i] + " not available from cache"));
                    continue;
                }
                back[i] = TangoIDLAttributeUtil.toAttributeValue4(att, readValue, att.getWriteValue());
            }
            catch (CacheException e) {
                if (!(e.getCause() instanceof DevFailed)) continue;
                back[i] = TangoIDLAttributeUtil.toAttributeValue4Error(names[i], AttrDataFormat.FMT_UNKNOWN, (DevFailed)e.getCause());
            }
        }
        if (!notCacheAttributes.isEmpty()) {
            Object lock = locker.getAttributeLock();
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTES, callType, clientID, names));
                for (Map.Entry attribute : notCacheAttributes.entrySet()) {
                    AttributeImpl att = (AttributeImpl)attribute.getValue();
                    int i = (Integer)attribute.getKey();
                    LOGGER.debug("read from DEVICE {} ", (Object)att.getName());
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTE, callType, clientID, att.getName()));
                    try {
                        AttributeImpl attributeImpl = att;
                        synchronized (attributeImpl) {
                            att.updateValue();
                            back[i] = TangoIDLAttributeUtil.toAttributeValue4(att, att.getReadValue(), att.getWriteValue());
                        }
                    }
                    catch (DevFailed e) {
                        back[i] = TangoIDLAttributeUtil.toAttributeValue4Error(names[i], att.getFormat(), e);
                    }
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTE, callType, clientID, att.getName()));
                }
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTES, callType, clientID, names));
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AttributeValue_3[] getAttributesValues3(String deviceName, String[] names, PollingManager cacheManager, List<AttributeImpl> attributeList, AroundInvokeImpl aroundInvoke, DevSource source, DeviceLocker locker, ClntIdent clientID) throws DevFailed {
        boolean fromCache = AttributeGetterSetter.isFromCache(source);
        InvocationContext.CallType callType = InvocationContext.CallType.getFromDevSource(source);
        AttributeValue_3[] back = new AttributeValue_3[names.length];
        HashMap<Integer, AttributeImpl> cacheAttributes = new HashMap<Integer, AttributeImpl>();
        HashMap<Integer, AttributeImpl> notCacheAttributes = new HashMap<Integer, AttributeImpl>();
        for (int i = 0; i < names.length; ++i) {
            AttributeImpl att = null;
            try {
                att = AttributeGetterSetter.getAttribute(names[i], attributeList);
                if (source.equals(DevSource.DEV) && att.isPolled() && att.getPollingPeriod() == 0) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue3Error(names[i], DevFailedUtils.newDevFailed("API_AttrNotAllowed", ATTRIBUTE + names[i] + " value is available only by CACHE"));
                    continue;
                }
                if (!deviceName.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName()) && source.equals(DevSource.CACHE) && !att.isPolled()) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue3Error(names[i], DevFailedUtils.newDevFailed("API_AttrNotPolled", ATTRIBUTE + names[i] + " not polled"));
                    continue;
                }
                if (att.isPolled() && fromCache) {
                    cacheAttributes.put(i, att);
                    continue;
                }
                notCacheAttributes.put(i, att);
                continue;
            }
            catch (DevFailed e) {
                back[i] = TangoIDLAttributeUtil.toAttributeValue3Error(names[i], e);
            }
        }
        for (Map.Entry attribute : cacheAttributes.entrySet()) {
            AttributeImpl att = (AttributeImpl)attribute.getValue();
            int i = (Integer)attribute.getKey();
            try {
                LOGGER.debug("read from CACHE {}", (Object)att.getName());
                AttributeValue readValue = cacheManager.getAttributeCacheElement(att);
                if (readValue == null) {
                    back[i] = TangoIDLAttributeUtil.toAttributeValue3Error(names[i], DevFailedUtils.newDevFailed("CACHE_ERROR", names[i] + " not available from cache"));
                    continue;
                }
                back[i] = TangoIDLAttributeUtil.toAttributeValue3(att, readValue, att.getWriteValue());
            }
            catch (CacheException e) {
                if (!(e.getCause() instanceof DevFailed)) continue;
                back[i] = TangoIDLAttributeUtil.toAttributeValue3Error(names[i], (DevFailed)e.getCause());
            }
        }
        if (!notCacheAttributes.isEmpty()) {
            Object lock = locker.getAttributeLock();
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTES, callType, clientID, names));
                for (Map.Entry attribute : notCacheAttributes.entrySet()) {
                    AttributeImpl att = (AttributeImpl)attribute.getValue();
                    int i = (Integer)attribute.getKey();
                    LOGGER.debug("read from DEVICE {} ", (Object)att.getName());
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTE, callType, clientID, att.getName()));
                    try {
                        AttributeImpl attributeImpl = att;
                        synchronized (attributeImpl) {
                            att.updateValue();
                            back[i] = TangoIDLAttributeUtil.toAttributeValue3(att, att.getReadValue(), att.getWriteValue());
                        }
                    }
                    catch (DevFailed e) {
                        back[i] = TangoIDLAttributeUtil.toAttributeValue3Error(names[i], e);
                    }
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTE, callType, clientID, att.getName()));
                }
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTES, callType, clientID, names));
            }
        }
        return back;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static fr.esrf.Tango.AttributeValue[] getAttributesValues(String deviceName, String[] names, PollingManager cacheManager, List<AttributeImpl> attributeList, AroundInvokeImpl aroundInvoke, DevSource source, DeviceLocker locker, ClntIdent clientID) throws DevFailed {
        boolean fromCache = AttributeGetterSetter.isFromCache(source);
        InvocationContext.CallType callType = InvocationContext.CallType.getFromDevSource(source);
        fr.esrf.Tango.AttributeValue[] back = new fr.esrf.Tango.AttributeValue[names.length];
        HashMap<Integer, AttributeImpl> cacheAttributes = new HashMap<Integer, AttributeImpl>();
        HashMap<Integer, AttributeImpl> notCacheAttributes = new HashMap<Integer, AttributeImpl>();
        for (int i = 0; i < names.length; ++i) {
            AttributeImpl att = AttributeGetterSetter.getAttribute(names[i], attributeList);
            if (source.equals(DevSource.DEV) && att.isPolled() && att.getPollingPeriod() == 0) {
                throw DevFailedUtils.newDevFailed("API_AttrNotAllowed", ATTRIBUTE + names[i] + " value is available only by CACHE");
            }
            if (!deviceName.equalsIgnoreCase(ServerManager.getInstance().getAdminDeviceName()) && source.equals(DevSource.CACHE) && !att.isPolled()) {
                throw DevFailedUtils.newDevFailed("API_AttrNotPolled", ATTRIBUTE + names[i] + " not polled");
            }
            if (att.isPolled() && fromCache) {
                cacheAttributes.put(i, att);
                continue;
            }
            notCacheAttributes.put(i, att);
        }
        for (Map.Entry attribute : cacheAttributes.entrySet()) {
            AttributeImpl att = (AttributeImpl)attribute.getValue();
            int i = (Integer)attribute.getKey();
            try {
                LOGGER.debug("read from CACHE {}", (Object)att.getName());
                AttributeValue readValue = cacheManager.getAttributeCacheElement(att);
                if (readValue == null) {
                    throw DevFailedUtils.newDevFailed("CACHE_ERROR", names[i] + " not available from cache");
                }
                back[i] = TangoIDLAttributeUtil.toAttributeValue(att, readValue);
            }
            catch (CacheException e) {
                if (!(e.getCause() instanceof DevFailed)) continue;
                throw (DevFailed)e.getCause();
            }
        }
        if (!notCacheAttributes.isEmpty()) {
            Object lock = locker.getAttributeLock();
            Object object = lock != null ? lock : new Object();
            synchronized (object) {
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTES, callType, clientID, names));
                for (Map.Entry attribute : notCacheAttributes.entrySet()) {
                    AttributeImpl att = (AttributeImpl)attribute.getValue();
                    int i = (Integer)attribute.getKey();
                    LOGGER.debug("read from DEVICE {} ", (Object)att.getName());
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.PRE_READ_ATTRIBUTE, callType, clientID, att.getName()));
                    AttributeImpl attributeImpl = att;
                    synchronized (attributeImpl) {
                        att.updateValue();
                        back[i] = TangoIDLAttributeUtil.toAttributeValue(att, att.getReadValue());
                    }
                    aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTE, callType, clientID, att.getName()));
                }
                aroundInvoke.aroundInvoke(new InvocationContext(InvocationContext.ContextType.POST_READ_ATTRIBUTES, callType, clientID, names));
            }
        }
        return back;
    }
}

