/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.properties;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.properties.PropertiesUtils;
import org.tango.utils.DevFailedUtils;

public final class DevicePropertyImpl {
    private final XLogger xlogger = XLoggerFactory.getXLogger(DevicePropertyImpl.class);
    private final Method propertyMethod;
    private final String description;
    private final Object businessObject;
    private final String deviceName;
    private final String className;
    private final String name;
    private final String[] defaultValue;
    private final boolean isMandatory;

    public DevicePropertyImpl(String propertyName, String description, Method propertyMethod, Object businessObject, String deviceName, String className, boolean isMandatory, String ... defaultValue) throws DevFailed {
        String[] stringArray;
        this.description = description;
        this.name = propertyName;
        this.propertyMethod = propertyMethod;
        this.businessObject = businessObject;
        this.deviceName = deviceName;
        this.className = className;
        this.isMandatory = isMandatory;
        if (defaultValue.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = defaultValue;
        }
        this.defaultValue = stringArray;
    }

    public void update() throws DevFailed {
        this.xlogger.entry(this.name);
        String[] property = PropertiesUtils.getDeviceProperty(this.deviceName, this.className, this.name);
        if (this.isMandatory && (property.length == 0 || property[0].isEmpty())) {
            DevFailedUtils.throwDevFailed(this.name + " device property is mandatory");
        }
        PropertiesUtils.injectProperty(this.name, this.propertyMethod, property, this.businessObject, this.defaultValue);
        this.xlogger.exit();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDefaultValue() {
        return Arrays.copyOf(this.defaultValue, this.defaultValue.length);
    }
}

