/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.monitoring;

import fr.esrf.Tango.ClntIdent;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevSource;
import org.tango.server.history.DeviceBlackBox;
import org.tango.server.monitoring.TangoStats;

public class DeviceMonitoring {
    private static final String SEPARATOR = " - ";
    private final String deviceName;
    private final DeviceBlackBox blackbox;
    private final TangoStats monitoring;

    public DeviceMonitoring(String deviceName) {
        this.deviceName = deviceName;
        this.blackbox = new DeviceBlackBox();
        this.monitoring = TangoStats.getInstance();
    }

    public long startRequest(String request) {
        this.blackbox.insertInblackBox(request);
        return this.monitoring.addRequest(this.deviceName + SEPARATOR + request);
    }

    public long startRequest(String request, ClntIdent clt) {
        this.blackbox.insertInblackBox(request, clt);
        return this.monitoring.addRequest(this.deviceName + SEPARATOR + request);
    }

    public long startRequest(String request, DevSource devSource) {
        this.blackbox.insertInblackBox(request, devSource);
        return this.monitoring.addRequest(this.deviceName + SEPARATOR + request);
    }

    public long startRequest(String request, DevSource devSource, ClntIdent clt) {
        this.blackbox.insertInblackBox(request, devSource, clt);
        return this.monitoring.addRequest(this.deviceName + SEPARATOR + request);
    }

    public void addError() {
        this.monitoring.addError();
    }

    public void endRequest(long id) {
        this.monitoring.endRequest(id);
    }

    public String[] getBlackBox(int size) throws DevFailed {
        return this.blackbox.toArray(size);
    }
}

