/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.Chronometer;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.events.IEventTrigger;

public class PeriodicEventTrigger
implements IEventTrigger {
    private final Chronometer periodicChrono = new Chronometer();
    private final Logger logger = LoggerFactory.getLogger(PeriodicEventTrigger.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(PeriodicEventTrigger.class);
    private long period;
    private boolean isSamePeriod;
    private final AttributeImpl attribute;

    public PeriodicEventTrigger(long period, AttributeImpl attribute) {
        this.attribute = attribute;
        this.period = period;
        this.isSamePeriod = (long)attribute.getPollingPeriod() == period;
        this.periodicChrono.stop();
    }

    public void setPeriod(long period) {
        this.period = period;
        this.isSamePeriod = (long)this.attribute.getPollingPeriod() == period;
    }

    @Override
    public boolean isSendEvent() {
        this.xlogger.entry(new Object[0]);
        boolean hasChanged = false;
        if (this.period > 0L) {
            if (this.isSamePeriod) {
                hasChanged = true;
            } else if (this.periodicChrono.isOver() && this.period > 0L) {
                hasChanged = true;
                this.periodicChrono.start(this.period);
            }
        }
        this.logger.debug("PERIODIC event must send: {}", hasChanged);
        this.xlogger.exit();
        return hasChanged;
    }

    @Override
    public void setError(DevFailed error) {
    }

    @Override
    public void updateProperties() throws DevFailed {
        EventProperties props = this.attribute.getProperties().getEventProp();
        try {
            this.period = Long.parseLong(props.per_event.period);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public boolean doCheck() {
        return true;
    }
}

