/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttDataReadyHelper;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeConfig_5Helper;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_4Helper;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.AttributeValue_5Helper;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevIntrChangeHelper;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevPipeDataHelper;
import fr.esrf.Tango.ZmqCallInfo;
import fr.esrf.Tango.ZmqCallInfoHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jacorb.orb.CDROutputStream;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.events.EventConstants;
import org.tango.server.events.EventImpl;
import org.tango.server.events.EventType;
import org.tango.server.idl.TangoIDLAttributeUtil;
import org.zeromq.ZMQ;

class EventUtilities {
    private static final String HEARTBEAT = ".heartbeat";
    private static final String TANGO = "tango://";
    private static final String IDL_VERSION = "idlversion_";
    private static final String DOT = ".";
    private static final String VERSION = "version";
    private static double zmqVersion = -1.0;
    private static String tangoHost = null;
    private static final XLogger xlogger = XLoggerFactory.getXLogger(EventImpl.class);

    EventUtilities() {
    }

    static String buildEventName(String deviceName, String attributeName, EventType eventType, int idlVersion) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, attributeName);
        fullName = idlVersion >= 5 ? fullName + DOT + IDL_VERSION.replace(VERSION, Integer.toString(idlVersion)) + eventType.getString() : fullName + DOT + eventType.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildEventName(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, attributeName);
        fullName = fullName + ".idl5_" + eventType.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildPipeEventName(String deviceName, String pipename) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, null);
        fullName = fullName + "/" + pipename + DOT + EventType.PIPE_EVENT.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildHeartBeatEventName(String deviceName) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, null);
        fullName = fullName + HEARTBEAT;
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    static String buildDeviceEventName(String deviceName, EventType eventType) throws DevFailed {
        String fullName = EventUtilities.buildEventNameBeginning(deviceName, null);
        fullName = fullName + DOT + eventType.getString();
        return fullName.toLowerCase(Locale.ENGLISH);
    }

    private static String buildEventNameBeginning(String deviceName, String attributeName) throws DevFailed {
        if (tangoHost == null) {
            tangoHost = DatabaseFactory.getDatabase().getPossibleTangoHosts()[0];
        }
        String fullName = TANGO + tangoHost + "/" + deviceName.toLowerCase(Locale.ENGLISH);
        if (attributeName != null) {
            fullName = fullName + "/" + attributeName.toLowerCase(Locale.ENGLISH);
        }
        return fullName;
    }

    static byte[] cppAlignmentAdd8(byte[] data) {
        xlogger.entry(new Object[0]);
        byte[] buffer = new byte[data.length + 8];
        buffer[0] = -64;
        buffer[1] = -34;
        buffer[2] = -64;
        buffer[3] = -34;
        buffer[4] = -64;
        buffer[5] = -34;
        buffer[6] = -64;
        buffer[7] = -34;
        System.arraycopy(data, 0, buffer, 8, data.length);
        xlogger.exit();
        return buffer;
    }

    static byte[] cppAlignment(byte[] data) {
        xlogger.entry(new Object[0]);
        byte[] buffer = new byte[data.length + 4];
        buffer[0] = -64;
        buffer[1] = -34;
        buffer[2] = -64;
        buffer[3] = -34;
        System.arraycopy(data, 0, buffer, 4, data.length);
        xlogger.exit();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshallIDL5(AttributeValue_5 attributeValue) throws DevFailed {
        xlogger.entry(new Object[0]);
        CDROutputStream os = new CDROutputStream();
        try {
            AttributeValue_5Helper.write(os, attributeValue);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshallIDL4(AttributeValue_4 attributeValue) throws DevFailed {
        xlogger.entry(new Object[0]);
        CDROutputStream os = new CDROutputStream();
        try {
            AttributeValue_4Helper.write(os, attributeValue);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    static byte[] marshallIDL5(AttributeImpl attribute) throws DevFailed {
        xlogger.entry(new Object[0]);
        AttributeValue_5 attributeValue = TangoIDLAttributeUtil.toAttributeValue5(attribute, attribute.getReadValue(), attribute.getWriteValue());
        return EventUtilities.marshallIDL5(attributeValue);
    }

    static byte[] marshallIDL4(AttributeImpl attribute) throws DevFailed {
        xlogger.entry(new Object[0]);
        AttributeValue_4 attributeValue = TangoIDLAttributeUtil.toAttributeValue4(attribute, attribute.getReadValue(), attribute.getWriteValue());
        return EventUtilities.marshallIDL4(attributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshall(AttDataReady dataReady) throws DevFailed {
        xlogger.entry(new Object[0]);
        CDROutputStream os = new CDROutputStream();
        try {
            AttDataReadyHelper.write(os, dataReady);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshallIDL4Config(AttributeImpl attribute) throws DevFailed {
        xlogger.entry(new Object[0]);
        AttributeConfig_3 config = TangoIDLAttributeUtil.toAttributeConfig3(attribute);
        CDROutputStream os = new CDROutputStream();
        try {
            AttributeConfig_3Helper.write(os, config);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshallIDL5Config(AttributeImpl attribute) throws DevFailed {
        xlogger.entry(new Object[0]);
        AttributeConfig_5 config = TangoIDLAttributeUtil.toAttributeConfig5(attribute);
        CDROutputStream os = new CDROutputStream();
        try {
            AttributeConfig_5Helper.write(os, config);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshall(DevFailed devFailed) throws DevFailed {
        xlogger.entry(new Object[0]);
        CDROutputStream os = new CDROutputStream();
        try {
            DevErrorListHelper.write(os, devFailed.errors);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshall(int counter, boolean isException) throws DevFailed {
        xlogger.entry(new Object[0]);
        ZmqCallInfo zmqCallInfo = new ZmqCallInfo(EventConstants.ZMQ_RELEASE, counter, "", EventConstants.OBJECT_IDENTIFIER, isException);
        CDROutputStream os = new CDROutputStream();
        try {
            ZmqCallInfoHelper.write(os, zmqCallInfo);
            xlogger.exit();
            byte[] byArray = os.getBufferCopy();
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshall(DevIntrChange deviceInterface) {
        xlogger.entry(new Object[0]);
        CDROutputStream os = new CDROutputStream();
        try {
            DevIntrChangeHelper.write(os, deviceInterface);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignment(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] marshall(DevPipeData pipeData) {
        xlogger.entry(new Object[0]);
        CDROutputStream os = new CDROutputStream();
        try {
            DevPipeDataHelper.write(os, pipeData);
            xlogger.exit();
            byte[] byArray = EventUtilities.cppAlignmentAdd8(os.getBufferCopy());
            return byArray;
        }
        finally {
            os.close();
        }
    }

    static double getZmqVersion() {
        if (zmqVersion < 0.0) {
            zmqVersion = 0.0;
            try {
                String strVersion = ZMQ.getVersionString();
                StringTokenizer stk = new StringTokenizer(strVersion, DOT);
                ArrayList<String> list = new ArrayList<String>();
                while (stk.hasMoreTokens()) {
                    list.add(stk.nextToken());
                }
                strVersion = (String)list.get(0) + DOT + (String)list.get(1);
                if (list.size() > 2) {
                    strVersion = strVersion + (String)list.get(2);
                }
                try {
                    zmqVersion = Double.parseDouble(strVersion);
                }
                catch (NumberFormatException e) {
                    System.err.println(e);
                }
            }
            catch (Exception e) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return zmqVersion;
    }
}

