/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevPipeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.events.DefaultEventTrigger;
import org.tango.server.events.EventConstants;
import org.tango.server.events.EventTriggerFactory;
import org.tango.server.events.EventType;
import org.tango.server.events.EventUtilities;
import org.tango.server.events.IEventTrigger;
import org.tango.server.pipe.PipeImpl;
import org.tango.utils.DevFailedUtils;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

final class EventImpl {
    private final Logger logger = LoggerFactory.getLogger(EventImpl.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(EventImpl.class);
    private AttributeImpl attribute;
    private final IEventTrigger eventTrigger;
    private long subscribeTime;
    private int counter = 0;
    private final EventType eventType;
    private final boolean islatestIDLVersion;

    EventImpl(AttributeImpl attribute, EventType eventType, int idlVersion) throws DevFailed {
        this.attribute = attribute;
        this.eventType = eventType;
        this.islatestIDLVersion = idlVersion == 5;
        this.eventTrigger = EventTriggerFactory.createEventTrigger(eventType, attribute);
        this.logger.debug("event trigger for {} type is {}", (Object)attribute.getName(), this.eventTrigger.getClass());
        this.updateSubscribeTime();
    }

    EventImpl(PipeImpl pipe, int idlVersion) throws DevFailed {
        this.eventType = EventType.PIPE_EVENT;
        this.islatestIDLVersion = idlVersion == 5;
        this.eventTrigger = new DefaultEventTrigger();
        this.logger.debug("event trigger for {} type is {}", (Object)pipe.getName(), this.eventTrigger.getClass());
        this.updateSubscribeTime();
    }

    EventImpl(int idlVersion) throws DevFailed {
        this.eventType = EventType.INTERFACE_CHANGE_EVENT;
        this.islatestIDLVersion = idlVersion == 5;
        this.eventTrigger = new DefaultEventTrigger();
        this.logger.debug("event trigger for {} type is {}", this.eventTrigger.getClass());
        this.updateSubscribeTime();
    }

    void updateSubscribeTime() {
        this.subscribeTime = System.currentTimeMillis();
    }

    boolean isStillSubscribed() {
        long dt = System.currentTimeMillis() - this.subscribeTime;
        return dt < 600000L;
    }

    void forcePushEvent(ZMQ.Socket eventSocket, String fullName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        if (this.eventType.equals((Object)EventType.ATT_CONF_EVENT)) {
            this.pushAttributeConfigEvent(eventSocket, fullName);
        } else {
            this.sendAttributeEvent(eventSocket, fullName);
        }
        this.xlogger.exit();
    }

    void pushAttributeEvent(ZMQ.Socket eventSocket, String fullName) throws DevFailed {
        boolean sendEvent;
        this.xlogger.entry(new Object[0]);
        this.eventTrigger.setError(null);
        this.eventTrigger.updateProperties();
        boolean bl = sendEvent = this.isAttributeValueEvent() && (this.eventTrigger.doCheck() && this.eventTrigger.isSendEvent() || !this.eventTrigger.doCheck());
        if (sendEvent) {
            this.sendAttributeEvent(eventSocket, fullName);
        }
        this.xlogger.exit();
    }

    private boolean isAttributeValueEvent() {
        return this.eventType.equals((Object)EventType.ARCHIVE_EVENT) || this.eventType.equals((Object)EventType.PERIODIC_EVENT) || this.eventType.equals((Object)EventType.CHANGE_EVENT);
    }

    private void sendAttributeEvent(ZMQ.Socket eventSocket, String fullName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            eventSocket.sendMore(fullName);
            eventSocket.send(EventConstants.LITTLE_ENDIAN, 2);
            eventSocket.send(EventUtilities.marshall(this.counter++, false), 2);
            if (this.attribute.getBehavior() instanceof ForwardedAttribute) {
                ForwardedAttribute att = (ForwardedAttribute)this.attribute.getBehavior();
                eventSocket.send(EventUtilities.marshallIDL5(att.getValue5()), 0);
            } else if (this.islatestIDLVersion) {
                eventSocket.send(EventUtilities.marshallIDL5(this.attribute), 0);
            } else {
                eventSocket.send(EventUtilities.marshallIDL4(this.attribute), 0);
            }
            this.logger.debug("sent event: {}", (Object)fullName);
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        this.xlogger.exit();
    }

    void pushAttributeDataReadyEvent(ZMQ.Socket eventSocket, String fullName, int counter) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            AttDataReady dataReady = new AttDataReady(this.attribute.getName(), this.attribute.getTangoType(), counter);
            eventSocket.sendMore(fullName);
            eventSocket.send(EventConstants.LITTLE_ENDIAN, 2);
            eventSocket.send(EventUtilities.marshall(counter, false), 2);
            eventSocket.send(EventUtilities.marshall(dataReady), 0);
            this.logger.debug("sent {} event: {}", (Object)EventType.DATA_READY_EVENT, (Object)fullName);
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        this.xlogger.exit();
    }

    void pushAttributeConfigEvent(ZMQ.Socket eventSocket, String fullName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            eventSocket.sendMore(fullName);
            eventSocket.send(EventConstants.LITTLE_ENDIAN, 2);
            eventSocket.send(EventUtilities.marshall(this.counter++, false), 2);
            if (this.islatestIDLVersion) {
                eventSocket.send(EventUtilities.marshallIDL5Config(this.attribute), 0);
            } else {
                eventSocket.send(EventUtilities.marshallIDL4Config(this.attribute), 0);
            }
            this.logger.debug("sent {} event: {}", (Object)EventType.ATT_CONF_EVENT, (Object)fullName);
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        this.xlogger.exit();
    }

    void pushInterfaceChangeEvent(ZMQ.Socket eventSocket, String fullName, DevIntrChange deviceInterface) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            eventSocket.sendMore(fullName);
            eventSocket.send(EventConstants.LITTLE_ENDIAN, 2);
            eventSocket.send(EventUtilities.marshall(this.counter++, false), 2);
            eventSocket.send(EventUtilities.marshall(deviceInterface), 0);
            this.logger.debug("sent {} event: {}", (Object)EventType.INTERFACE_CHANGE_EVENT, (Object)fullName);
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        this.xlogger.exit();
    }

    void pushPipeEvent(ZMQ.Socket eventSocket, String fullName, DevPipeData pipeData) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            eventSocket.sendMore(fullName);
            eventSocket.send(EventConstants.LITTLE_ENDIAN, 2);
            eventSocket.send(EventUtilities.marshall(this.counter++, false), 2);
            eventSocket.send(EventUtilities.marshall(pipeData), 0);
            this.logger.debug("sent {} event: {}", (Object)EventType.PIPE_EVENT, (Object)fullName);
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed(e);
        }
        this.xlogger.exit();
    }

    void pushEvent(ZMQ.Socket eventSocket, String fullName, DevFailed devFailed) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.eventTrigger.updateProperties();
        this.eventTrigger.setError(devFailed);
        if (this.eventTrigger.doCheck() && this.eventTrigger.isSendEvent()) {
            try {
                eventSocket.sendMore(fullName);
                eventSocket.send(EventConstants.LITTLE_ENDIAN, 2);
                eventSocket.send(EventUtilities.marshall(this.counter++, true), 2);
                eventSocket.send(EventUtilities.marshall(devFailed), 0);
                this.logger.debug("sent ERROR event: {}", (Object)fullName);
            }
            catch (ZMQException e) {
                throw DevFailedUtils.newDevFailed(e);
            }
        }
        this.xlogger.exit();
    }
}

