/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.DeviceProperty;
import org.tango.server.build.BuilderUtils;
import org.tango.server.properties.DevicePropertyImpl;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class DevicePropertyBuilder {
    private final Logger logger = LoggerFactory.getLogger(DevicePropertyBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(DevicePropertyBuilder.class);

    DevicePropertyBuilder() {
    }

    public void build(Class<?> clazz, Field field, DeviceImpl device, Object businessObject) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            DeviceProperty annot = field.getAnnotation(DeviceProperty.class);
            String fieldName = field.getName();
            String propName = annot.name().equals("") ? fieldName : annot.name();
            this.logger.debug("Has a DeviceProperty : {}", (Object)propName);
            BuilderUtils.checkStatic(field);
            String setterName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
            Method setter = null;
            try {
                setter = businessObject.getClass().getMethod(setterName, field.getType());
            }
            catch (NoSuchMethodException e) {
                if (fieldName.startsWith("is")) {
                    setterName = "set" + fieldName.substring(2);
                    try {
                        setter = businessObject.getClass().getMethod(setterName, field.getType());
                    }
                    catch (NoSuchMethodException e1) {
                        DevFailedUtils.throwDevFailed(e);
                    }
                }
                DevFailedUtils.throwDevFailed(e);
            }
            DevicePropertyImpl property = new DevicePropertyImpl(propName, annot.description(), setter, businessObject, device.getName(), device.getClassName(), annot.isMandatory(), annot.defaultValue());
            device.addDeviceProperty(property);
        }
        catch (IllegalArgumentException e) {
            DevFailedUtils.throwDevFailed(e);
        }
        this.xlogger.exit();
    }
}

