/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.attribute.AttributeTangoType;
import org.tango.server.annotation.Attribute;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.ReflectAttributeBehavior;
import org.tango.server.build.BuilderUtils;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class AttributeMethodBuilder {
    private final Logger logger = LoggerFactory.getLogger(AttributeMethodBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributeMethodBuilder.class);

    AttributeMethodBuilder() {
    }

    public void build(DeviceImpl device, Object businessObject, Method method, boolean isOnDeviceImpl) throws DevFailed {
        Class<?> type;
        String fieldName;
        String setterName;
        String getterName;
        this.xlogger.entry(new Object[0]);
        Object target = isOnDeviceImpl ? device : businessObject;
        this.checkSyntax(method);
        Method setter = null;
        Method getter = null;
        if (method.getName().startsWith("get") || method.getName().startsWith("is")) {
            getter = method;
            getterName = method.getName();
            String removedGet = getterName.startsWith("get") ? getterName.substring(3) : getterName;
            setterName = "set" + removedGet;
            fieldName = removedGet.substring(0, 1).toLowerCase(Locale.ENGLISH) + removedGet.substring(1);
            type = method.getReturnType();
            try {
                setter = target.getClass().getMethod(setterName, type);
            }
            catch (NoSuchMethodException e) {}
        } else {
            setter = method;
            setterName = method.getName();
            String removedGet = setterName.substring(3);
            fieldName = removedGet.substring(0, 1).toLowerCase(Locale.ENGLISH) + removedGet.substring(1);
            if (method.getParameterTypes().length != 1) {
                throw DevFailedUtils.newDevFailed("INIT_ERROR", setterName + " must have only one parameter");
            }
            type = method.getParameterTypes()[0];
            Class<?> attrType = AttributeTangoType.getTypeFromClass(type).getType();
            getterName = Boolean.TYPE.isAssignableFrom(attrType) ? "is" + removedGet : "get" + removedGet;
            try {
                getter = target.getClass().getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        this.checkNull(getterName, setterName, setter, getter);
        Attribute annot = method.getAnnotation(Attribute.class);
        String attributeName = BuilderUtils.getAttributeName(fieldName, annot);
        AttributeConfiguration config = BuilderUtils.getAttributeConfiguration(type, getter, setter, annot, attributeName);
        AttributePropertiesImpl props = BuilderUtils.getAttributeProperties(method, attributeName, config.getScalarType());
        props = BuilderUtils.setEnumLabelProperty(type, props);
        config.setAttributeProperties(props);
        AttributeImpl attr = new AttributeImpl(new ReflectAttributeBehavior(config, target, getter, setter), device.getName());
        this.configureStateMachine(setter, getter, attr);
        this.logger.debug("Has an attribute: {} {}", (Object)attr.getName(), (Object)attr.getFormat().value());
        device.addAttribute(attr);
        this.xlogger.exit();
    }

    private void configureStateMachine(Method setter, Method getter, AttributeImpl attr) {
        if (getter != null) {
            BuilderUtils.setStateMachine(getter, attr);
        }
        if (setter != null) {
            BuilderUtils.setStateMachine(setter, attr);
        }
    }

    private void checkNull(String getterName, String setterName, Method setter, Method getter) throws DevFailed {
        if (setter == null && getter == null) {
            DevFailedUtils.throwDevFailed("INIT_ERROR", getterName + " or " + setterName + " method not found");
        }
    }

    private void checkSyntax(Method method) throws DevFailed {
        if (!(method.getName().startsWith("get") || method.getName().startsWith("is") || method.getName().startsWith("set"))) {
            DevFailedUtils.throwDevFailed("INIT_ERROR", method + " can only be a get/set method");
        }
    }
}

