/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.build;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.annotation.Attribute;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.ReflectAttributeBehavior;
import org.tango.server.build.BuilderUtils;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

final class AttributeFieldBuilder {
    private final Logger logger = LoggerFactory.getLogger(AttributeFieldBuilder.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributeFieldBuilder.class);

    AttributeFieldBuilder() {
    }

    public void build(DeviceImpl device, Object businessObject, Field field, boolean isOnDeviceImpl) throws DevFailed {
        Method setter;
        String setterName;
        Method getter;
        String getterName;
        Class<?> type;
        Object target;
        String fieldName;
        block9: {
            fieldName = field.getName();
            this.xlogger.entry(fieldName);
            target = isOnDeviceImpl ? device : businessObject;
            type = field.getType();
            getterName = "get" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
            getter = null;
            try {
                getter = target.getClass().getMethod(getterName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                getterName = fieldName.startsWith("is") ? fieldName : "is" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
                try {
                    getter = target.getClass().getMethod(getterName, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    // empty catch block
                }
            }
            setterName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
            setter = null;
            try {
                setter = target.getClass().getMethod(setterName, type);
            }
            catch (NoSuchMethodException e) {
                if (!fieldName.startsWith("is")) break block9;
                setterName = "set" + fieldName.substring(2);
                try {
                    setter = businessObject.getClass().getMethod(setterName, type);
                }
                catch (NoSuchMethodException e1) {
                    DevFailedUtils.throwDevFailed(e);
                }
            }
        }
        if (setter == null && getter == null) {
            DevFailedUtils.throwDevFailed("INIT_ERROR", getterName + " or " + setterName + " method not found");
        }
        Attribute annot = field.getAnnotation(Attribute.class);
        String attributeName = BuilderUtils.getAttributeName(fieldName, annot);
        AttributeConfiguration config = BuilderUtils.getAttributeConfiguration(type, getter, setter, annot, attributeName);
        AttributePropertiesImpl props = BuilderUtils.getAttributeProperties(field, attributeName, config.getScalarType());
        props = BuilderUtils.setEnumLabelProperty(type, props);
        config.setAttributeProperties(props);
        AttributeImpl attr = new AttributeImpl(new ReflectAttributeBehavior(config, target, getter, setter), device.getName());
        this.logger.debug("Has an attribute: {} {}", (Object)attr.getName(), (Object)attr.getFormat().value());
        BuilderUtils.setStateMachine(field, attr);
        device.addAttribute(attr);
        this.xlogger.exit(field.getName());
    }
}

