/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.DeviceState;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.utils.DevFailedUtils;

public final class ReflectAttributeBehavior
implements IAttributeBehavior {
    private final Logger logger = LoggerFactory.getLogger(ReflectAttributeBehavior.class);
    private final AttributeConfiguration config;
    private final Method getter;
    private final Method setter;
    private final Object businessObject;

    public ReflectAttributeBehavior(AttributeConfiguration config, Object businessObject, Method getter, Method setter) {
        this.businessObject = businessObject;
        this.getter = getter;
        this.setter = setter;
        this.config = config;
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        Object value = null;
        if (this.getter != null) {
            try {
                this.logger.debug("read attribute {} from method '{}'", (Object)this.config.getName(), (Object)this.getter);
                value = this.getter.invoke(this.businessObject, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (IllegalAccessException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (InvocationTargetException e) {
                this.throwDevFailed(e);
            }
        }
        AttributeValue result = this.buildAttributeValue(value);
        return result;
    }

    private void throwDevFailed(InvocationTargetException e) throws DevFailed {
        if (e.getCause() instanceof DevFailed) {
            throw (DevFailed)e.getCause();
        }
        DevFailedUtils.throwDevFailed(e.getCause());
    }

    private AttributeValue buildAttributeValue(Object value) throws DevFailed {
        AttributeValue result = null;
        if (value == null) {
            result = new AttributeValue(null);
        } else if (value instanceof AttributeValue) {
            result = (AttributeValue)value;
        } else if (value instanceof DeviceState) {
            DeviceState state = (DeviceState)((Object)value);
            result = new AttributeValue(state.getDevState());
        } else if (value instanceof DeviceState[]) {
            DeviceState[] in = (DeviceState[])value;
            DevState[] devStates = new DevState[in.length];
            for (int i = 0; i < in.length; ++i) {
                devStates[i] = in[i].getDevState();
            }
            result = new AttributeValue(devStates);
        } else if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            result = new AttributeValue((short)enumValue.ordinal());
        } else {
            result = new AttributeValue(value);
        }
        return result;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        if (this.setter != null && this.setter.getParameterTypes().length == 1) {
            Class<?> paramSetter = this.getParamSetter();
            try {
                if (paramSetter.equals(DeviceState.class)) {
                    this.setter.invoke(this.businessObject, new Object[]{DeviceState.getDeviceState((DevState)value.getValue())});
                } else if (Enum.class.isAssignableFrom(paramSetter)) {
                    short enumValue = (Short)value.getValue();
                    this.setter.invoke(this.businessObject, paramSetter.getEnumConstants()[enumValue]);
                } else if (paramSetter.equals(DeviceState[].class)) {
                    DevState[] states = (DevState[])value.getValue();
                    DeviceState[] devStates = new DeviceState[states.length];
                    for (int i = 0; i < devStates.length; ++i) {
                        devStates[i] = DeviceState.getDeviceState(states[i]);
                    }
                    this.setter.invoke(this.businessObject, new Object[]{devStates});
                } else {
                    Class<?> input = this.getInputClass(value);
                    this.checkParamTypes(value, paramSetter, input);
                    this.setter.invoke(this.businessObject, value.getValue());
                }
            }
            catch (IllegalArgumentException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (IllegalAccessException e) {
                DevFailedUtils.throwDevFailed(e);
            }
            catch (InvocationTargetException e) {
                this.throwDevFailed(e);
            }
        }
    }

    private void checkParamTypes(AttributeValue value, Class<?> paramSetter, Class<?> input) throws DevFailed {
        if (!paramSetter.isAssignableFrom(input)) {
            DevFailedUtils.throwDevFailed("API_AttrOptProp", "type mismatch, expected was " + this.setter.getParameterTypes()[0].getCanonicalName() + ", input is " + value.getValue().getClass().getCanonicalName());
        }
    }

    private Class<?> getInputClass(AttributeValue value) {
        Class<?> input = value.getValue().getClass();
        if (Number.class.isAssignableFrom(input) || Boolean.class.isAssignableFrom(input)) {
            input = ClassUtils.wrapperToPrimitive(value.getValue().getClass());
        }
        return input;
    }

    private Class<?> getParamSetter() {
        Class<?> paramSetter = this.setter.getParameterTypes()[0];
        if (Number.class.isAssignableFrom(paramSetter) || Boolean.class.isAssignableFrom(paramSetter)) {
            paramSetter = ClassUtils.wrapperToPrimitive(this.setter.getParameterTypes()[0]);
        }
        return paramSetter;
    }

    @Override
    public AttributeConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        return null;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("getter", this.getter);
        builder.append("setter", this.setter);
        return builder.toString();
    }
}

