/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.attribute;

import fr.esrf.Tango.ArchiveEventProp;
import fr.esrf.Tango.ChangeEventProp;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.EventProperties;
import fr.esrf.Tango.PeriodicEventProp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.DeviceState;
import org.tango.server.properties.AttributePropertiesManager;
import org.tango.utils.CaseInsensitiveMap;
import org.tango.utils.DevFailedUtils;

public final class AttributePropertiesImpl {
    private String label = "";
    private String description = "No description";
    private String unit = "No unit";
    private String standardUnit = "No standard unit";
    private String displayUnit = "No display unit";
    private String format = "Not specified";
    private String minValue = "Not specified";
    private double minValueDouble = -1.7976931348623157E308;
    private String maxValue = "Not specified";
    private double maxValueDouble = Double.MAX_VALUE;
    private String minAlarm = "Not specified";
    private double minAlarmDouble = -1.7976931348623157E308;
    private String maxAlarm = "Not specified";
    private double maxAlarmDouble = Double.MAX_VALUE;
    private String writableAttrName = "None";
    private String minWarning = "Not specified";
    private double minWarningDouble = -1.7976931348623157E308;
    private String maxWarning = "Not specified";
    private double maxWarningDouble = Double.MAX_VALUE;
    private String deltaT = "Not specified";
    private long deltaTLong = 0L;
    private String deltaVal = "Not specified";
    private String[] alarmExtensions = new String[0];
    private final EventProperties eventProp;
    private String[] extensions = new String[0];
    private String[] sysExtensions = new String[0];
    private double deltaValDouble = 0.0;
    private String[] enumLabels = new String[]{"Not specified"};
    private String rootAttribute = "Not specified";
    private boolean isEnumMutable = true;
    private boolean isFwdAttribute = false;

    public AttributePropertiesImpl() {
        this.isEnumMutable = true;
        this.eventProp = this.createEmptyEventProperties();
    }

    public AttributePropertiesImpl(AttributePropertiesImpl props) {
        this.label = props.label;
        this.description = props.description;
        this.unit = props.unit;
        this.standardUnit = props.standardUnit;
        this.displayUnit = props.displayUnit;
        this.format = props.format;
        this.minValue = props.minValue;
        this.minValueDouble = props.minValueDouble;
        this.maxValue = props.maxValue;
        this.maxValueDouble = props.maxValueDouble;
        this.minAlarm = props.minAlarm;
        this.minAlarmDouble = props.minAlarmDouble;
        this.maxAlarm = props.maxAlarm;
        this.maxAlarmDouble = props.maxAlarmDouble;
        this.minWarning = props.minWarning;
        this.minWarningDouble = props.minWarningDouble;
        this.maxWarning = props.maxWarning;
        this.maxWarningDouble = props.maxWarningDouble;
        this.deltaT = props.deltaT;
        this.deltaTLong = props.deltaTLong;
        this.deltaVal = props.deltaVal;
        this.deltaValDouble = props.deltaValDouble;
        this.alarmExtensions = Arrays.copyOf(props.alarmExtensions, props.alarmExtensions.length);
        this.eventProp = props.eventProp;
        this.extensions = Arrays.copyOf(props.extensions, props.extensions.length);
        this.sysExtensions = Arrays.copyOf(props.sysExtensions, props.sysExtensions.length);
        this.enumLabels = Arrays.copyOf(props.enumLabels, props.enumLabels.length);
        this.isEnumMutable = props.isEnumMutable;
        this.isFwdAttribute = props.isFwdAttribute;
    }

    public EventProperties createEmptyEventProperties() {
        ChangeEventProp change = new ChangeEventProp();
        change.abs_change = "Not specified";
        change.extensions = new String[0];
        change.rel_change = "Not specified";
        PeriodicEventProp per = new PeriodicEventProp();
        per.extensions = new String[0];
        per.period = "1000";
        ArchiveEventProp arch = new ArchiveEventProp();
        arch.abs_change = "Not specified";
        arch.extensions = new String[0];
        arch.period = "Not specified";
        arch.rel_change = "Not specified";
        return new EventProperties(change, per, arch);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!label.isEmpty()) {
            this.label = label;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description.isEmpty() || description.equalsIgnoreCase("Not specified") || description.equalsIgnoreCase("None") ? "No description" : description;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit.isEmpty() || unit.equalsIgnoreCase("Not specified") || unit.equalsIgnoreCase("None") ? "No unit" : unit;
    }

    public String getStandardUnit() {
        return this.standardUnit;
    }

    public void setStandardUnit(String standardUnit) {
        this.standardUnit = standardUnit.isEmpty() || standardUnit.equalsIgnoreCase("Not specified") || standardUnit.equalsIgnoreCase("None") ? "No standard unit" : standardUnit;
    }

    public String getDisplayUnit() {
        return this.displayUnit;
    }

    public void setDisplayUnit(String displayUnit) {
        this.displayUnit = displayUnit.isEmpty() || displayUnit.equalsIgnoreCase("Not specified") || displayUnit.equalsIgnoreCase("None") ? "No display unit" : displayUnit;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        if (minValue.isEmpty() || minValue.equalsIgnoreCase("NAN") || minValue.equalsIgnoreCase("None")) {
            this.minValue = "Not specified";
            this.minValueDouble = -1.7976931348623157E308;
        } else {
            this.minValue = minValue;
            try {
                this.minValueDouble = Double.valueOf(minValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        if (maxValue.isEmpty() || maxValue.equalsIgnoreCase("NAN") || maxValue.equalsIgnoreCase("None")) {
            this.maxValue = "Not specified";
            this.maxValueDouble = Double.MAX_VALUE;
        } else {
            this.maxValue = maxValue;
            try {
                this.maxValueDouble = Double.valueOf(maxValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getMinAlarm() {
        return this.minAlarm;
    }

    public void setMinAlarm(String minAlarm) {
        if (minAlarm.isEmpty() || minAlarm.equalsIgnoreCase("NAN") || minAlarm.equalsIgnoreCase("None")) {
            this.minAlarm = "Not specified";
            this.minAlarmDouble = -1.7976931348623157E308;
        } else {
            this.minAlarm = minAlarm;
            try {
                this.minAlarmDouble = Double.parseDouble(minAlarm);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getMaxAlarm() {
        return this.maxAlarm;
    }

    public void setMaxAlarm(String maxAlarm) {
        if (maxAlarm.isEmpty() || maxAlarm.equalsIgnoreCase("NAN") || maxAlarm.equalsIgnoreCase("None")) {
            this.maxAlarm = "Not specified";
            this.maxAlarmDouble = Double.MAX_VALUE;
        } else {
            this.maxAlarm = maxAlarm;
            try {
                this.maxAlarmDouble = Double.parseDouble(maxAlarm);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public EventProperties getEventProp() {
        return this.eventProp;
    }

    public void setEventProp(EventProperties eventProp) {
        this.setDefaultPeriod(eventProp.per_event.period);
        this.eventProp.ch_event.abs_change = this.getDefaultValue(eventProp.ch_event.abs_change);
        this.eventProp.ch_event.rel_change = this.getDefaultValue(eventProp.ch_event.rel_change);
        this.eventProp.arch_event.abs_change = this.getDefaultValue(eventProp.arch_event.abs_change);
        this.eventProp.arch_event.rel_change = this.getDefaultValue(eventProp.arch_event.rel_change);
        this.eventProp.arch_event.period = this.getDefaultValue(eventProp.arch_event.period);
    }

    public void setEventPeriod(String value) {
        this.setDefaultPeriod(value);
    }

    public void setEventAbsChange(String value) {
        this.eventProp.ch_event.abs_change = this.getDefaultValue(value);
    }

    public void setEventRelChange(String value) {
        this.eventProp.ch_event.rel_change = this.getDefaultValue(value);
    }

    public void setArchivingEventAbsChange(String value) {
        this.eventProp.arch_event.abs_change = this.getDefaultValue(value);
    }

    public void setArchivingEventRelChange(String value) {
        this.eventProp.arch_event.rel_change = this.getDefaultValue(value);
    }

    public void setArchivingEventPeriod(String value) {
        this.eventProp.arch_event.period = this.getDefaultValue(value);
    }

    private String getDefaultValue(String field) {
        String result = field;
        if (field.equalsIgnoreCase("None") || field.equalsIgnoreCase("NAN")) {
            result = "Not specified";
        }
        return result;
    }

    private void setDefaultPeriod(String field) {
        this.eventProp.per_event.period = field.equalsIgnoreCase("Not specified") || field.equalsIgnoreCase("None") || field.equalsIgnoreCase("NAN") ? "1000" : field;
    }

    public String[] getExtensions() {
        return Arrays.copyOf(this.extensions, this.extensions.length);
    }

    public void setExtensions(String[] extensions) {
        this.extensions = Arrays.copyOf(extensions, extensions.length);
    }

    public String[] getSysExtensions() {
        return Arrays.copyOf(this.sysExtensions, this.sysExtensions.length);
    }

    public void setSysExtensions(String[] sysExtensions) {
        this.sysExtensions = Arrays.copyOf(sysExtensions, sysExtensions.length);
    }

    public String getWritableAttrName() {
        return this.writableAttrName;
    }

    public String getMinWarning() {
        return this.minWarning;
    }

    public String getMaxWarning() {
        return this.maxWarning;
    }

    public String getDeltaT() {
        return this.deltaT;
    }

    public String getDeltaVal() {
        return this.deltaVal;
    }

    public void setWritableAttrName(String writableAttrName) {
        this.writableAttrName = writableAttrName;
    }

    public void setMinWarning(String minWarning) {
        if (minWarning.equalsIgnoreCase("NAN") || minWarning.equalsIgnoreCase("None")) {
            this.minWarning = "Not specified";
            this.minWarningDouble = -1.7976931348623157E308;
        } else {
            this.minWarning = minWarning;
            try {
                this.minWarningDouble = Double.parseDouble(minWarning);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setMaxWarning(String maxWarning) {
        if (maxWarning.equalsIgnoreCase("NAN") || maxWarning.equalsIgnoreCase("None")) {
            this.maxWarning = "Not specified";
            this.maxWarningDouble = Double.MAX_VALUE;
        } else {
            this.maxWarning = maxWarning;
            try {
                this.maxWarningDouble = Double.parseDouble(maxWarning);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setDeltaT(String deltaT) {
        if (deltaT.equalsIgnoreCase("NAN") || deltaT.equalsIgnoreCase("None")) {
            this.deltaT = "Not specified";
            this.deltaTLong = 0L;
        } else {
            this.deltaT = deltaT;
            try {
                this.deltaTLong = Long.parseLong(deltaT);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void setDeltaVal(String deltaVal) {
        if (deltaVal.equalsIgnoreCase("NAN") || deltaVal.equalsIgnoreCase("None")) {
            this.deltaVal = "Not specified";
        } else {
            this.deltaVal = deltaVal;
            try {
                this.deltaValDouble = Double.parseDouble(deltaVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String[] getAlarmExtensions() {
        return Arrays.copyOf(this.alarmExtensions, this.alarmExtensions.length);
    }

    public void setAlarmExtensions(String[] alarmExtensions) {
        this.alarmExtensions = Arrays.copyOf(alarmExtensions, alarmExtensions.length);
    }

    public double getMinValueDouble() {
        return this.minValueDouble;
    }

    public double getMaxValueDouble() {
        return this.maxValueDouble;
    }

    public double getMinAlarmDouble() {
        return this.minAlarmDouble;
    }

    public double getMaxAlarmDouble() {
        return this.maxAlarmDouble;
    }

    public double getMinWarningDouble() {
        return this.minWarningDouble;
    }

    public double getMaxWarningDouble() {
        return this.maxWarningDouble;
    }

    public String[] getEnumLabels() {
        return this.enumLabels;
    }

    public void setEnumLabels(String[] enumLabels) throws DevFailed {
        if (!this.isEnumMutable) {
            throw DevFailedUtils.newDevFailed("API_NotSupportedFeature", "It's not supported to change enumeration labels number from outside the Tango device class code");
        }
        this.setEnumLabelsPrivate(enumLabels);
    }

    private void setEnumLabelsPrivate(String[] enumLabels) throws DevFailed {
        if (enumLabels != null && enumLabels.length > 0) {
            List<String> inputList;
            HashSet<String> inputSet;
            if (enumLabels.length == 1 && (enumLabels[0].isEmpty() || enumLabels[0].equalsIgnoreCase("NAN") || enumLabels[0].equalsIgnoreCase("None"))) {
                enumLabels[0] = "Not specified";
            }
            if ((inputSet = new HashSet<String>(inputList = Arrays.asList(enumLabels))).size() < inputList.size()) {
                throw DevFailedUtils.newDevFailed("API_AttrOptProp", "duplicate enum values not allowed");
            }
            this.enumLabels = Arrays.copyOf(enumLabels, enumLabels.length);
            if (enumLabels.length >= 1 && !enumLabels[0].equals("Not specified")) {
                this.setMinValue("0");
                this.setMaxValue(Integer.toString(enumLabels.length - 1));
            }
        }
    }

    public void setEnumLabels(String[] enumLabels, boolean isMutable) throws DevFailed {
        this.isEnumMutable = isMutable;
        this.setEnumLabelsPrivate(enumLabels);
    }

    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE);
        reflectionToStringBuilder.setExcludeFieldNames("eventProp", "alarmExtensions", "extensions", "sysExtensions", "minValueDouble", "maxValueDouble", "minAlarmDouble", "maxAlarmDouble", "minWarningDouble", "maxWarningDouble", "writableAttrName", "deltaTLong", "deltaValDouble");
        return reflectionToStringBuilder.toString();
    }

    public void setDefaultFormat(Class<?> attributeScalarType) {
        if (String.class.isAssignableFrom(attributeScalarType)) {
            this.setFormat("%s");
        } else if (Double.TYPE.isAssignableFrom(attributeScalarType) || Float.TYPE.isAssignableFrom(attributeScalarType)) {
            this.setFormat("%6.2f");
        } else if (Boolean.TYPE.isAssignableFrom(attributeScalarType) || DeviceState.class.isAssignableFrom(attributeScalarType) || DevState.class.isAssignableFrom(attributeScalarType)) {
            this.setFormat("Not specified");
        } else {
            this.setFormat("%d");
        }
    }

    public long getDeltaTLong() {
        return this.deltaTLong;
    }

    public double getDeltaValDouble() {
        return this.deltaValDouble;
    }

    private boolean compareEventProps(EventProperties p1, EventProperties p2) {
        boolean isEqual = true;
        if (!p1.arch_event.abs_change.equals(p2.arch_event.abs_change)) {
            isEqual = false;
        } else if (!p1.arch_event.rel_change.equals(p2.arch_event.rel_change)) {
            isEqual = false;
        } else if (!p1.arch_event.period.equals(p2.arch_event.period)) {
            isEqual = false;
        } else if (!p1.ch_event.abs_change.equals(p2.ch_event.abs_change)) {
            isEqual = false;
        } else if (!p1.ch_event.rel_change.equals(p2.ch_event.rel_change)) {
            isEqual = false;
        } else if (!p1.per_event.period.equals(p2.per_event.period)) {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.alarmExtensions);
        result = 31 * result + (this.deltaT == null ? 0 : this.deltaT.hashCode());
        result = 31 * result + (int)(this.deltaTLong ^ this.deltaTLong >>> 32);
        result = 31 * result + (this.deltaVal == null ? 0 : this.deltaVal.hashCode());
        long temp = Double.doubleToLongBits(this.deltaValDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayUnit == null ? 0 : this.displayUnit.hashCode());
        result = 31 * result + Arrays.hashCode(this.enumLabels);
        result = 31 * result + (this.eventProp == null ? 0 : this.eventProp.hashCode());
        result = 31 * result + Arrays.hashCode(this.extensions);
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        result = 31 * result + (this.isEnumMutable ? 1231 : 1237);
        result = 31 * result + (this.isFwdAttribute ? 1231 : 1237);
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.maxAlarm == null ? 0 : this.maxAlarm.hashCode());
        temp = Double.doubleToLongBits(this.maxAlarmDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.maxValue == null ? 0 : this.maxValue.hashCode());
        temp = Double.doubleToLongBits(this.maxValueDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.maxWarning == null ? 0 : this.maxWarning.hashCode());
        temp = Double.doubleToLongBits(this.maxWarningDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minAlarm == null ? 0 : this.minAlarm.hashCode());
        temp = Double.doubleToLongBits(this.minAlarmDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minValue == null ? 0 : this.minValue.hashCode());
        temp = Double.doubleToLongBits(this.minValueDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.minWarning == null ? 0 : this.minWarning.hashCode());
        temp = Double.doubleToLongBits(this.minWarningDouble);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rootAttribute == null ? 0 : this.rootAttribute.hashCode());
        result = 31 * result + (this.standardUnit == null ? 0 : this.standardUnit.hashCode());
        result = 31 * result + Arrays.hashCode(this.sysExtensions);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.writableAttrName == null ? 0 : this.writableAttrName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        String toCompare;
        String reflectionToStringBuilder = new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).toString();
        boolean isEqual = reflectionToStringBuilder.equalsIgnoreCase(toCompare = new ReflectionToStringBuilder(obj, ToStringStyle.SHORT_PREFIX_STYLE).toString());
        if (isEqual) {
            isEqual = this.compareEventProps(this.getEventProp(), ((AttributePropertiesImpl)obj).getEventProp());
        }
        return isEqual;
    }

    public boolean isEnumMutable() {
        return this.isEnumMutable;
    }

    public String getRootAttribute() {
        return this.rootAttribute;
    }

    public void setRootAttribute(String rootAttribute) {
        if (rootAttribute != null && !rootAttribute.isEmpty() && !rootAttribute.equals("Not specified")) {
            this.rootAttribute = rootAttribute;
            this.isFwdAttribute = true;
        }
    }

    void persist(String deviceName, String attributeName) throws DevFailed {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        properties.put("label", new String[]{this.getLabel()});
        if (!this.isFwdAttribute) {
            properties.put("format", new String[]{this.getFormat()});
            properties.put("unit", new String[]{this.getUnit()});
            properties.put("display_unit", new String[]{this.getDisplayUnit()});
            properties.put("standard_unit", new String[]{this.getStandardUnit()});
            properties.put("min_value", new String[]{this.getMinValue()});
            properties.put("max_value", new String[]{this.getMaxValue()});
            properties.put("min_alarm", new String[]{this.getMinAlarm()});
            properties.put("max_alarm", new String[]{this.getMaxAlarm()});
            properties.put("min_warning", new String[]{this.getMinWarning()});
            properties.put("max_warning", new String[]{this.getMaxWarning()});
            properties.put("delta_t", new String[]{this.getDeltaT()});
            properties.put("delta_val", new String[]{this.getDeltaVal()});
            properties.put("description", new String[]{this.getDescription()});
            properties.put("enum_labels", this.getEnumLabels());
            EventProperties eventProp = this.getEventProp();
            properties.put("archive_abs_change", new String[]{eventProp.arch_event.abs_change});
            properties.put("archive_period", new String[]{eventProp.arch_event.period});
            properties.put("archive_rel_change", new String[]{eventProp.arch_event.rel_change});
            properties.put("abs_change", new String[]{eventProp.ch_event.abs_change});
            properties.put("event_period", new String[]{eventProp.per_event.period});
            properties.put("rel_change", new String[]{eventProp.ch_event.rel_change});
        }
        AttributePropertiesManager attributePropertiesManager = new AttributePropertiesManager(deviceName);
        attributePropertiesManager.setAttributePropertiesInDB(attributeName, properties);
    }

    void load(String deviceName, String attributeName) throws DevFailed {
        AttributePropertiesManager attributePropertiesManager = new AttributePropertiesManager(deviceName);
        Map<String, String[]> propValues = attributePropertiesManager.getAttributePropertiesFromDB(attributeName);
        CaseInsensitiveMap<String> propValuesSingle = new CaseInsensitiveMap<String>(propValues.size());
        for (Map.Entry<String, String[]> entry : propValues.entrySet()) {
            String[] value = entry.getValue();
            if (value.length == 1) {
                propValuesSingle.put(entry.getKey(), value[0]);
                continue;
            }
            if (value.length != 0) continue;
            propValuesSingle.put(entry.getKey(), "");
        }
        if (propValues.containsKey("label")) {
            this.setLabel((String)propValuesSingle.get("label"));
        }
        if (!this.isFwdAttribute) {
            if (propValues.containsKey("format")) {
                this.setFormat((String)propValuesSingle.get("format"));
            }
            if (propValues.containsKey("unit")) {
                this.setUnit((String)propValuesSingle.get("unit"));
            }
            if (propValues.containsKey("display_unit")) {
                this.setDisplayUnit((String)propValuesSingle.get("display_unit"));
            }
            if (propValues.containsKey("standard_unit")) {
                this.setStandardUnit((String)propValuesSingle.get("standard_unit"));
            }
            this.setMinMax(propValuesSingle);
            if (propValues.containsKey("description")) {
                this.setDescription((String)propValuesSingle.get("description"));
            }
            this.setEventProperties(propValuesSingle);
            if (propValues.containsKey("enum_labels")) {
                this.setEnumLabels(propValues.get("enum_labels"));
            }
        }
    }

    public String loadAttributeRootName(String deviceName, String attributeName) throws DevFailed {
        AttributePropertiesManager attributePropertiesManager = new AttributePropertiesManager(deviceName);
        this.setRootAttribute(attributePropertiesManager.getAttributePropertyFromDB(attributeName, "__root_att"));
        return this.getRootAttribute();
    }

    public void persistAttributeRootName(String deviceName, String attributeName) throws DevFailed {
        new AttributePropertiesManager(deviceName).setAttributePropertyInDB(attributeName, "__root_att", this.getRootAttribute());
    }

    private void setMinMax(Map<String, String> propValues) {
        if (propValues.containsKey("min_value")) {
            this.setMinValue(propValues.get("min_value"));
        }
        if (propValues.containsKey("max_value")) {
            this.setMaxValue(propValues.get("max_value"));
        }
        if (propValues.containsKey("min_alarm")) {
            this.setMinAlarm(propValues.get("min_alarm"));
        }
        if (propValues.containsKey("max_alarm")) {
            this.setMaxAlarm(propValues.get("max_alarm"));
        }
        if (propValues.containsKey("min_warning")) {
            this.setMinWarning(propValues.get("min_warning"));
        }
        if (propValues.containsKey("max_warning")) {
            this.setMaxWarning(propValues.get("max_warning"));
        }
        if (propValues.containsKey("delta_t")) {
            this.setDeltaT(propValues.get("delta_t"));
        }
        if (propValues.containsKey("delta_val")) {
            this.setDeltaVal(propValues.get("delta_val"));
        }
    }

    private void setEventProperties(Map<String, String> propValues) {
        if (propValues.containsKey("archive_abs_change")) {
            this.setArchivingEventAbsChange(propValues.get("archive_abs_change"));
        }
        if (propValues.containsKey("archive_period")) {
            this.setArchivingEventPeriod(propValues.get("archive_period"));
        }
        if (propValues.containsKey("archive_rel_change")) {
            this.setArchivingEventRelChange(propValues.get("archive_rel_change"));
        }
        if (propValues.containsKey("abs_change")) {
            this.setEventAbsChange(propValues.get("abs_change"));
        }
        if (propValues.containsKey("event_period")) {
            this.setEventPeriod(propValues.get("event_period"));
        }
        if (propValues.containsKey("rel_change")) {
            this.setEventRelChange(propValues.get("rel_change"));
        }
    }

    void clear(String deviceName, String attributeName) throws DevFailed {
        AttributePropertiesManager attributePropertiesManager = new AttributePropertiesManager(deviceName);
        attributePropertiesManager.removeAttributeProperties(attributeName);
    }
}

