/*
 * Decompiled with CFR 0.152.
 */
package org.tango.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.spi.ContextAwareBase;
import fr.esrf.Tango.DevFailed;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.logging.DeviceAppender;
import org.tango.logging.FileAppender;
import org.tango.logging.LoggingLevel;
import org.tango.utils.DevFailedUtils;

public final class LoggingManager {
    private final Logger logger = LoggerFactory.getLogger(LoggingManager.class);
    public static final String LOGGING_TARGET_SEPARATOR = "::";
    public static final String LOGGING_TARGET_DEVICE = "device";
    public static final String LOGGING_TARGET_FILE = "file";
    private final Map<String, FileAppender> fileAppenders = new HashMap<String, FileAppender>();
    private final Map<String, DeviceAppender> deviceAppenders = new HashMap<String, DeviceAppender>();
    private int rootLoggingLevel = 0;
    private final Map<String, Integer> loggingLevels = new HashMap<String, Integer>();
    private static LoggingManager instance = new LoggingManager();
    private ch.qos.logback.classic.Logger rootLoggerBack;

    private LoggingManager() {
        Logger rootLogger = LoggerFactory.getLogger("ROOT");
        if (rootLogger instanceof ch.qos.logback.classic.Logger) {
            this.rootLoggerBack = (ch.qos.logback.classic.Logger)rootLogger;
            try {
                this.rootLoggingLevel = LoggingLevel.getLevel(this.rootLoggerBack.getLevel()).toInt();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static LoggingManager getInstance() {
        return instance;
    }

    public int getRootLoggingLevel() {
        return this.rootLoggingLevel;
    }

    public int getLoggingLevel(String deviceName) {
        int level = this.rootLoggingLevel;
        if (this.loggingLevels.containsKey(deviceName)) {
            level = this.loggingLevels.get(deviceName);
        }
        return level;
    }

    public void setLoggingLevel(String deviceName, int loggingLevel) {
        System.out.println("set logging level " + deviceName + "-" + LoggingLevel.getLevelFromInt(loggingLevel));
        this.logger.debug("set logging level to {} on {}", LoggingLevel.getLevelFromInt(loggingLevel), (Object)deviceName);
        if (this.rootLoggingLevel < loggingLevel) {
            this.setRootLoggingLevel(loggingLevel);
        }
        this.loggingLevels.put(deviceName, loggingLevel);
        for (DeviceAppender deviceAppender : this.deviceAppenders.values()) {
            if (!deviceName.equalsIgnoreCase(deviceAppender.getDeviceName())) continue;
            deviceAppender.setLevel(loggingLevel);
            break;
        }
        for (FileAppender fileAppender : this.fileAppenders.values()) {
            if (!deviceName.equalsIgnoreCase(fileAppender.getDeviceName())) continue;
            fileAppender.setLevel(loggingLevel);
            break;
        }
    }

    public void setRootLoggingLevel(int loggingLevel) {
        this.rootLoggingLevel = loggingLevel;
        if (this.rootLoggerBack != null) {
            this.rootLoggerBack.setLevel(LoggingLevel.getLevelFromInt(loggingLevel));
        }
    }

    public void setLoggingLevel(int loggingLevel, Class<?> ... deviceClassNames) {
        Logger blackboxLogger;
        if (this.rootLoggingLevel < loggingLevel) {
            this.setRootLoggingLevel(loggingLevel);
        }
        System.out.println("set logging to " + LoggingLevel.getLevelFromInt(loggingLevel));
        Logger tangoLogger = LoggerFactory.getLogger("org.tango.server");
        if (tangoLogger instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)tangoLogger;
            logbackLogger.setLevel(LoggingLevel.getLevelFromInt(loggingLevel));
        }
        if ((blackboxLogger = LoggerFactory.getLogger("TangoClientRequests")) instanceof ch.qos.logback.classic.Logger) {
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)blackboxLogger;
            logbackLogger.setLevel(LoggingLevel.getLevelFromInt(loggingLevel));
        }
        for (int i = 0; i < deviceClassNames.length; ++i) {
            Logger deviceLogger = LoggerFactory.getLogger(deviceClassNames[i]);
            if (!(deviceLogger instanceof ch.qos.logback.classic.Logger)) continue;
            ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)deviceLogger;
            logbackLogger.setLevel(LoggingLevel.getLevelFromInt(loggingLevel));
        }
    }

    public void addDeviceAppender(String deviceTargetName, Class<?> deviceClassName, String loggingDeviceName) throws DevFailed {
        if (this.rootLoggerBack != null) {
            this.logger.debug("add device appender {} on {}", (Object)deviceTargetName, (Object)loggingDeviceName);
            DeviceAppender appender = new DeviceAppender(deviceTargetName, loggingDeviceName);
            this.deviceAppenders.put(loggingDeviceName.toLowerCase(Locale.ENGLISH), appender);
            this.rootLoggerBack.addAppender(appender);
            this.setLoggingLevel(LoggingLevel.DEBUG.toInt(), deviceClassName);
            this.setLoggingLevel(loggingDeviceName, LoggingLevel.DEBUG.toInt());
            appender.start();
        }
    }

    public void addFileAppender(String fileName, String deviceName) throws DevFailed {
        if (this.rootLoggerBack != null) {
            this.logger.debug("add file appender of {} in {}", (Object)deviceName, (Object)fileName);
            String deviceNameLower = deviceName.toLowerCase(Locale.ENGLISH);
            File f = new File(fileName);
            if (!f.exists()) {
                try {
                    f.createNewFile();
                }
                catch (IOException e) {
                    DevFailedUtils.throwDevFailed("API_CannotOpenFile", "impossible to open file " + fileName);
                }
            }
            if (!f.canWrite()) {
                DevFailedUtils.throwDevFailed("API_CannotOpenFile", "impossible to open file " + fileName);
            }
            System.out.println("create file  " + f);
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            FileAppender rfAppender = new FileAppender(deviceNameLower);
            this.fileAppenders.put(deviceNameLower, rfAppender);
            rfAppender.setName("FILE-" + deviceNameLower);
            rfAppender.setLevel(this.rootLoggingLevel);
            rfAppender.setFile(fileName);
            rfAppender.setAppend(true);
            rfAppender.setContext(loggerContext);
            FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
            rollingPolicy.setParent(rfAppender);
            rollingPolicy.setContext(loggerContext);
            rollingPolicy.setFileNamePattern(fileName + "%i");
            rollingPolicy.setMaxIndex(1);
            rollingPolicy.setMaxIndex(3);
            rollingPolicy.start();
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            triggeringPolicy.setMaxFileSize("5MB");
            triggeringPolicy.setContext(loggerContext);
            triggeringPolicy.start();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext(loggerContext);
            encoder.setPattern("%-5level %d %X{deviceName} - %thread | %logger{25}.%M:%L - %msg%n");
            encoder.start();
            rfAppender.setEncoder(encoder);
            rfAppender.setRollingPolicy(rollingPolicy);
            rfAppender.setTriggeringPolicy(triggeringPolicy);
            rfAppender.start();
            this.rootLoggerBack.addAppender(rfAppender);
            rfAppender.start();
        }
    }

    public void removeAppender(String loggingDeviceName, String targetName) {
        ContextAwareBase appender;
        String loggingDeviceNameLower = loggingDeviceName.toLowerCase(Locale.ENGLISH);
        if (targetName.equalsIgnoreCase(LOGGING_TARGET_DEVICE) && this.deviceAppenders.containsKey(loggingDeviceNameLower)) {
            appender = this.deviceAppenders.get(loggingDeviceNameLower);
            ((AppenderBase)appender).stop();
            this.deviceAppenders.remove(loggingDeviceNameLower);
        }
        if (targetName.equalsIgnoreCase(LOGGING_TARGET_FILE) && this.fileAppenders.containsKey(loggingDeviceNameLower)) {
            appender = this.fileAppenders.get(loggingDeviceNameLower);
            ((RollingFileAppender)appender).stop();
            this.fileAppenders.remove(loggingDeviceNameLower);
        }
    }

    public String[] getLoggingTarget(String loggingDeviceName) {
        ContextAwareBase appender;
        ArrayList<String> targets = new ArrayList<String>();
        String loggingDeviceNameLower = loggingDeviceName.toLowerCase(Locale.ENGLISH);
        if (this.deviceAppenders.containsKey(loggingDeviceNameLower)) {
            appender = this.deviceAppenders.get(loggingDeviceNameLower);
            targets.add("device::" + ((DeviceAppender)appender).getLoggingDeviceName());
        }
        if (this.fileAppenders.containsKey(loggingDeviceNameLower)) {
            appender = this.fileAppenders.get(loggingDeviceNameLower);
            targets.add("file::" + ((RollingFileAppender)appender).getFile());
        }
        return targets.toArray(new String[targets.size()]);
    }

    public void startAll() {
        for (DeviceAppender appender : this.deviceAppenders.values()) {
            if (this.rootLoggerBack == null) continue;
            this.rootLoggerBack.addAppender(appender);
            ((AppenderBase)appender).start();
        }
    }

    public void stopAll() {
        for (DeviceAppender appender : this.deviceAppenders.values()) {
            ((AppenderBase)appender).stop();
        }
    }
}

