/*
 * Decompiled with CFR 0.152.
 */
package org.tango.logging;

import ch.qos.logback.classic.Level;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum LoggingLevel {
    OFF(Level.OFF),
    FATAL(Level.ERROR),
    ERROR(Level.ERROR),
    WARN(Level.WARN),
    INFO(Level.INFO),
    DEBUG(Level.DEBUG),
    TRACE(Level.TRACE);

    private static final Map<Level, LoggingLevel> LEVEL_MAP;
    private static final int OFF_VALUE = 0;
    private static final int FATAL_VALUE = 1;
    private static final int ERROR_VALUE = 2;
    private static final int WARN_VALUE = 3;
    private static final int INFO_VALUE = 4;
    private static final int DEBUG_VALUE = 5;
    private static final int TRACE_VALUE = 6;
    private static final String OFF_STR = "OFF";
    private static final String FATAL_STR = "FATAL";
    private static final String ERROR_STR = "ERROR";
    private static final String WARN_STR = "WARN";
    private static final String INFO_STR = "INFO";
    private static final String DEBUG_STR = "DEBUG";
    private static final String TRACE_STR = "TRACE";
    private static final Map<LoggingLevel, Integer> LEVEL_INT_MAP;
    private static final Map<Integer, LoggingLevel> INT_LEVEL_MAP;
    private static final Map<String, LoggingLevel> LEVEL_STRING_MAP;
    private Level level;

    private LoggingLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public static LoggingLevel getLevel(Level level) {
        return LEVEL_MAP.get(level);
    }

    public static Level getLevelFromInt(int intLevel) {
        return INT_LEVEL_MAP.get(intLevel).getLevel();
    }

    public static LoggingLevel getLevelFromString(String stringLevel) {
        return LEVEL_STRING_MAP.get(stringLevel);
    }

    public int toInt() {
        return LEVEL_INT_MAP.get((Object)this);
    }

    static {
        LEVEL_MAP = new HashMap<Level, LoggingLevel>();
        for (LoggingLevel s : EnumSet.allOf(LoggingLevel.class)) {
            LEVEL_MAP.put(s.level, s);
        }
        LEVEL_INT_MAP = new HashMap<LoggingLevel, Integer>();
        LEVEL_INT_MAP.put(OFF, 0);
        LEVEL_INT_MAP.put(FATAL, 1);
        LEVEL_INT_MAP.put(ERROR, 2);
        LEVEL_INT_MAP.put(WARN, 3);
        LEVEL_INT_MAP.put(INFO, 4);
        LEVEL_INT_MAP.put(DEBUG, 5);
        LEVEL_INT_MAP.put(TRACE, 6);
        INT_LEVEL_MAP = new HashMap<Integer, LoggingLevel>();
        INT_LEVEL_MAP.put(0, OFF);
        INT_LEVEL_MAP.put(1, FATAL);
        INT_LEVEL_MAP.put(2, ERROR);
        INT_LEVEL_MAP.put(3, WARN);
        INT_LEVEL_MAP.put(4, INFO);
        INT_LEVEL_MAP.put(5, DEBUG);
        INT_LEVEL_MAP.put(6, TRACE);
        LEVEL_STRING_MAP = new HashMap<String, LoggingLevel>();
        LEVEL_STRING_MAP.put(OFF_STR, OFF);
        LEVEL_STRING_MAP.put(FATAL_STR, FATAL);
        LEVEL_STRING_MAP.put(ERROR_STR, ERROR);
        LEVEL_STRING_MAP.put(WARN_STR, WARN);
        LEVEL_STRING_MAP.put(INFO_STR, INFO);
        LEVEL_STRING_MAP.put(DEBUG_STR, DEBUG);
        LEVEL_STRING_MAP.put(TRACE_STR, TRACE);
    }
}

