/*
 * Decompiled with CFR 0.152.
 */
package org.tango;

import fr.esrf.Tango.DevState;

public enum DeviceState {
    ON(DevState.ON),
    OFF(DevState.OFF),
    CLOSE(DevState.CLOSE),
    OPEN(DevState.OPEN),
    INSERT(DevState.INSERT),
    EXTRACT(DevState.EXTRACT),
    MOVING(DevState.MOVING),
    STANDBY(DevState.STANDBY),
    FAULT(DevState.FAULT),
    INIT(DevState.INIT),
    RUNNING(DevState.RUNNING),
    ALARM(DevState.ALARM),
    DISABLE(DevState.DISABLE),
    UNKNOWN(DevState.UNKNOWN);

    private final DevState state;

    private DeviceState(DevState state) {
        this.state = state;
    }

    public DevState getDevState() {
        return this.state;
    }

    public static DeviceState getDeviceState(DevState state) {
        DeviceState result = null;
        for (DeviceState stateName : DeviceState.values()) {
            if (!state.equals(stateName.getDevState())) continue;
            result = stateName;
            break;
        }
        return result;
    }

    public static String toString(DevState state) {
        String result = null;
        for (DeviceState stateName : DeviceState.values()) {
            if (!state.equals(stateName.getDevState())) continue;
            result = stateName.toString();
            break;
        }
        return result;
    }

    public static DevState toDevState(String state) {
        DevState devState = null;
        for (DeviceState stateName : DeviceState.values()) {
            if (state.compareTo(stateName.toString()) != 0) continue;
            devState = DevState.from_int(stateName.ordinal());
            break;
        }
        return devState;
    }
}

