/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.tao_imr;

import java.util.List;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.tao_imr.ImplementationRepository.Administration;
import org.jacorb.tao_imr.ImplementationRepository.AdministrationHelper;
import org.jacorb.tao_imr.ImplementationRepository.ServerObject;
import org.jacorb.tao_imr.ImplementationRepository.ServerObjectHelper;
import org.jacorb.tao_imr.ImplementationRepository.ServerObjectImpl;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.ETF.Profile;
import org.omg.PortableServer.POA;

public class ImRAccessImpl
implements ImRAccess {
    private Administration imrLocator = null;
    private ORB orb_ = null;
    private org.jacorb.poa.POA poa_ = null;
    private org.jacorb.poa.POA root_poa_ = null;
    private ServerObjectImpl serverObjImpl = null;
    private ParsedIOR pior = null;
    private IIOPProfile profile = null;
    private String corbaloc = null;

    private ImRAccessImpl() {
    }

    public static ImRAccessImpl connect(ORB orb) {
        ImRAccessImpl result = new ImRAccessImpl();
        result.orb_ = orb;
        try {
            result.imrLocator = AdministrationHelper.narrow(orb.resolve_initial_references("ImplRepoService"));
        }
        catch (InvalidName e) {
            throw new INTERNAL("ImRAccessImpl.connect: unable to resolve TAO ImplRepoService: " + e.toString());
        }
        boolean non_exist = true;
        if (result.imrLocator != null) {
            try {
                non_exist = result.imrLocator._non_existent();
            }
            catch (SystemException e) {
                non_exist = true;
            }
        }
        if (non_exist) {
            throw new INTERNAL("ImRAccessImpl.connect: Unable to resolve reference to TAO ImplRepoService");
        }
        result.setImRInfo();
        return result;
    }

    private void setImRInfo() {
        try {
            Object ref = this.orb_.resolve_initial_references("ImplRepoService");
            this.pior = new ParsedIOR(this.orb_, this.orb_.object_to_string(ref));
            this.corbaloc = CorbaLoc.generateCorbalocForMultiIIOPProfiles(this.orb_, ref);
            this.profile = (IIOPProfile)this.pior.getEffectiveProfile();
        }
        catch (InvalidName e) {
            throw new INTERNAL("ImRAccessImpl.setImRInfo: unable to resolve TAO ImplRepoService: " + e.toString());
        }
    }

    @Override
    public ProtocolAddressBase getImRAddress() {
        if (this.profile == null) {
            this.setImRInfo();
        }
        return this.profile.getAddress();
    }

    @Override
    public List<Profile> getImRProfiles() {
        if (this.profile == null) {
            this.setImRInfo();
        }
        return this.pior.getProfiles();
    }

    @Override
    public String getImRHost() {
        return null;
    }

    @Override
    public int getImRPort() {
        return -1;
    }

    @Override
    public String getImRCorbaloc() {
        if (this.corbaloc == null) {
            this.setImRInfo();
        }
        return this.corbaloc;
    }

    @Override
    public void registerPOA(String name, String server, ProtocolAddressBase address) throws INTERNAL {
    }

    @Override
    public void registerPOA(String name, String server, String host, int port) throws INTERNAL {
    }

    @Override
    public void registerPOA(ORB orb, org.jacorb.poa.POA poa, ProtocolAddressBase address, String implname) throws INTERNAL {
        if (address instanceof IIOPAddress) {
            if (orb == null) {
                throw new INTERNAL("ImRAccessImpl.registerPOA: orb must not be null");
            }
            if (poa == null) {
                throw new INTERNAL("ImRAccessImpl.registerPOA: poa must not be null");
            }
        } else {
            throw new INTERNAL("ImRAccessImpl.registerPOA: TAO ImR only supports IIOP based POAs");
        }
        this.registerPOA_TaoImR_i(orb, poa, implname);
    }

    private void registerPOA_TaoImR_i(ORB orb, org.jacorb.poa.POA poa, String implname) {
        this.orb_ = orb;
        this.poa_ = poa;
        String theName = "JACORB:" + implname + "/" + this.poa_._getQualifiedName();
        try {
            this.root_poa_ = this.orb_.getRootPOA();
            this.serverObjImpl = new ServerObjectImpl(this.orb_, this.poa_, this.root_poa_);
            if (this.serverObjImpl == null) {
                throw new INTERNAL("ImRAccessImpl.registerPOA_TaoImR_i: can't create an instance of ServerObjectImpl");
            }
            this.root_poa_.activate_object(this.serverObjImpl);
            Object objRef = this.root_poa_.servant_to_reference(this.serverObjImpl);
            String corbaLoc = CorbaLoc.generateCorbalocForMultiIIOPProfiles(this.orb_, objRef);
            int slash = corbaLoc.indexOf("/");
            String partialCorbaLoc = corbaLoc;
            if (slash > 0) {
                partialCorbaLoc = corbaLoc.substring(0, slash + 1);
            }
            ServerObject svr = ServerObjectHelper.narrow(objRef);
            this.imrLocator.server_is_running(theName, partialCorbaLoc, svr);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new INTERNAL("ImRAccessImpl.registerPOA_TaoImR_i: got an exception while registering " + theName + " with TAO ImR, " + e.toString());
        }
    }

    @Override
    public void setServerDown(String implname) throws INTERNAL {
    }

    @Override
    public void setServerDown(ORB orb, org.jacorb.poa.POA poa, String implname) throws INTERNAL {
        if (this.imrLocator != null) {
            try {
                this.imrLocator.server_is_shutting_down(poa._getQualifiedName());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            if (this.serverObjImpl != null) {
                try {
                    POA root_poa = this.serverObjImpl._default_POA();
                    if (root_poa != null) {
                        byte[] id = root_poa.servant_to_id(this.serverObjImpl);
                        root_poa.deactivate_object(id);
                        this.serverObjImpl = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }
}

