/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.jacorb.security.sas.GSSUPCredentialSpi;
import org.jacorb.security.sas.GSSUPNameSpi;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;

public final class GSSUPContextSpi
implements GSSContextSpi {
    private Provider provider = null;
    private Oid mechOid = null;
    private int lifetime;
    private boolean mutualAuth = false;
    private boolean relayDet = false;
    private boolean sequenceDet = false;
    private boolean credDeleg = false;
    private boolean anonymity = false;
    private boolean conf = false;
    private boolean integ = false;
    private boolean established = false;
    private ChannelBinding channelBinding = null;
    private GSSNameSpi targetName;
    private GSSCredentialSpi sourceCred;

    public GSSUPContextSpi(Provider provider, Oid mechOid, GSSNameSpi nameSpi, GSSCredentialSpi credSpi, int lifetime) {
        this.provider = provider;
        this.mechOid = mechOid;
        this.targetName = nameSpi;
        this.sourceCred = credSpi;
        this.lifetime = lifetime;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public void requestLifetime(int lifetime) throws GSSException {
        this.lifetime = lifetime;
    }

    @Override
    public void requestMutualAuth(boolean tf) throws GSSException {
        this.mutualAuth = tf;
    }

    @Override
    public void requestReplayDet(boolean tf) throws GSSException {
        this.relayDet = tf;
    }

    @Override
    public void requestSequenceDet(boolean tf) throws GSSException {
        this.sequenceDet = false;
    }

    @Override
    public void requestCredDeleg(boolean tf) throws GSSException {
        this.credDeleg = tf;
    }

    @Override
    public void requestAnonymity(boolean tf) throws GSSException {
        this.anonymity = tf;
    }

    @Override
    public void requestConf(boolean tf) throws GSSException {
        this.conf = tf;
    }

    @Override
    public void requestInteg(boolean tf) throws GSSException {
        this.integ = tf;
    }

    @Override
    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        this.channelBinding = cb;
    }

    @Override
    public boolean getCredDelegState() {
        return this.credDeleg;
    }

    @Override
    public boolean getMutualAuthState() {
        return this.mutualAuth;
    }

    @Override
    public boolean getReplayDetState() {
        return this.relayDet;
    }

    @Override
    public boolean getSequenceDetState() {
        return this.sequenceDet;
    }

    @Override
    public boolean getAnonymityState() {
        return this.anonymity;
    }

    @Override
    public boolean isTransferable() throws GSSException {
        return true;
    }

    @Override
    public boolean isProtReady() {
        return false;
    }

    @Override
    public boolean getConfState() {
        return this.conf;
    }

    @Override
    public boolean getIntegState() {
        return this.integ;
    }

    @Override
    public int getLifetime() {
        return this.lifetime;
    }

    @Override
    public boolean isEstablished() {
        return this.established;
    }

    @Override
    public GSSNameSpi getSrcName() throws GSSException {
        return this.sourceCred.getName();
    }

    @Override
    public GSSNameSpi getTargName() throws GSSException {
        return this.targetName;
    }

    @Override
    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    @Override
    public GSSCredentialSpi getDelegCred() throws GSSException {
        return null;
    }

    @Override
    public byte[] initSecContext(InputStream inStream, int inLen) throws GSSException {
        this.established = true;
        return ((Object)this.sourceCred.getName()).toString().getBytes();
    }

    @Override
    public byte[] acceptSecContext(InputStream inStream, int inLen) throws GSSException {
        this.established = true;
        try {
            byte[] inBytes = new byte[inStream.available()];
            inStream.read(inBytes);
            GSSUPNameSpi sourceName = new GSSUPNameSpi(this.provider, this.mechOid, inBytes, null);
            this.sourceCred = new GSSUPCredentialSpi(this.provider, this.mechOid, sourceName, 0, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public int getWrapSizeLimit(int i1, boolean b1, int i2) throws GSSException {
        return 0;
    }

    @Override
    public void wrap(InputStream inStream, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    @Override
    public byte[] wrap(byte[] b, int i1, int i2, MessageProp mp) throws GSSException {
        return null;
    }

    public int wrap(byte[] b1, int i1, int i2, byte[] b2, int i3, MessageProp mp) throws GSSException {
        return 0;
    }

    public void wrap(byte[] b, int i1, int i2, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    @Override
    public void unwrap(InputStream inStream, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    @Override
    public byte[] unwrap(byte[] b, int i1, int i2, MessageProp mp) throws GSSException {
        return null;
    }

    public int unwrap(byte[] b1, int i1, int i2, byte[] b2, int i3, MessageProp mp) throws GSSException {
        return 0;
    }

    public int unwrap(InputStream inStream, byte[] b, int i1, MessageProp mp) throws GSSException {
        return 0;
    }

    @Override
    public void getMIC(InputStream inStream, OutputStream outStream, MessageProp mp) throws GSSException {
    }

    @Override
    public byte[] getMIC(byte[] b1, int i1, int i2, MessageProp mp) throws GSSException {
        return null;
    }

    @Override
    public void verifyMIC(InputStream inStream1, InputStream inStream2, MessageProp mp) throws GSSException {
    }

    @Override
    public void verifyMIC(byte[] b1, int i1, int i2, byte[] b2, int i3, int i4, MessageProp mp) throws GSSException {
    }

    @Override
    public byte[] export() throws GSSException {
        return null;
    }

    @Override
    public void dispose() throws GSSException {
        this.channelBinding = null;
        this.provider = null;
        this.mechOid = null;
    }

    @Override
    public boolean isInitiator() {
        return false;
    }

    public Object inquireSecContext(Enum arg0) throws GSSException {
        throw new GSSException(11);
    }

    @Override
    public boolean getDelegPolicyState() {
        return false;
    }

    @Override
    public void requestDelegPolicy(boolean state) {
    }

    public void setNegMechs(Oid[] oids, GSSCredential gssc) throws GSSException {
    }
}

