/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jacorb.orb.ORB;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.slf4j.Logger;

public class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo {
    private int slot_count = 0;
    private final ORB orb;
    private final Logger logger;
    private final Map named_server_interceptors;
    private final List anonymous_server_interceptors;
    private final Map named_client_interceptors;
    private final List anonymous_client_interceptors;
    private final Map named_ior_interceptors;
    private final List anonymous_ior_interceptors;
    private final Map policy_factories;
    private boolean valid = true;

    public ORBInitInfoImpl(ORB orb) {
        this.orb = orb;
        this.logger = orb.getConfiguration().getLogger("org.jacorb.orb");
        this.named_server_interceptors = new TreeMap();
        this.named_client_interceptors = new TreeMap();
        this.anonymous_server_interceptors = new ArrayList();
        this.anonymous_client_interceptors = new ArrayList();
        this.named_ior_interceptors = new TreeMap();
        this.anonymous_ior_interceptors = new ArrayList();
        this.policy_factories = new HashMap();
    }

    public ORB getORB() {
        return this.orb;
    }

    public void setInvalid() {
        this.valid = false;
    }

    private List merge(List target, Map source) {
        ArrayList result = new ArrayList(target);
        result.addAll(source.values());
        return result;
    }

    public List getClientInterceptors() {
        return this.merge(this.anonymous_client_interceptors, this.named_client_interceptors);
    }

    public List getServerInterceptors() {
        return this.merge(this.anonymous_server_interceptors, this.named_server_interceptors);
    }

    public List getIORInterceptors() {
        return this.merge(this.anonymous_ior_interceptors, this.named_ior_interceptors);
    }

    public Map getPolicyFactories() {
        return this.policy_factories;
    }

    public int getSlotCount() {
        return this.slot_count;
    }

    @Override
    public void add_client_request_interceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        this.checkIsValid();
        this.checkInterceptorName(interceptor);
        if (interceptor.name().length() == 0) {
            this.anonymous_client_interceptors.add(interceptor);
        } else {
            if (this.named_client_interceptors.containsKey(interceptor.name())) {
                throw new DuplicateName(interceptor.name());
            }
            this.named_client_interceptors.put(interceptor.name(), interceptor);
        }
    }

    private void checkIsValid() {
        if (!this.valid) {
            throw new OBJECT_NOT_EXIST("This ORBInitIfo is not valid anymore!");
        }
    }

    private void checkInterceptorName(Interceptor interceptor) throws DuplicateName {
        if (interceptor.name() == null) {
            throw new DuplicateName("the name is null");
        }
    }

    @Override
    public void add_ior_interceptor(IORInterceptor interceptor) throws DuplicateName {
        this.checkInterceptorName(interceptor);
        if (interceptor.name().length() == 0) {
            this.anonymous_ior_interceptors.add(interceptor);
        } else {
            if (this.named_ior_interceptors.containsKey(interceptor.name())) {
                throw new DuplicateName(interceptor.name());
            }
            this.named_ior_interceptors.put(interceptor.name(), interceptor);
        }
    }

    @Override
    public void add_server_request_interceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        this.checkIsValid();
        this.checkInterceptorName(interceptor);
        if (interceptor.name().length() == 0) {
            this.anonymous_server_interceptors.add(interceptor);
        } else {
            if (this.named_server_interceptors.containsKey(interceptor.name())) {
                throw new DuplicateName(interceptor.name());
            }
            this.named_server_interceptors.put(interceptor.name(), interceptor);
        }
    }

    @Override
    public int allocate_slot_id() {
        this.checkIsValid();
        return this.slot_count++;
    }

    @Override
    public String[] arguments() {
        this.checkIsValid();
        return this.orb.getArgs();
    }

    @Override
    public CodecFactory codec_factory() {
        this.checkIsValid();
        try {
            return (CodecFactory)this.orb.resolve_initial_references("CodecFactory");
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            this.logger.error("unexpected error", e);
            throw new INTERNAL(e.toString());
        }
    }

    @Override
    public String orb_id() {
        this.checkIsValid();
        return this.orb.id();
    }

    @Override
    public void register_initial_reference(String id, Object obj) throws InvalidName {
        this.checkIsValid();
        try {
            this.orb.register_initial_reference(id, obj);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new InvalidName();
        }
    }

    @Override
    public void register_policy_factory(int type, PolicyFactory policy_factory) {
        this.checkIsValid();
        if (policy_factory == null) {
            throw new BAD_PARAM("Actual parameter policy_factory is null!");
        }
        Integer key = type;
        if (this.policy_factories.containsKey(key)) {
            throw new BAD_INV_ORDER("A PolicyFactory for type " + type + " has already been registered!", 12, CompletionStatus.COMPLETED_MAYBE);
        }
        this.policy_factories.put(key, policy_factory);
    }

    @Override
    public Object resolve_initial_references(String id) throws InvalidName {
        this.checkIsValid();
        try {
            return this.orb.resolve_initial_references(id);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new InvalidName();
        }
    }
}

