/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.etf.ListenEndpoint;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.omg.CORBA.portable.InputStream;
import org.slf4j.Logger;

public class IIOPAddress
extends ProtocolAddressBase {
    private String source_name = null;
    private InetAddress host = null;
    private InetAddress pseudo_host = null;
    private int port = -1;
    private boolean unresolvable = false;
    private boolean dnsEnabled = false;
    private boolean hideZoneID = true;
    private Logger logger;
    private boolean doEagerResolve = true;
    private boolean forceDNSLookup = true;
    private ListenEndpoint.Protocol protocol = null;
    private boolean isWildcard = false;
    private boolean isConfigured = false;

    public IIOPAddress() {
    }

    public IIOPAddress(String hoststr, int port) {
        this();
        this.source_name = hoststr;
        this.init_port(port);
    }

    public IIOPAddress(ServerSocket serverSocket) {
        this();
        this.host = serverSocket.getInetAddress();
        this.port = serverSocket.getLocalPort();
        this.isWildcard = serverSocket.getInetAddress().isAnyLocalAddress();
        if (this.isWildcard) {
            this.pseudo_host = IIOPAddress.getLocalHost();
            this.source_name = this.pseudo_host.getHostName();
        } else {
            this.source_name = serverSocket.getInetAddress().toString();
            int slash_delim = this.source_name.indexOf(47);
            if (slash_delim > 0) {
                this.source_name = this.source_name.substring(0, slash_delim);
            }
        }
        this.isConfigured = true;
    }

    private void init_port(int port) {
        this.port = port < 0 ? port + 65536 : port;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.logger = this.configuration.getLogger("org.jacorb.iiop.address");
        this.dnsEnabled = configuration.getAttributeAsBoolean("jacorb.dns.enable", false);
        this.hideZoneID = configuration.getAttributeAsBoolean("jacorb.ipv6.hide_zoneid", true);
        this.doEagerResolve = configuration.getAttributeAsBoolean("jacorb.dns.eager_resolve", true);
        this.forceDNSLookup = configuration.getAttributeAsBoolean("jacorb.dns.force_lookup", true);
        if (this.isConfigured) {
            return;
        }
        if (this.doEagerResolve) {
            this.init_host();
        }
        this.isConfigured = true;
    }

    private void init_host() {
        boolean hasZoneId = false;
        if (this.source_name == null || this.source_name.length() == 0) {
            this.host = null;
        } else {
            int slash = this.source_name.indexOf(47);
            if (slash > 0) {
                this.source_name = this.source_name.substring(0, slash);
            }
            try {
                this.host = InetAddress.getByName(this.source_name);
            }
            catch (UnknownHostException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("init_host, " + this.source_name + " unresolvable");
                }
                this.unresolvable = true;
                try {
                    this.host = InetAddress.getLocalHost();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("init_host, default to " + this.host.toString());
                    }
                }
                catch (UnknownHostException ex2) {
                    // empty catch block
                }
            }
        }
    }

    public static IIOPAddress read(InputStream in) {
        String host = in.read_string();
        short port = in.read_ushort();
        return new IIOPAddress(host, port);
    }

    public void setProtocol(ListenEndpoint.Protocol proto) {
        this.protocol = proto;
    }

    public ListenEndpoint.Protocol getProtocol() {
        return this.protocol;
    }

    public String getIP() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable || this.host == null) {
            return this.source_name;
        }
        if (!this.dnsEnabled) {
            if (!this.isWildcard()) {
                return this.host.getHostAddress();
            }
            if (this.pseudo_host != null) {
                return this.pseudo_host.getHostAddress();
            }
        }
        if (!this.isWildcard()) {
            return this.forceDNSLookup ? this.host.getCanonicalHostName() : this.host.getHostName();
        }
        if (this.pseudo_host != null) {
            return this.forceDNSLookup ? this.pseudo_host.getCanonicalHostName() : this.pseudo_host.getHostName();
        }
        return null;
    }

    public String getHostname() {
        if (this.host == null) {
            this.init_host();
        }
        if (this.unresolvable || this.host == null) {
            return this.source_name;
        }
        if (!this.isWildcard()) {
            return this.dnsEnabled ? this.host.getCanonicalHostName() : this.host.getHostAddress();
        }
        if (this.pseudo_host != null) {
            return this.dnsEnabled ? this.pseudo_host.getCanonicalHostName() : this.pseudo_host.getHostAddress();
        }
        return null;
    }

    public void setHostname(String hn) {
        this.host = null;
        this.source_name = hn;
        if (this.doEagerResolve) {
            this.init_host();
        }
    }

    public InetAddress getConfiguredHost() {
        if (this.source_name == null || this.source_name.length() == 0) {
            return null;
        }
        if (this.host == null) {
            this.init_host();
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setHostInetAddress(InetAddress hostInetAddr) {
        if (this.host == null) {
            this.host = hostInetAddr;
            this.isWildcard = this.host.isAnyLocalAddress();
            if (this.isWildcard) {
                this.pseudo_host = IIOPAddress.getLocalHost();
                this.source_name = this.pseudo_host.getHostName();
            } else {
                this.source_name = this.host.toString();
                int slash_delim = this.source_name.indexOf(47);
                if (slash_delim > 0) {
                    this.source_name = this.source_name.substring(0, slash_delim);
                }
            }
        }
    }

    public InetAddress getHostInetAddress() {
        return this.host;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public void setWildcardHost(boolean state) {
        this.isWildcard = state;
    }

    public boolean equals(Object other) {
        if (other instanceof IIOPAddress) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getHostname() + ":" + this.port;
    }

    @Override
    public boolean fromString(String s) {
        if (s.charAt(0) == '[') {
            return this.fromStringIPv6(s);
        }
        return this.fromStringIPv4(s);
    }

    private boolean fromStringIPv6(String s) {
        int end_bracket = s.indexOf(93);
        if (end_bracket < 0) {
            return false;
        }
        int route_delim = s.lastIndexOf(37, end_bracket);
        this.source_name = route_delim < 0 ? s.substring(1, end_bracket) : s.substring(1, route_delim);
        int port_colon = s.indexOf(58, end_bracket);
        if (port_colon < 0) {
            return false;
        }
        int _port = Integer.parseInt(s.substring(port_colon + 1));
        this.init_host();
        this.init_port(_port);
        return true;
    }

    private boolean fromStringIPv4(String s) {
        int colon = s.indexOf(58);
        if (colon == -1) {
            return false;
        }
        this.source_name = colon > 0 ? s.substring(0, colon) : "";
        int _port = 0;
        if (colon < s.length() - 1) {
            _port = Integer.parseInt(s.substring(colon + 1));
        }
        this.init_host();
        this.init_port(_port);
        return true;
    }

    @Override
    public void write(CDROutputStream cdr) {
        int zoneIndex;
        String hostname = this.getHostname();
        if (this.hideZoneID && (zoneIndex = hostname.indexOf(37)) != -1) {
            hostname = hostname.substring(0, zoneIndex);
        }
        cdr.write_string(hostname);
        cdr.write_ushort((short)this.port);
    }

    public String getOriginalHost() {
        if (this.source_name == null) {
            if (!this.dnsEnabled) {
                return this.getIP();
            }
            return this.getHostname() + " / " + this.getIP();
        }
        return this.source_name;
    }

    void replaceFrom(IIOPAddress other) {
        if (other.source_name != null) {
            this.setHostname(other.source_name);
        }
        if (other.port != -1) {
            this.setPort(other.port);
        }
    }

    public static String getLocalHostAddress(Logger logger) {
        InetAddress addr = IIOPAddress.getLocalHost();
        if (addr != null) {
            return addr.getHostAddress();
        }
        logger.warn("Unable to resolve local IP address - using default");
        return "127.0.0.1";
    }

    public static InetAddress getLocalHost() {
        InetAddress result = null;
        try {
            InetAddress betterAddress;
            result = InetAddress.getLocalHost();
            if ((result.isLinkLocalAddress() || result.isLoopbackAddress()) && (betterAddress = IIOPAddress.getGoodAddress()) != null) {
                result = betterAddress;
            }
        }
        catch (UnknownHostException ex) {
            try {
                result = InetAddress.getByName(null);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return result;
    }

    private static InetAddress getGoodAddress() {
        InetAddress result = null;
        try {
            for (NetworkInterface ni : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (ni.isPointToPoint()) continue;
                for (InetAddress ia : Collections.list(ni.getInetAddresses())) {
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress()) continue;
                    return ia;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public ProtocolAddressBase copy() {
        IIOPAddress result = new IIOPAddress(this.getHostname(), this.port);
        result.logger = this.logger;
        return result;
    }
}

