/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.jmx;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.util.LogUtil;
import org.nanocontainer.remoting.jmx.DynamicMBeanProvider;
import org.nanocontainer.remoting.jmx.JMXRegistrationInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.slf4j.Logger;

public class UnregisterObjectNameProviderDecorator
implements DynamicMBeanProvider {
    private final DynamicMBeanProvider delegate_;
    final MBeanServer mbeanServer_;
    final Logger logger_ = LogUtil.getLogger(this.getClass().getName());

    public UnregisterObjectNameProviderDecorator(MBeanServer mbeanServer, DynamicMBeanProvider delegate) {
        this.mbeanServer_ = mbeanServer;
        this.delegate_ = delegate;
    }

    public JMXRegistrationInfo provide(PicoContainer picoContainer, ComponentAdapter componentAdapter) {
        final JMXRegistrationInfo _info = this.delegate_.provide(picoContainer, componentAdapter);
        if (_info != null) {
            try {
                JMXManageable manageable = (JMXManageable)componentAdapter.getComponentInstance(picoContainer);
                manageable.registerDisposable(new Disposable(){

                    @Override
                    public void dispose() {
                        try {
                            UnregisterObjectNameProviderDecorator.this.logger_.info("Unregister MBean " + _info.getObjectName());
                            UnregisterObjectNameProviderDecorator.this.mbeanServer_.unregisterMBean(_info.getObjectName());
                        }
                        catch (InstanceNotFoundException e) {
                            UnregisterObjectNameProviderDecorator.this.logger_.error("Error while unregistering MBean " + _info.getObjectName(), e);
                        }
                        catch (MBeanRegistrationException e) {
                            UnregisterObjectNameProviderDecorator.this.logger_.error("Error while unregistering MBean " + _info.getObjectName(), e);
                        }
                    }
                });
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return _info;
    }
}

