/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.UnaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class OrOperator
extends UnaryOperator {
    private static final String NAME = "OrOperator";
    private static final String STRING_REP = "or";

    public OrOperator(Token tok) {
        super(tok);
        this.setName(NAME);
    }

    @Override
    public String toString() {
        return STRING_REP;
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left) throws EvaluationException {
        if (left.getBool()) {
            return EvaluationResult.BOOL_TRUE;
        }
        if (this.right().evaluate(context).getBool()) {
            return EvaluationResult.BOOL_TRUE;
        }
        return EvaluationResult.BOOL_FALSE;
    }

    @Override
    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitOr(this);
        this.right().acceptInOrder(visitor);
    }

    @Override
    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitOr(this);
        this.left().acceptPreOrder(visitor);
        this.right().acceptPreOrder(visitor);
    }

    @Override
    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        this.right().acceptPostOrder(visitor);
        visitor.visitOr(this);
    }
}

