/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.UnaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class MinusOperator
extends UnaryOperator {
    private boolean unary_;
    private static final String NAME = "MinusOperator";

    public MinusOperator(Token tok) {
        super(tok);
        this.setName(NAME);
    }

    @Override
    public void setType(int type) {
        this.unary_ = type == 18;
    }

    @Override
    public String toString() {
        return " -";
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left) throws EvaluationException {
        if (this.unary_) {
            return EvaluationResult.unaryMinus(left);
        }
        return EvaluationResult.minus(left, this.right().evaluate(context));
    }

    @Override
    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitMinus(this);
        if (!this.unary_) {
            this.right().acceptInOrder(visitor);
        }
    }

    @Override
    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        if (!this.unary_) {
            this.right().acceptPostOrder(visitor);
        }
        visitor.visitMinus(this);
    }

    @Override
    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitMinus(this);
        this.left().acceptPreOrder(visitor);
        if (!this.unary_) {
            this.right().acceptPreOrder(visitor);
        }
    }
}

