/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.notification.AbstractMessage;
import org.jacorb.notification.EventTypeWrapper;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.conf.Default;
import org.jacorb.notification.filter.AbstractFilterMBean;
import org.jacorb.notification.filter.CallbackManager;
import org.jacorb.notification.filter.ConstraintEntry;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.filter.FilterUsageDecorator;
import org.jacorb.notification.filter.PropertyDoesNotExistException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.EvaluationContextFactory;
import org.jacorb.notification.interfaces.GCDisposable;
import org.jacorb.notification.interfaces.JMXManageable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.lifecycle.IServantLifecyle;
import org.jacorb.notification.lifecycle.ServantLifecyleControl;
import org.jacorb.notification.util.DisposableManager;
import org.jacorb.notification.util.LogUtil;
import org.jacorb.notification.util.WildcardMap;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.FilterOperations;
import org.omg.CosNotifyFilter.FilterPOATie;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.slf4j.Logger;

public abstract class AbstractFilter
implements GCDisposable,
IServantLifecyle,
FilterOperations,
JMXManageable,
AbstractFilterMBean {
    private static int sCount_ = 0;
    private final int number_ = ++sCount_;
    static final RuntimeException NOT_SUPPORTED = new UnsupportedOperationException("this operation is not supported");
    public static final int NO_CONSTRAINTS_MATCH = -2;
    public static final int CONSTRAINTS_EMPTY = -1;
    private static final String EMPTY_EVENT_TYPE_CONSTRAINT_KEY = AbstractMessage.calcConstraintKey("*", "*");
    private final DisposableManager disposables_ = new DisposableManager();
    private final CallbackManager callbackManager_ = new CallbackManager();
    protected final Map constraints_ = new HashMap();
    protected final WildcardMap wildcardMap_;
    protected final ReadWriteLock constraintsLock_;
    private final AtomicInteger constraintIdPool_ = new AtomicInteger(0);
    protected final MessageFactory messageFactory_;
    private final FilterUsageDecorator filterUsageDecorator_;
    private final POA poa_;
    private final Logger logger_;
    private final EvaluationContextFactory evaluationContextFactory_;
    private final long maxIdleTime_;
    private final ServantLifecyleControl servantLifecyle_;

    protected AbstractFilter(Configuration config, EvaluationContextFactory evaluationContextFactory, MessageFactory messageFactory, POA poa) throws ConfigurationException {
        this.poa_ = poa;
        this.logger_ = LogUtil.getLogger(config, this.getClass().getName());
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("Created filter for Grammar: " + this.constraint_grammar());
        }
        this.messageFactory_ = messageFactory;
        this.evaluationContextFactory_ = evaluationContextFactory;
        this.constraintsLock_ = new ReentrantReadWriteLock();
        this.wildcardMap_ = this.newWildcardMap(config);
        this.disposables_.addDisposable(this.callbackManager_);
        this.filterUsageDecorator_ = new FilterUsageDecorator(this);
        this.maxIdleTime_ = config.getAttributeAsLong("jacorb.notification.filter.dead_interval", 0L);
        this.servantLifecyle_ = new ServantLifecyleControl((IServantLifecyle)this, config);
    }

    @Override
    public final Servant newServant() {
        return new FilterPOATie(this.filterUsageDecorator_.getFilterOperations());
    }

    @Override
    public final POA getPOA() {
        return this.poa_;
    }

    private WildcardMap newWildcardMap(Configuration config) throws ConfigurationException {
        String wildcardMapImpl = config.getAttribute("jacorb.notification.filter.wildcardmap_impl", Default.DEFAULT_WILDCARDMAP_IMPL);
        try {
            Class<?> wildcardMapClazz = ObjectUtil.classForName(wildcardMapImpl);
            Constructor<?> ctor = wildcardMapClazz.getConstructor(new Class[0]);
            return (WildcardMap)ctor.newInstance(new java.lang.Object[0]);
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        throw new ConfigurationException(wildcardMapImpl + " is no valid WildcardMap Implementation");
    }

    public final Object activate() {
        return this.servantLifecyle_.activate();
    }

    public final void deactivate() {
        this.servantLifecyle_.deactivate();
    }

    protected int newConstraintId() {
        return this.constraintIdPool_.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstraintInfo[] add_constraints(ConstraintExp[] constraintExp) throws InvalidConstraint {
        FilterConstraint[] _arrayFilterConstraint = this.newFilterConstraints(constraintExp);
        this.constraintsLock_.writeLock().lock();
        try {
            ConstraintInfo[] constraintInfoArray = this.add_constraint(constraintExp, _arrayFilterConstraint);
            return constraintInfoArray;
        }
        finally {
            this.constraintsLock_.writeLock().unlock();
        }
    }

    private ConstraintInfo[] add_constraint(ConstraintExp[] constraintExp, FilterConstraint[] filterConstraints) {
        ConstraintInfo[] _arrayConstraintInfo = new ConstraintInfo[filterConstraints.length];
        for (int _x = 0; _x < constraintExp.length; ++_x) {
            int _constraintId = this.newConstraintId();
            _arrayConstraintInfo[_x] = new ConstraintInfo(constraintExp[_x], _constraintId);
            ConstraintEntry _entry = new ConstraintEntry(filterConstraints[_x], _arrayConstraintInfo[_x]);
            this.addEventTypeMappingsForConstraint(_entry);
            this.constraints_.put(new Integer(_constraintId), _entry);
            this.notifyCallbacks();
        }
        return _arrayConstraintInfo;
    }

    private void addEventTypeMappingsForConstraint(ConstraintEntry entry) {
        int _eventTypeCount = entry.getEventTypeCount();
        if (_eventTypeCount == 0) {
            this.addConstraintEntryToWildcardMap(EMPTY_EVENT_TYPE_CONSTRAINT_KEY, entry);
        } else {
            for (int _y = 0; _y < _eventTypeCount; ++_y) {
                EventTypeWrapper _eventTypeWrapper = entry.getEventTypeWrapper(_y);
                this.addConstraintEntryToWildcardMap(_eventTypeWrapper.getConstraintKey(), entry);
            }
        }
    }

    private void addConstraintEntryToWildcardMap(String constraintKey, ConstraintEntry constraintEntry) {
        LinkedList<ConstraintEntry> _listOfConstraintEntry = (LinkedList<ConstraintEntry>)this.wildcardMap_.getNoExpansion(constraintKey);
        if (_listOfConstraintEntry == null) {
            _listOfConstraintEntry = new LinkedList<ConstraintEntry>();
            this.wildcardMap_.put(constraintKey, _listOfConstraintEntry);
        }
        _listOfConstraintEntry.add(constraintEntry);
    }

    private FilterConstraint[] newFilterConstraints(ConstraintExp[] constraintExp) throws InvalidConstraint {
        FilterConstraint[] _arrayFilterConstraint = new FilterConstraint[constraintExp.length];
        for (int _x = 0; _x < constraintExp.length; ++_x) {
            _arrayFilterConstraint[_x] = this.newFilterConstraint(constraintExp[_x]);
        }
        return _arrayFilterConstraint;
    }

    protected abstract FilterConstraint newFilterConstraint(ConstraintExp var1) throws InvalidConstraint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify_constraints(int[] deleteIds, ConstraintInfo[] constraintInfo) throws ConstraintNotFound, InvalidConstraint {
        this.constraintsLock_.writeLock().lock();
        try {
            Integer[] _deleteKeys = this.checkConstraintsToBeDeleted(deleteIds);
            FilterConstraint[] _arrayConstraintEvaluator = this.checkConstraintsToBeModified(constraintInfo);
            this.deleteConstraints(_deleteKeys);
            this.modifyConstraints(constraintInfo, _arrayConstraintEvaluator);
            this.notifyCallbacks();
        }
        finally {
            this.constraintsLock_.writeLock().unlock();
        }
    }

    private void modifyConstraints(ConstraintInfo[] constraintInfo, FilterConstraint[] filterConstraints) {
        for (int _x = 0; _x < constraintInfo.length; ++_x) {
            Integer _key = new Integer(constraintInfo[_x].constraint_id);
            ConstraintEntry _updatedEntry = new ConstraintEntry(filterConstraints[_x], constraintInfo[_x]);
            this.constraints_.put(_key, _updatedEntry);
            int _eventTypeCount = _updatedEntry.getEventTypeCount();
            for (int _y = 0; _y < _eventTypeCount; ++_y) {
                EventTypeWrapper _eventTypeIdentifier = _updatedEntry.getEventTypeWrapper(_y);
                List _listOfConstraintEvaluator = (List)this.wildcardMap_.getNoExpansion(_eventTypeIdentifier.getConstraintKey());
                _listOfConstraintEvaluator.add(_updatedEntry);
            }
        }
    }

    private FilterConstraint[] checkConstraintsToBeModified(ConstraintInfo[] constraintInfo) throws InvalidConstraint, ConstraintNotFound {
        FilterConstraint[] _arrayConstraintEvaluator = new FilterConstraint[constraintInfo.length];
        for (int _x = 0; _x < constraintInfo.length; ++_x) {
            if (!this.constraints_.containsKey(new Integer(constraintInfo[_x].constraint_id))) {
                throw new ConstraintNotFound(constraintInfo[_x].constraint_id);
            }
            _arrayConstraintEvaluator[_x] = this.newFilterConstraint(constraintInfo[_x].constraint_expression);
        }
        return _arrayConstraintEvaluator;
    }

    private Integer[] checkConstraintsToBeDeleted(int[] idsToBeDeleted) throws ConstraintNotFound {
        Integer[] _deleteKeys = new Integer[idsToBeDeleted.length];
        for (int _x = 0; _x < idsToBeDeleted.length; ++_x) {
            _deleteKeys[_x] = new Integer(idsToBeDeleted[_x]);
            if (this.constraints_.containsKey(_deleteKeys[_x])) continue;
            throw new ConstraintNotFound(idsToBeDeleted[_x]);
        }
        return _deleteKeys;
    }

    private void deleteConstraints(Integer[] keys) {
        for (int _x = 0; _x < keys.length; ++_x) {
            ConstraintEntry _deletedEntry = (ConstraintEntry)this.constraints_.remove(keys[_x]);
            this.removeEventTypeMappingForConstraint(keys[_x], _deletedEntry);
        }
    }

    private void removeEventTypeMappingForConstraint(Integer key, ConstraintEntry deletedEntry) {
        int _eventTypeCount = deletedEntry.getEventTypeCount();
        block0: for (int _y = 0; _y < _eventTypeCount; ++_y) {
            EventTypeWrapper _eventTypeIdentifier = deletedEntry.getEventTypeWrapper(_y);
            List _listOfConstraintEvaluator = (List)this.wildcardMap_.getNoExpansion(_eventTypeIdentifier.getConstraintKey());
            Iterator _i = _listOfConstraintEvaluator.iterator();
            while (_i.hasNext()) {
                ConstraintEntry _constraint = (ConstraintEntry)_i.next();
                if (_constraint.getConstraintId() != key.intValue()) continue;
                _i.remove();
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstraintInfo[] get_constraints(int[] ids) throws ConstraintNotFound {
        Lock _lock = this.constraintsLock_.readLock();
        _lock.lock();
        try {
            ConstraintInfo[] _constraintInfo = new ConstraintInfo[ids.length];
            for (int _x = 0; _x < ids.length; ++_x) {
                Integer _key = new Integer(ids[_x]);
                if (!this.constraints_.containsKey(_key)) {
                    throw new ConstraintNotFound(ids[_x]);
                }
                _constraintInfo[_x] = ((ConstraintEntry)this.constraints_.get(_key)).getConstraintInfo();
            }
            ConstraintInfo[] constraintInfoArray = _constraintInfo;
            return constraintInfoArray;
        }
        finally {
            _lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstraintInfo[] get_all_constraints() {
        this.constraintsLock_.readLock().lock();
        try {
            ConstraintInfo[] _constraintInfo = new ConstraintInfo[this.constraints_.size()];
            Iterator _i = this.constraints_.values().iterator();
            for (int i = 0; i < _constraintInfo.length; ++i) {
                _constraintInfo[i] = ((ConstraintEntry)_i.next()).getConstraintInfo();
            }
            ConstraintInfo[] constraintInfoArray = _constraintInfo;
            return constraintInfoArray;
        }
        finally {
            this.constraintsLock_.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove_all_constraints() {
        this.constraintsLock_.writeLock().lock();
        try {
            this.constraints_.clear();
            this.wildcardMap_.clear();
            this.notifyCallbacks();
        }
        finally {
            this.constraintsLock_.writeLock().unlock();
        }
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    private Iterator getConstraintsForEvent(Message event) {
        String _key = event.getConstraintKey();
        return this.getIterator(_key);
    }

    public Iterator getIterator(java.lang.Object key) {
        java.lang.Object[] _entries = this.wildcardMap_.getWithExpansion(key);
        return new ConstraintIterator(_entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int match_ReadLock(EvaluationContext evaluationContext, Message event) throws UnsupportedFilterableData {
        this.constraintsLock_.readLock().lock();
        try {
            int n = this.match_NoLock(evaluationContext, event);
            return n;
        }
        finally {
            this.constraintsLock_.readLock().unlock();
        }
    }

    private int match_NoLock(EvaluationContext evaluationContext, Message event) throws UnsupportedFilterableData {
        if (!this.constraints_.isEmpty()) {
            Iterator _entries = this.getConstraintsForEvent(event);
            while (_entries.hasNext()) {
                ConstraintEntry _entry = (ConstraintEntry)_entries.next();
                try {
                    boolean _result = _entry.getFilterConstraint().evaluate(evaluationContext, event).getBool();
                    if (!_result) continue;
                    return _entry.getConstraintId();
                }
                catch (PropertyDoesNotExistException e) {
                    if (this.logger_.isInfoEnabled()) {
                        this.logger_.info("tried to access non existing Property: " + e.getMessage());
                        continue;
                    }
                    if (!this.logger_.isDebugEnabled()) continue;
                    this.logger_.debug("tried to access non existing Property", e);
                }
                catch (EvaluationException e) {
                    this.logger_.error("Error evaluating filter", e);
                    throw new UnsupportedFilterableData(e.getMessage());
                }
            }
            return -2;
        }
        this.logger_.info("Filter has no Expressions");
        return -1;
    }

    @Override
    public boolean match(Any anyEvent) throws UnsupportedFilterableData {
        return this.match_internal(anyEvent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_internal(Any anyEvent) throws UnsupportedFilterableData {
        EvaluationContext _evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message _event = this.messageFactory_.newMessage(anyEvent);
            try {
                n = this.match_ReadLock(_evaluationContext, _event);
            }
            catch (Throwable throwable) {
                _event.dispose();
                throw throwable;
            }
            _event.dispose();
            return n;
        }
        finally {
            _evaluationContext.dispose();
        }
    }

    @Override
    public boolean match_structured(StructuredEvent structuredevent) throws UnsupportedFilterableData {
        return this.match_structured_internal(structuredevent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_structured_internal(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        EvaluationContext _evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message _event = this.messageFactory_.newMessage(structuredEvent);
            try {
                n = this.match_ReadLock(_evaluationContext, _event);
            }
            catch (Throwable throwable) {
                _event.dispose();
                throw throwable;
            }
            _event.dispose();
            return n;
        }
        finally {
            _evaluationContext.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_typed_internal(Property[] typedEvent) throws UnsupportedFilterableData {
        EvaluationContext _evaluationContext = this.evaluationContextFactory_.newEvaluationContext();
        try {
            int n;
            Message _event = this.messageFactory_.newMessage(typedEvent);
            try {
                n = this.match_ReadLock(_evaluationContext, _event);
            }
            catch (Throwable throwable) {
                _event.dispose();
                throw throwable;
            }
            _event.dispose();
            return n;
        }
        finally {
            _evaluationContext.dispose();
        }
    }

    @Override
    public boolean match_typed(Property[] properties) throws UnsupportedFilterableData {
        return this.match_typed_internal(properties) >= 0;
    }

    @Override
    public int attach_callback(NotifySubscribe notifySubscribe) {
        return this.callbackManager_.attach_callback(notifySubscribe);
    }

    @Override
    public void detach_callback(int id) {
        this.callbackManager_.detach_callback(id);
    }

    @Override
    public int[] get_callbacks() {
        return this.callbackManager_.get_callbacks();
    }

    private void notifyCallbacks() {
        Iterator i = this.constraints_.keySet().iterator();
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        while (i.hasNext()) {
            java.lang.Object key = i.next();
            ConstraintEntry value = (ConstraintEntry)this.constraints_.get(key);
            int ets = value.getEventTypeCount();
            for (int j = 0; j < ets; ++j) {
                EventTypeWrapper et = value.getEventTypeWrapper(j);
                eventTypes.add(et.getEventType());
            }
        }
        this.callbackManager_.replaceWith(eventTypes.toArray(EventTypeWrapper.EMPTY_EVENT_TYPE_ARRAY));
    }

    @Override
    public void dispose() {
        this.deactivate();
        this.disposables_.dispose();
    }

    @Override
    public void registerDisposable(Disposable disposeHook) {
        this.disposables_.addDisposable(disposeHook);
    }

    @Override
    public Date getLastUsage() {
        return this.filterUsageDecorator_.getLastUsage();
    }

    @Override
    public Date getCreationDate() {
        return this.filterUsageDecorator_.getCreationDate();
    }

    @Override
    public long getMatchCount() {
        return this.filterUsageDecorator_.getMatchCount();
    }

    @Override
    public long getMatchStructuredCount() {
        return this.filterUsageDecorator_.getMatchStructuredCount();
    }

    @Override
    public long getMatchTypedCount() {
        return this.filterUsageDecorator_.getMatchTypedCount();
    }

    @Override
    public String listContraints() {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entry : this.constraints_.entrySet()) {
            ConstraintEntry _constraintEntry = (ConstraintEntry)entry.getValue();
            _constraintEntry.appendToBuffer(buffer);
        }
        return buffer.toString();
    }

    @Override
    public final String getJMXObjectName() {
        return "type=filter, number=" + this.number_ + ", grammar=" + this.constraint_grammar();
    }

    @Override
    public String[] getJMXNotificationTypes() {
        return new String[0];
    }

    @Override
    public void setJMXCallback(JMXManageable.JMXCallback callback) {
    }

    @Override
    public void attemptDispose() {
        AbstractFilter.attemptDispose(this, this.getLastUsage(), this.maxIdleTime_);
    }

    static void attemptDispose(Disposable disposable, Date lastUsage, long maxIdleTime) {
        if (maxIdleTime <= 0L) {
            return;
        }
        if (lastUsage.getTime() + maxIdleTime < System.currentTimeMillis()) {
            disposable.dispose();
        }
    }

    private static class ConstraintIterator
    implements Iterator {
        private final java.lang.Object[] arrayOfLists_;
        private Iterator currentIterator_;
        private int currentListIdx_ = 0;

        ConstraintIterator(java.lang.Object[] arrayOfLists) {
            this.arrayOfLists_ = arrayOfLists;
            if (this.arrayOfLists_.length == 0) {
                this.currentIterator_ = null;
            } else {
                this.switchIterator();
            }
        }

        private void switchIterator() {
            this.currentIterator_ = ((List)this.arrayOfLists_[this.currentListIdx_]).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator_ != null && this.currentIterator_.hasNext();
        }

        public java.lang.Object next() {
            if (this.currentIterator_ == null) {
                throw new NoSuchElementException();
            }
            java.lang.Object _nextValue = this.currentIterator_.next();
            if (!this.currentIterator_.hasNext() && this.currentListIdx_ < this.arrayOfLists_.length - 1) {
                ++this.currentListIdx_;
                this.switchIterator();
            }
            return _nextValue;
        }

        @Override
        public void remove() {
            throw NOT_SUPPORTED;
        }
    }
}

