/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.parser;

import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.parser.CharacterBuffer;
import net.entropysoft.transmorph.signature.parser.ClassFileTypeSignatureParser;
import net.entropysoft.transmorph.signature.parser.ITypeSignatureParser;
import net.entropysoft.transmorph.signature.parser.InvalidSignatureException;
import net.entropysoft.transmorph.signature.parser.PrimitiveTypeUtils;
import net.entropysoft.transmorph.signature.parser.UnexpectedCharacterException;

public class ClassGetNameTypeSignatureParser
implements ITypeSignatureParser {
    private CharacterBuffer typeSignature;
    private ClassFileTypeSignatureParser typeSignatureParser = new ClassFileTypeSignatureParser();

    public ClassGetNameTypeSignatureParser() {
        this.typeSignatureParser.setAcceptGenerics(false);
        this.typeSignatureParser.setUseInternalFormFullyQualifiedName(false);
    }

    public ClassGetNameTypeSignatureParser(String signature) {
        this();
        this.setTypeSignature(signature);
    }

    public FullTypeSignature parseTypeSignature() {
        Character primitiveChar = PrimitiveTypeUtils.getChar(this.typeSignature.toString());
        if (primitiveChar != null) {
            return new PrimitiveTypeSignature(primitiveChar.charValue());
        }
        this.typeSignatureParser.setTypeSignature(this.typeSignature);
        if (this.typeSignature.peekChar() == 91) {
            ArrayTypeSignature typeSignature = this.typeSignatureParser.parseArrayTypeSignature();
            this.nextChar(-1);
            return typeSignature;
        }
        ClassTypeSignature typeSignature = this.typeSignatureParser.parseClassName();
        this.nextChar(-1);
        return typeSignature;
    }

    public void setTypeSignature(String signature) {
        this.typeSignature = new CharacterBuffer(signature);
    }

    private int nextChar(int c) {
        try {
            return this.typeSignature.nextChar(c);
        }
        catch (UnexpectedCharacterException e) {
            throw new InvalidSignatureException(e.getMessage(), e.getPosition());
        }
    }
}

