/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.parser;

import java.util.ArrayList;
import net.entropysoft.transmorph.signature.ArrayTypeSignature;
import net.entropysoft.transmorph.signature.ClassTypeSignature;
import net.entropysoft.transmorph.signature.FieldTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.PrimitiveTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;
import net.entropysoft.transmorph.signature.TypeVarSignature;
import net.entropysoft.transmorph.signature.parser.CharacterBuffer;
import net.entropysoft.transmorph.signature.parser.ITypeSignatureParser;
import net.entropysoft.transmorph.signature.parser.InvalidSignatureException;
import net.entropysoft.transmorph.signature.parser.UnexpectedCharacterException;

public class ClassFileTypeSignatureParser
implements ITypeSignatureParser {
    private static final int EOS = -1;
    private boolean acceptGenerics = true;
    private char packageSeparator = (char)47;
    private char innerClassPrefix = (char)46;
    private CharacterBuffer characterBuffer;

    public ClassFileTypeSignatureParser() {
    }

    public ClassFileTypeSignatureParser(boolean useInternalFormFullyQualifiedName) {
        this.setUseInternalFormFullyQualifiedName(useInternalFormFullyQualifiedName);
    }

    public ClassFileTypeSignatureParser(String typeSignature) {
        this.setTypeSignature(typeSignature);
    }

    public ClassFileTypeSignatureParser(String typeSignature, boolean useInternalFormFullyQualifiedName) {
        this.setTypeSignature(typeSignature);
        this.setUseInternalFormFullyQualifiedName(useInternalFormFullyQualifiedName);
    }

    public void setTypeSignature(String signature) {
        this.characterBuffer = new CharacterBuffer(signature);
    }

    public void setTypeSignature(CharacterBuffer characterBuffer) {
        this.characterBuffer = characterBuffer;
    }

    public boolean isAcceptGenerics() {
        return this.acceptGenerics;
    }

    public void setAcceptGenerics(boolean acceptGenerics) {
        this.acceptGenerics = acceptGenerics;
    }

    public void setUseInternalFormFullyQualifiedName(boolean value) {
        if (value) {
            this.packageSeparator = (char)47;
            this.innerClassPrefix = (char)46;
        } else {
            this.packageSeparator = (char)46;
            this.innerClassPrefix = (char)36;
        }
    }

    private boolean isPrimitiveTypeCharacter(int ch) {
        return ch == 90 || ch == 66 || ch == 67 || ch == 68 || ch == 70 || ch == 73 || ch == 74 || ch == 83;
    }

    public FullTypeSignature parseTypeSignature() {
        FullTypeSignature typeSignature = this.parseClassFileTypeSignature();
        this.nextChar(-1);
        return typeSignature;
    }

    private FullTypeSignature parseClassFileTypeSignature() {
        int ch = this.peekChar();
        if (this.isPrimitiveTypeCharacter(ch)) {
            PrimitiveTypeSignature typeSignature = this.parsePrimitiveTypeSignature();
            return typeSignature;
        }
        FieldTypeSignature typeSignature = this.parseFieldTypeSignature();
        return typeSignature;
    }

    private int peekChar() {
        return this.characterBuffer.peekChar();
    }

    private FieldTypeSignature parseFieldTypeSignature() {
        int ch = this.peekChar();
        switch (ch) {
            case 76: {
                return this.parseClassTypeSignature();
            }
            case 91: {
                return this.parseArrayTypeSignature();
            }
            case 84: {
                if (!this.acceptGenerics) break;
                return this.parseTypeVarSignature();
            }
        }
        this.unexpectedCharacterError();
        return null;
    }

    private void unexpectedCharacterError() {
        try {
            this.characterBuffer.unexpectedCharacterError();
        }
        catch (UnexpectedCharacterException e) {
            throw new InvalidSignatureException(e.getMessage(), e.getPosition());
        }
    }

    private TypeVarSignature parseTypeVarSignature() {
        this.nextChar(84);
        String id = this.parseJavaId();
        this.nextChar(59);
        return new TypeVarSignature(id);
    }

    private int nextChar(int c) {
        try {
            return this.characterBuffer.nextChar(c);
        }
        catch (UnexpectedCharacterException e) {
            throw new InvalidSignatureException(e.getMessage(), e.getPosition());
        }
    }

    public PrimitiveTypeSignature parsePrimitiveTypeSignature() {
        int ch = this.nextChar();
        return new PrimitiveTypeSignature((char)ch);
    }

    private int nextChar() {
        return this.characterBuffer.nextChar();
    }

    public ArrayTypeSignature parseArrayTypeSignature() {
        this.nextChar(91);
        return new ArrayTypeSignature(this.parseClassFileTypeSignature());
    }

    private TypeArgSignature parseTypeArg() {
        int ch = this.peekChar();
        switch (ch) {
            case 42: {
                return new TypeArgSignature((char)this.nextChar(TypeArgSignature.UNBOUNDED_WILDCARD), null);
            }
            case 43: {
                return new TypeArgSignature((char)this.nextChar(TypeArgSignature.UPPERBOUND_WILDCARD), this.parseFieldTypeSignature());
            }
            case 45: {
                return new TypeArgSignature((char)this.nextChar(TypeArgSignature.LOWERBOUND_WILDCARD), this.parseFieldTypeSignature());
            }
        }
        return new TypeArgSignature(TypeArgSignature.NO_WILDCARD, this.parseFieldTypeSignature());
    }

    private TypeArgSignature[] parseTypeArgs() {
        this.nextChar(60);
        ArrayList<TypeArgSignature> typeArgSignatures = new ArrayList<TypeArgSignature>();
        typeArgSignatures.add(this.parseTypeArg());
        int ch = this.peekChar();
        while (ch != 62 && ch != -1) {
            typeArgSignatures.add(this.parseTypeArg());
            ch = this.peekChar();
        }
        this.nextChar(62);
        return typeArgSignatures.toArray(new TypeArgSignature[typeArgSignatures.size()]);
    }

    private boolean isJavaIdentifierPart(int codePoint) {
        if (this.innerClassPrefix == '$' && codePoint == 36) {
            return false;
        }
        return Character.isJavaIdentifierPart(codePoint);
    }

    private String parseJavaId() {
        StringBuilder sb = new StringBuilder();
        int ch;
        while ((ch = this.peekChar()) != -1 && this.isJavaIdentifierPart(ch)) {
            sb.append((char)ch);
            this.nextChar();
        }
        return sb.toString();
    }

    private String parseOuterClassName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.parseJavaId());
        while (this.peekChar() == this.packageSeparator) {
            this.nextChar(this.packageSeparator);
            sb.append('.');
            sb.append(this.parseJavaId());
        }
        return sb.toString();
    }

    private ClassTypeSignature parseInnerClass(ClassTypeSignature ownerClassTypeSignature) {
        this.nextChar(this.innerClassPrefix);
        String id = this.parseJavaId();
        int ch = this.peekChar();
        TypeArgSignature[] typeArgSignatures = new TypeArgSignature[]{};
        if (this.acceptGenerics && ch == 60) {
            typeArgSignatures = this.parseTypeArgs();
        }
        return new ClassTypeSignature(id, typeArgSignatures, ownerClassTypeSignature);
    }

    private ClassTypeSignature parseInnerClasses(ClassTypeSignature ownerClassTypeSignature) {
        ClassTypeSignature classTypeSignature = this.parseInnerClass(ownerClassTypeSignature);
        int ch;
        while ((ch = this.peekChar()) == this.innerClassPrefix) {
            classTypeSignature = this.parseInnerClass(classTypeSignature);
        }
        return classTypeSignature;
    }

    private ClassTypeSignature parseClassTypeSignature() {
        this.nextChar(76);
        ClassTypeSignature classTypeSignature = this.parseClassName();
        this.nextChar(59);
        return classTypeSignature;
    }

    public ClassTypeSignature parseClassName() {
        String outerClassName = this.parseOuterClassName();
        TypeArgSignature[] typeArgSignatures = new TypeArgSignature[]{};
        int ch = this.peekChar();
        if (this.acceptGenerics && ch == 60) {
            typeArgSignatures = this.parseTypeArgs();
        }
        ClassTypeSignature classTypeSignature = new ClassTypeSignature(outerClassName, typeArgSignatures, null);
        ch = this.peekChar();
        if (ch == this.innerClassPrefix) {
            classTypeSignature = this.parseInnerClasses(classTypeSignature);
        }
        return classTypeSignature;
    }
}

