/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature.parser;

import net.entropysoft.transmorph.signature.parser.UnexpectedCharacterException;

public class CharacterBuffer {
    private char[] buffer;
    private int position = 0;
    public static final int EOS = -1;

    public CharacterBuffer(String str) {
        this.buffer = str.toCharArray();
    }

    public int nextChar() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        return this.buffer[this.position++];
    }

    public int nextChar(int expectedChar) {
        int ch = this.nextChar();
        if (ch != expectedChar) {
            --this.position;
            this.unexpectedCharacterError();
        }
        return ch;
    }

    public int peekNextNonWhiteSpaceChar() {
        int nextChar = this.peekChar();
        while (Character.isWhitespace(nextChar)) {
            this.nextChar();
            nextChar = this.peekChar();
        }
        return nextChar;
    }

    public int nextNonWhiteSpaceChar() {
        int nextChar = this.nextChar();
        while (Character.isWhitespace(nextChar)) {
            nextChar = this.nextChar();
        }
        return nextChar;
    }

    public int nextNonWhiteSpaceChar(int expectedChar) {
        int ch = this.nextNonWhiteSpaceChar();
        if (ch != expectedChar) {
            --this.position;
            this.unexpectedCharacterError();
        }
        return ch;
    }

    public int peekChar() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        return this.buffer[this.position];
    }

    public int getPosition() {
        return this.position;
    }

    public void unexpectedCharacterError() {
        throw new UnexpectedCharacterException("Unexpected character '" + (char)this.peekChar() + "' at position " + this.position, this.position);
    }

    public String toString() {
        return new String(this.buffer);
    }
}

