/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.signature;

import java.util.ArrayList;
import net.entropysoft.transmorph.signature.FieldTypeSignature;
import net.entropysoft.transmorph.signature.FullTypeSignature;
import net.entropysoft.transmorph.signature.TypeArgSignature;

public class ClassTypeSignature
extends FieldTypeSignature {
    private final String binaryName;
    private final TypeArgSignature[] typeArgSignatures;
    private final ClassTypeSignature ownerTypeSignature;
    private volatile FullTypeSignature typeErasureSignature;

    public ClassTypeSignature(String binaryName, TypeArgSignature[] typeArgSignatures, ClassTypeSignature ownerTypeSignature) {
        this.binaryName = binaryName;
        this.typeArgSignatures = typeArgSignatures;
        this.ownerTypeSignature = ownerTypeSignature;
    }

    public boolean isInnerClass() {
        return this.ownerTypeSignature != null;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getClassName() {
        if (this.ownerTypeSignature == null) {
            return this.binaryName;
        }
        return this.ownerTypeSignature.getClassName() + '$' + this.binaryName;
    }

    public String getInnerClassName() {
        if (this.ownerTypeSignature == null) {
            return null;
        }
        return this.binaryName;
    }

    public ClassTypeSignature getOwnerTypeSignature() {
        return this.ownerTypeSignature;
    }

    public TypeArgSignature[] getTypeArgSignatures() {
        return this.typeArgSignatures;
    }

    public FullTypeSignature getTypeErasureSignature() {
        if (this.typeErasureSignature == null) {
            this.typeErasureSignature = new ClassTypeSignature(this.binaryName, new TypeArgSignature[]{}, this.ownerTypeSignature == null ? null : (ClassTypeSignature)this.ownerTypeSignature.getTypeErasureSignature());
        }
        return this.typeErasureSignature;
    }

    private ClassTypeSignature[] getClassTypeSignatures() {
        ArrayList<ClassTypeSignature> list = new ArrayList<ClassTypeSignature>();
        ClassTypeSignature classTypeSignature = this;
        while (classTypeSignature != null) {
            list.add(0, classTypeSignature);
            classTypeSignature = classTypeSignature.ownerTypeSignature;
        }
        return list.toArray(new ClassTypeSignature[list.size()]);
    }

    public String toString() {
        return this.getSignature();
    }

    public boolean isClassType() {
        return true;
    }
}

