/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.converters.collections.DefaultStringArrayFormatter;
import net.entropysoft.transmorph.converters.collections.IStringArrayFormatter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayToString
extends AbstractContainerConverter {
    private IStringArrayFormatter stringArrayFormatter = new DefaultStringArrayFormatter();

    public ArrayToString() {
        this.useObjectPool = false;
    }

    public IStringArrayFormatter getStringArrayFormatter() {
        return this.stringArrayFormatter;
    }

    public void setStringArrayFormatter(IStringArrayFormatter stringArrayFormatter) {
        this.stringArrayFormatter = stringArrayFormatter;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        Object array = sourceObject;
        int arrayLength = Array.getLength(array);
        String[] stringArray = new String[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            String elementConverted;
            Object element = Array.get(array, i);
            stringArray[i] = elementConverted = (String)this.elementConverter.convert(context, element, destinationType);
        }
        return this.stringArrayFormatter.format(stringArray);
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType((Type)((Object)String.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject.getClass().isArray();
    }
}

