/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters.collections;

import java.lang.reflect.Array;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractContainerConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayToSingleElement
extends AbstractContainerConverter {
    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return true;
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject.getClass().isArray() && Array.getLength(sourceObject) == 1;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            if (destinationType.isPrimitive()) {
                throw new ConverterException("Could not convert null to primitive type");
            }
            return null;
        }
        Object firstElement = Array.get(sourceObject, 0);
        Object elementConverted = this.elementConverter.convert(context, firstElement, destinationType);
        return elementConverted;
    }
}

