/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractSimpleConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToClass
extends AbstractSimpleConverter<String, Class> {
    private ClassLoader classLoader;

    public StringToClass(ClassLoader classLoader) {
        super(String.class, Class.class);
        this.classLoader = classLoader;
        this.useObjectPool = true;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class<?> doConvert(ConversionContext context, String sourceObject, TypeReference<?> destinationType) throws ConverterException {
        try {
            return this.classLoader.loadClass(sourceObject);
        }
        catch (ClassNotFoundException e) {
            throw new ConverterException(MessageFormat.format("Could not find class for ''{0}''", sourceObject), e);
        }
    }
}

