/*
 * Decompiled with CFR 0.152.
 */
package net.entropysoft.transmorph.converters;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.converters.AbstractConverter;
import net.entropysoft.transmorph.type.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToCalendar
extends AbstractConverter {
    private DateFormat dateFormat = new SimpleDateFormat();

    public StringToCalendar() {
        this.dateFormat.setLenient(false);
        this.useObjectPool = false;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public Object doConvert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        if (sourceObject == null) {
            return null;
        }
        String sourceString = (String)sourceObject;
        ParsePosition pos = new ParsePosition(0);
        Date date = this.dateFormat.parse(sourceString, pos);
        if (pos.getIndex() < sourceString.length()) {
            date = null;
        }
        if (date == null) {
            throw new ConverterException(MessageFormat.format("Could not convert ''{0}'' to a date", sourceString));
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    protected boolean canHandleDestinationType(TypeReference<?> destinationType) {
        return destinationType.isType((Type)((Object)Calendar.class)) || destinationType.isType((Type)((Object)GregorianCalendar.class));
    }

    @Override
    protected boolean canHandleSourceObject(Object sourceObject) {
        if (sourceObject == null) {
            return true;
        }
        return sourceObject instanceof String;
    }
}

