/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import net.entropysoft.transmorph.ConversionContext;
import net.entropysoft.transmorph.ConverterException;
import net.entropysoft.transmorph.IConverter;
import net.entropysoft.transmorph.type.TypeReference;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectToNumberConverter
implements IConverter {
    private static final Class<?>[] BYTE_TYPE = new Class[]{Byte.TYPE, Byte.class};
    private static final Class<?>[] DOUBLE_TYPE = new Class[]{Double.TYPE, Double.class};
    private static final Class<?>[] FLOAT_TYPE = new Class[]{Float.TYPE, Float.class};
    private static final Class<?>[] INT_TYPE = new Class[]{Integer.TYPE, Integer.class};
    private static final Class<?>[] LONG_TYPE = new Class[]{Long.TYPE, Long.class};
    private static final Class<?>[] SHORT_TYPE = new Class[]{Short.TYPE, Short.class};
    private final Logger logger = LoggerFactory.getLogger(ObjectToNumberConverter.class);

    @Override
    public Object convert(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) throws ConverterException {
        double value = Boolean.class.isAssignableFrom(sourceObject.getClass()) ? this.getDouble((Boolean)sourceObject) : this.getDouble(sourceObject.toString());
        Object result = this.getResult(sourceObject, destinationType, value);
        if (result != null) {
            return result;
        }
        throw new ConverterException("Could not convert");
    }

    private Object getResult(Object sourceObject, TypeReference<?> destinationType, double value) throws ConverterException {
        Number result = null;
        try {
            if (ArrayUtils.contains(BYTE_TYPE, destinationType.getRawType())) {
                result = (byte)value;
            } else if (ArrayUtils.contains(DOUBLE_TYPE, destinationType.getRawType())) {
                result = value;
            } else if (ArrayUtils.contains(FLOAT_TYPE, destinationType.getRawType())) {
                result = new Float(value);
            } else if (ArrayUtils.contains(INT_TYPE, destinationType.getRawType())) {
                result = (int)value;
            } else if (ArrayUtils.contains(LONG_TYPE, destinationType.getRawType())) {
                result = (long)value;
            } else if (ArrayUtils.contains(SHORT_TYPE, destinationType.getRawType())) {
                result = (short)value;
            } else if (destinationType.hasRawType(BigInteger.class)) {
                result = new BigInteger(Integer.toString((int)value));
            } else if (destinationType.hasRawType(BigDecimal.class)) {
                result = new BigDecimal(value);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error("error", e);
            throw new ConverterException(MessageFormat.format("Could not convert from ''{0}'' to object with type signature ''{1}''", sourceObject, destinationType.toString()), e);
        }
        return result;
    }

    private double getDouble(Boolean bool) {
        double value = bool != false ? 1.0 : 0.0;
        return value;
    }

    private double getDouble(String stringVal) {
        double value = stringVal.equalsIgnoreCase("true") ? 1.0 : (stringVal.equalsIgnoreCase("false") ? 0.0 : (stringVal.isEmpty() ? Double.NaN : Double.valueOf(stringVal)));
        return value;
    }

    @Override
    public boolean canHandle(ConversionContext context, Object sourceObject, TypeReference<?> destinationType) {
        return destinationType.isNumber() && (Number.class.isAssignableFrom(sourceObject.getClass()) || Boolean.class.isAssignableFrom(sourceObject.getClass()) || String.class.isAssignableFrom(sourceObject.getClass()));
    }
}

