/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.soleil.tango.clientapi.attribute.IExtractor;
import fr.soleil.tango.clientapi.util.TypeConversionUtil;
import java.lang.reflect.Array;
import org.tango.utils.ArrayUtils;

public final class Extractors {

    public static final class DevEncodedExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractDevEncodedArray();
        }
    }

    public static final class UShortExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractUShortArray();
        }
    }

    public static final class ULongExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractULongArray();
        }
    }

    public static final class ULong64Extractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractULong64Array();
        }
    }

    public static final class CharExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractCharArray();
        }
    }

    public static final class UCharExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractUCharArray();
        }
    }

    public static final class StringExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractStringArray();
        }
    }

    public static final class StateExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractDevStateArray();
        }
    }

    public static final class ShortExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractShortArray();
        }
    }

    public static final class LongExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractLongArray();
        }
    }

    public static final class Long64Extractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractLong64Array();
        }
    }

    public static final class FloatExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractFloatArray();
        }
    }

    public static final class DoubleExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractDoubleArray();
        }
    }

    public static final class BooleanExtractor
    extends AExtractor {
        @Override
        public Object extract(DeviceAttribute da) throws DevFailed {
            return da.extractBooleanArray();
        }
    }

    public static abstract class AExtractor
    implements IExtractor {
        @Override
        public abstract Object extract(DeviceAttribute var1) throws DevFailed;

        @Override
        public final Object extractRead(DeviceAttribute da, AttrDataFormat format) throws DevFailed {
            Object result;
            Object tmp = this.extractReadArray(da, format);
            if (format.equals(AttrDataFormat.IMAGE) && Array.getLength(tmp) > 0) {
                int dimX = da.getDimX();
                int dimY = da.getDimY();
                result = ArrayUtils.fromArrayTo2DArray(tmp, dimX, dimY);
            } else {
                result = tmp;
            }
            return result;
        }

        @Override
        public final Object extractWrite(DeviceAttribute da, AttrWriteType writeType, AttrDataFormat format) throws DevFailed {
            Object result;
            Object tmp = this.extractWriteArray(da, writeType, format);
            if (format.equals(AttrDataFormat.IMAGE) && Array.getLength(tmp) > 0) {
                int dimX = da.getWrittenDimX();
                int dimY = da.getWrittenDimY();
                result = ArrayUtils.fromArrayTo2DArray(tmp, dimX, dimY);
            } else {
                result = tmp;
            }
            return result;
        }

        @Override
        public final Object extractReadArray(DeviceAttribute da, AttrDataFormat format) throws DevFailed {
            Object result = format.equals(AttrDataFormat.SCALAR) ? Array.get(this.extract(da), 0) : TypeConversionUtil.extractReadOrWrite(TypeConversionUtil.Part.READ, da, this.extract(da));
            return result;
        }

        @Override
        public final Object extractWriteArray(DeviceAttribute da, AttrWriteType writeType, AttrDataFormat format) throws DevFailed {
            Object result = format.equals(AttrDataFormat.SCALAR) ? TypeConversionUtil.getWritePart(this.extract(da), writeType) : TypeConversionUtil.extractReadOrWrite(TypeConversionUtil.Part.WRITE, da, this.extract(da));
            return result;
        }
    }
}

