/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.clientapi.attribute;

import fr.soleil.tango.clientapi.attribute.Extractors;
import fr.soleil.tango.clientapi.attribute.IExtractor;
import fr.soleil.tango.clientapi.attribute.IInserter;
import fr.soleil.tango.clientapi.attribute.Inserters;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum AttributeValueType {
    BOOLEAN(1, new Inserters.BooleanInserter(), new Extractors.BooleanExtractor()),
    CHAR(21, new Inserters.ShortInserter(), new Extractors.ShortExtractor()),
    DOUBLE(5, new Inserters.DoubleInserter(), new Extractors.DoubleExtractor()),
    FLOAT(4, new Inserters.FloatInserter(), new Extractors.FloatExtractor()),
    INT(27, new Inserters.IntInserter(), new Extractors.LongExtractor()),
    LONG(3, new Inserters.IntInserter(), new Extractors.LongExtractor()),
    LONG64(23, new Inserters.LongInserter(), new Extractors.Long64Extractor()),
    SHORT(2, new Inserters.ShortInserter(), new Extractors.ShortExtractor()),
    STATE(19, new Inserters.StateInserter(), new Extractors.StateExtractor()),
    STRING(8, new Inserters.StringInserter(), new Extractors.StringExtractor()),
    UCHAR(22, new Inserters.UCharInserter(), new Extractors.UCharExtractor()),
    ULONG(7, new Inserters.ULongInserter(), new Extractors.ULongExtractor()),
    ULONG64(24, new Inserters.ULong64Inserter(), new Extractors.ULong64Extractor()),
    USHORT(6, new Inserters.UShortInserter(), new Extractors.UShortExtractor()),
    DEVENCODED(28, new Inserters.DevEncodedInserter(), new Extractors.DevEncodedExtractor()),
    DEVENUM(29, new Inserters.ShortInserter(), new Extractors.ShortExtractor());

    private static final Map<Integer, IExtractor> EXTRACTORS_MAP;
    private static final Map<Integer, IInserter> INSERTERS_MAP;
    private int dataType;
    private IExtractor extrator;
    private IInserter inserter;

    public static int getDataTypeFromExtractor(IExtractor extractor) {
        for (int o : EXTRACTORS_MAP.keySet()) {
            if (!EXTRACTORS_MAP.get(o).equals(extractor)) continue;
            return o;
        }
        throw new EnumConstantNotPresentException(AttributeValueType.class, "no inserter found");
    }

    public static int getDataTypeFromInserter(IInserter inserter) {
        for (int o : INSERTERS_MAP.keySet()) {
            if (!INSERTERS_MAP.get(o).equals(inserter)) continue;
            return o;
        }
        throw new EnumConstantNotPresentException(AttributeValueType.class, "no inserter found");
    }

    public static IExtractor getExtractorFromDataType(int dataType) {
        return EXTRACTORS_MAP.get(dataType);
    }

    public static IInserter getInserterFromDataType(int dataType) {
        return INSERTERS_MAP.get(dataType);
    }

    private AttributeValueType(int dataType, IInserter inserter, IExtractor extrator) {
        this.dataType = dataType;
        this.extrator = extrator;
        this.inserter = inserter;
    }

    public int getDataType() {
        return this.dataType;
    }

    public IExtractor getExtractor() {
        return this.extrator;
    }

    public IInserter getInserter() {
        return this.inserter;
    }

    static {
        EXTRACTORS_MAP = new HashMap<Integer, IExtractor>();
        INSERTERS_MAP = new HashMap<Integer, IInserter>();
        for (AttributeValueType s : EnumSet.allOf(AttributeValueType.class)) {
            EXTRACTORS_MAP.put(s.getDataType(), s.getExtractor());
        }
        for (AttributeValueType s : EnumSet.allOf(AttributeValueType.class)) {
            INSERTERS_MAP.put(s.getDataType(), s.getInserter());
        }
    }
}

