/*
 * Decompiled with CFR 0.152.
 */
package fr.soleil.tango.attributecomposer;

import fr.soleil.tango.attributecomposer.AttributeGroupReader;
import fr.soleil.tango.clientapi.TangoGroupAttribute;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AttributeGroupScheduler {
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> future;
    private AttributeGroupReader valueReader;
    private long readingPeriod;

    public void start(AttributeGroupReader valueReader, long readingPeriod) {
        this.valueReader = valueReader;
        this.readingPeriod = readingPeriod;
        this.executor = Executors.newScheduledThreadPool(1);
        this.future = this.executor.scheduleAtFixedRate(valueReader, 0L, readingPeriod, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void updateAttributeGroup(TangoGroupAttribute attributeGroup) {
        this.stop();
        AttributeGroupReader newValueReader = new AttributeGroupReader(this.valueReader.getAttributeGroupListener(), attributeGroup, this.valueReader.isReadWriteValue(), this.valueReader.isReadQuality(), this.valueReader.isReadAttributeInfo());
        this.start(newValueReader, this.readingPeriod);
    }
}

