/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.Device_2;
import fr.esrf.TangoApi.DbClass;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoDs.Command;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.InitCmd;
import fr.esrf.TangoDs.MultiClassAttribute;
import fr.esrf.TangoDs.StateCmd;
import fr.esrf.TangoDs.StatusCmd;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;

public abstract class DeviceClass
implements TangoConst {
    protected String name;
    protected String doc_url;
    protected Vector command_list;
    protected Vector device_list;
    protected DbClass db_class;
    protected MultiClassAttribute class_attr;
    private final Vector nodb_name_list = new Vector();

    protected DeviceClass(String s) throws DevFailed {
        this.name = s;
        if (Util._UseDb) {
            this.db_class = new DbClass(this.name);
        }
        this.command_list = new Vector();
        this.device_list = new Vector();
        this.get_class_system_resource();
        this.class_attr = new MultiClassAttribute();
        this.initClass();
    }

    public void initClass() {
        this.device_list.clear();
        this.command_list.clear();
        this.class_attr.get_attr_list().clear();
        this.command_list.addElement(new StatusCmd("Status", 0, 8, "Device status"));
        this.command_list.addElement(new StateCmd("State", 0, 19, "Device state"));
        this.command_list.addElement(new InitCmd("Init", 0, 0));
        Util.out4.println("DeviceClass  add cmd State/Status/Init " + this.get_name());
    }

    private void get_class_system_resource() {
        block6: {
            if (Util._UseDb) {
                try {
                    DbDatum res_value = this.db_class.get_property("doc_url");
                    if (res_value.is_empty()) {
                        Util.out4.println("doc_url property for class " + this.name + " is not defined in database");
                        this.doc_url = "http://www.esrf.fr/tango";
                        break block6;
                    }
                    this.doc_url = res_value.extractString();
                }
                catch (DevFailed ex) {
                    this.doc_url = "http://www.esrf.fr/tango";
                }
                catch (BAD_OPERATION ex) {
                    this.doc_url = "http://www.esrf.fr/tango";
                }
            } else {
                this.doc_url = "http://www.esrf.fr/tango";
            }
        }
    }

    protected void export_device(DeviceImpl dev) throws DevFailed {
        Util.out4.println("DeviceClass::export_device() arrived");
        Util tg = Util.instance();
        ORB orb = tg.get_orb();
        Device_2 d = dev._this(orb);
        byte[] oid = null;
        POA r_poa = tg.get_poa();
        try {
            oid = r_poa.reference_to_id(d);
        }
        catch (Exception ex) {
            StringBuffer o = new StringBuffer("Can't get CORBA reference ID for device ");
            o.append(dev.get_name());
            Except.throw_exception("API_CantGetDevObjectID", o.toString(), "DeviceClass.export_device()");
        }
        dev.set_obj_id(oid);
        if (!Util._UseDb) {
            return;
        }
        DbDevExportInfo exp_info = new DbDevExportInfo(dev.get_name(), orb.object_to_string(d), tg.get_host_name(), tg.get_version_str());
        tg.get_database().export_device(exp_info);
        Util.out4.println("Leaving DeviceClass::export_device method()");
        dev.set_exported_flag(true);
    }

    protected void export_device(DeviceImpl dev, String name) throws DevFailed {
        Util.out4.println("DeviceClass::export_device() arrived");
        Util.out4.println("name = " + name);
        byte[] oid = name.getBytes();
        Util tg = Util.instance();
        try {
            POA r_poa = tg.get_poa();
            r_poa.activate_object_with_id(oid, dev);
        }
        catch (Exception ex) {
            StringBuffer o = new StringBuffer("Can't activate device for device ");
            o.append(dev.get_name());
            Except.throw_exception("API_CantBindDevice", o.toString(), "DeviceClass.export_device()");
        }
        ORB orb = tg.get_orb();
        dev._this(orb);
        dev.set_obj_id(oid);
        tg.registerDeviceForJacorb(name);
        dev.set_exported_flag(true);
        Util.out4.println("Leaving DeviceClass::export_device method()");
    }

    public Any command_handler(DeviceImpl device, String command, Any in_any) throws DevFailed {
        int i;
        Any ret = Util.instance().get_orb().create_any();
        Util.out4.println("Entering DeviceClass::command_handler() method");
        String cmd_name = command.toLowerCase();
        for (i = 0; i < this.command_list.size(); ++i) {
            Command cmd = (Command)this.command_list.elementAt(i);
            if (!cmd.get_name().toLowerCase().equals(cmd_name)) continue;
            device.always_executed_hook();
            if (!cmd.is_allowed(device, in_any)) {
                StringBuffer o = new StringBuffer("Command ");
                o.append(command);
                o.append(" not allowed when the device is in ");
                o.append(Tango_DevStateName[device.get_state().value()]);
                o.append(" state");
                Except.throw_exception("API_CommandNotAllowed", o.toString(), "DeviceClass.command_handler");
            }
            ret = cmd.execute(device, in_any);
            break;
        }
        if (i == this.command_list.size()) {
            Util.out3.println("DeviceClass.command_handler(): command " + command + " not found");
            Except.throw_exception("API_CommandNotFound", "Command " + command + " not found", "DeviceClass.command_handler");
        }
        Util.out4.println("Leaving DeviceClass.command_handler() method");
        return ret;
    }

    public abstract void command_factory();

    public void attribute_factory(Vector v) throws DevFailed {
    }

    public void device_name_factory(Vector list) {
    }

    public abstract void device_factory(String[] var1) throws DevFailed;

    public Vector get_command_list() {
        return this.command_list;
    }

    public Vector get_device_list() {
        return this.device_list;
    }

    public DeviceImpl get_device_at(int idx) {
        return (DeviceImpl)this.device_list.elementAt(idx);
    }

    public String get_name() {
        return this.name;
    }

    public String get_doc_url() {
        return this.doc_url;
    }

    public MultiClassAttribute get_class_attr() {
        return this.class_attr;
    }

    public DbClass get_db_class() {
        return this.db_class;
    }

    public Vector get_nodb_name_list() {
        return this.nodb_name_list;
    }
}

