/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import fr.esrf.Tango.DevFailed;
import java.io.File;
import java.util.Vector;
import pogo.class2www.Family;
import pogo.class2www.FamilyList;
import pogo.class2www.Module;
import pogo.class2www.Utils;
import pogo.gene.PogoClass;
import pogo.gene.PogoGeneDoc;
import pogo.gene.PogoUtil;

public class Repository {
    protected String cvsroot;
    protected String svnroot;
    protected FamilyList families;
    protected String str_module;
    protected String name;
    protected boolean remote = true;
    protected String url;
    protected String home;
    protected boolean check_svn;
    protected String default_family;
    private String svn_serv = "Servers";
    public static final int CVS = 0;
    public static final int SVN = 1;
    public static final String[] RepositoryTypeStr = new String[]{"CVS", "SVN"};
    public Vector<String> cvs_modules = new Vector();
    public Vector<String> svn_modules = new Vector();

    public String toString() {
        StringBuffer sb = new StringBuffer(this.name);
        sb.append('\n');
        for (Object o : this.families) {
            Family family = (Family)o;
            sb.append(family.size()).append(" - ").append(family);
        }
        return sb.toString();
    }

    public Repository(String cvsroot) throws DevFailed {
        this.cvsroot = cvsroot;
        this.svnroot = cvsroot.substring(0, cvsroot.lastIndexOf(47)) + "/svnroot";
        this.str_module = Utils.getInstance().getModuleFile(cvsroot);
    }

    public void buildServerDoc() throws DevFailed {
        File r_dir = new File(this.name);
        if (!r_dir.exists()) {
            r_dir.mkdir();
        }
        this.checkOutCvsModules();
        System.out.println(this.name + " check svn=" + this.check_svn);
        if (this.check_svn) {
            this.checkOutSvnServers();
            this.buildFamilyAndModulesFromSvn();
        }
        this.buildModulesDoc();
    }

    protected void checkOutCvsModules() {
        Vector tags = new Vector();
        try {
            tags = PogoUtil.getLastCvsTags(this.cvsroot);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        for (Object o : this.families) {
            Family family = (Family)o;
            File f_dir = new File(this.name + "/" + family.name);
            if (!f_dir.exists()) {
                f_dir.mkdir();
            }
            for (Object obj : family) {
                Module module = (Module)obj;
                String tag = PogoUtil.getLastCvsTag(tags, module.name);
                Utils.getInstance().checkOutModule(module.name, this.cvsroot, tag);
                if (tag != null) {
                    module.tag = tag;
                }
                File m_dir = new File(module.name);
                String path = this.name + "/" + family.name + "/" + module.name;
                module.setHtmlPath(path);
                m_dir.renameTo(new File(path));
            }
        }
    }

    protected void buildModulesDoc() throws DevFailed {
        for (Object o : this.families) {
            Family family = (Family)o;
            for (Object obj : family) {
                Module module = (Module)obj;
                if (module.doc_done) continue;
                String path = this.name + "/" + family.name + "/" + module.name;
                Vector<String> servnames = PogoUtil.getInstance().checkForTangoDir(path);
                if (servnames.size() > 0) {
                    String servname = servnames.get(0);
                    String dirname = servname.substring(0, servname.lastIndexOf(47));
                    int pos = dirname.lastIndexOf(47);
                    if (pos > 0) {
                        String doc_html = dirname + "/../doc_html";
                        File f = new File(doc_html);
                        if (f.exists()) {
                            f.renameTo(new File(dirname + "/doc_html"));
                        } else {
                            doc_html = dirname + "/../doc/doc_html";
                            f = new File(doc_html);
                            if (f.exists()) {
                                f.renameTo(new File(dirname + "/doc_html"));
                            }
                        }
                    }
                    try {
                        module.server = new PogoClass(servname);
                        PogoGeneDoc gene = new PogoGeneDoc(module.server);
                        gene.generate();
                        gene.addCvsFamily(family.name);
                        this.removeCvsSvnDir(dirname);
                        this.moveDocDir(module);
                    }
                    catch (Exception e) {
                        System.err.println(servname + ":  " + e);
                    }
                } else {
                    System.err.println("No server found for " + path);
                }
                module.doc_done = true;
            }
        }
    }

    private void removeCvsSvnDir(String dirname) {
        try {
            String cmd = null;
            File sub_cvs = new File(dirname + "/CVS");
            if (sub_cvs.exists()) {
                cmd = "rm -Rf " + sub_cvs;
            } else {
                File sub_svn = new File(dirname + "/.svn");
                if (sub_svn.exists()) {
                    cmd = "rm -Rf " + sub_svn;
                }
            }
            if (cmd != null) {
                PogoUtil.executeShellCmd(cmd);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected void checkOutSvnServers() {
        String cmd = "svn co file://" + this.svnroot + "/" + this.svn_serv;
        try {
            System.out.println(cmd + "\n");
            System.out.println(PogoUtil.executeShellCmd(cmd));
        }
        catch (Exception e) {
            System.err.println(e);
        }
        new File(this.svn_serv).renameTo(new File(this.name + "/" + this.svn_serv));
    }

    public void buildFamilyAndModulesFromSvn() {
        String dirname = this.name + "/" + this.svn_serv;
        Vector<String> tango_class = PogoUtil.getInstance().checkForTangoDir(dirname);
        for (String full : tango_class) {
            System.out.println(full);
            int start = full.lastIndexOf(47) + 1;
            int end = full.lastIndexOf(46);
            String module_name = full.substring(start, end);
            start = full.indexOf(dirname);
            end = full.indexOf(47, start += dirname.length() + 1);
            String family_name = full.substring(start, end);
            start = full.indexOf(this.svn_serv);
            end = full.lastIndexOf(47);
            String svn_path = full.substring(start, end);
            Family family = this.families.getFamily(family_name);
            if (family == null) {
                family = new Family(family_name);
                this.families.add(family);
            }
            Module module = new Module(module_name, svn_path, this, family, 1);
            family.add(module);
            String path = this.name + "/" + family.name + "/" + module.name;
            module.setHtmlPath(path);
            this.svn_modules.add(module_name);
        }
        for (String o : this.families) {
            Family family = (Family)((Object)o);
            for (Object o2 : family) {
                Module module = (Module)o2;
                if (module.repos_type != 1) continue;
                File src = new File(this.name + "/" + module.cvs_path);
                File fam = new File(this.name + "/" + family.name);
                if (!fam.exists()) {
                    fam.mkdir();
                }
                File dest = new File(fam.toString() + "/" + module.name);
                System.out.println("\tmoving " + src + "  to  " + dest);
                src.renameTo(dest);
            }
        }
    }

    protected void moveDocDir(Module module) {
        String path = this.name + "/" + module.family.name;
        File tmp = new File(path + "/tmp");
        File doc = new File(module.server.projectFiles.getDocHtml());
        System.out.print("Moving " + doc + " to " + tmp);
        boolean done = doc.renameTo(tmp);
        System.out.println(done ? "   done" : "   NOT done");
        String module_path = path + "/" + module.name;
        String cmd = "rm -R " + module_path;
        try {
            System.out.println(cmd);
            String ret = PogoUtil.executeShellCmd(cmd);
            System.out.println(ret);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        System.out.print("Rename " + tmp + "  to  " + module_path);
        tmp.renameTo(new File(module_path));
        System.out.println(done ? "   done" : "   NOT done");
    }

    protected void sort() {
        for (Object o : this.families) {
            ((Family)o).sort();
        }
        Utils.getInstance().sort(this.families);
        Family family = this.families.getFamily("Miscellaneous");
        if (family != null) {
            this.families.remove(family);
            this.families.add(family);
        }
    }

    public String getSummary() {
        return this.families.getSummary();
    }

    public int nbClasses() {
        int nb = 0;
        for (Object o : this.families) {
            nb += ((Family)o).nbClasses();
        }
        return nb;
    }

    public Vector getClassList() {
        Vector<Module> v = new Vector<Module>();
        for (Object o : this.families) {
            Family family = (Family)o;
            for (Object o2 : family) {
                Module module = (Module)o2;
                if (module.server == null) continue;
                v.add(module);
            }
        }
        return v;
    }

    public int nbFamilies() {
        return this.families.size();
    }
}

