/*
 * Decompiled with CFR 0.152.
 */
package pogo.class2www;

import java.util.Vector;
import pogo.gene.PogoUtil;

public class InstituteList
extends Vector {
    public InstituteList(String backup_home) {
        try {
            String filename = backup_home + "/log/authors.add";
            String[] code = PogoUtil.string2array(PogoUtil.readFile(filename), "\n");
            this.parseInstitutes(code);
            this.parseAuthors(code);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public Institute getInstituteByAuthor(String name) {
        for (Object o : this) {
            Institute in = (Institute)o;
            for (Object o2 : in) {
                String author = (String)o2;
                if (!author.equals(name)) continue;
                return in;
            }
        }
        return null;
    }

    public Institute getInstituteByName(String name) {
        for (Object o : this) {
            Institute in = (Institute)o;
            if (!in.name.equals(name)) continue;
            return in;
        }
        return null;
    }

    private void parseAuthors(String[] code) {
        for (Object o : this) {
            Institute in = (Institute)o;
            String in_name = in.name + ":";
            boolean found = false;
            for (String line : code) {
                if (line.startsWith(in_name)) {
                    found = true;
                    continue;
                }
                if (line.indexOf(58) > 0) {
                    found = false;
                    continue;
                }
                if (!found || line.trim().length() <= 0) continue;
                in.add(line.trim());
            }
        }
    }

    private void parseInstitutes(String[] code) {
        for (String line : code) {
            int pos = line.indexOf(58);
            if (pos <= 0) continue;
            String name = line.substring(0, pos);
            String add = line.substring(pos + 1).trim();
            this.add(new Institute(name, add));
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Object o : this) {
            sb.append(((Institute)o).toFullString()).append('\n');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] authors;
        String backup_home = System.getProperty("_BACKUP_HOME_");
        if (backup_home == null) {
            System.out.println("_BACKUP_HOME_ has not been set");
            return;
        }
        InstituteList il = new InstituteList(backup_home);
        for (String author : authors = new String[]{"verdier", "meyer", "jensmeyer", "joe", "pascal_verdier"}) {
            Institute in = il.getInstituteByAuthor(author);
            System.out.println(author + ":\t" + in);
        }
    }

    public class Institute
    extends Vector {
        public String name;
        public String address = null;

        public Institute(String name, String address) {
            this.name = name;
            if (address.length() > 0) {
                this.address = address;
            }
        }

        public String toFullString() {
            StringBuffer sb = new StringBuffer(this.name);
            sb.append(':');
            if (this.address != null) {
                sb.append('\t').append(this.address);
            }
            sb.append('\n');
            for (Object o : this) {
                sb.append(o).append('\n');
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            String str = this.name;
            if (this.address != null) {
                return ": " + this.address;
            }
            return str;
        }
    }
}

