/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class UpdateRelease {
    private String release = null;
    private String fileName = null;
    private String notesPath = ".";
    private String packName = null;
    private String title = null;

    public UpdateRelease(String[] args) throws PogoException {
        this.checkArguments(args);
        if (this.release != null && this.fileName != null) {
            this.patchReleaseNumber();
        }
        if (this.notesPath != null && this.packName != null) {
            this.generateReleaseNotes();
        }
    }

    private void generateReleaseNotes() throws PogoException {
        String notesFile = "ReleaseNote";
        if (!new File(notesFile).exists() && !new File(notesFile = String.valueOf(notesFile) + "s").exists()) {
            throw new PogoException(String.valueOf(notesFile) + " not found");
        }
        String outCode = "\npackage " + this.packName + ";\n\n";
        outCode = String.valueOf(outCode) + this.getComments();
        outCode = String.valueOf(outCode) + "public interface " + notesFile + " {\n";
        outCode = String.valueOf(outCode) + "\tString str = \n";
        outCode = String.valueOf(outCode) + this.getHtmlHeader();
        outCode = String.valueOf(outCode) + this.getHtmlNotes(notesFile);
        outCode = String.valueOf(outCode) + this.getHtmlFooter();
        outCode = String.valueOf(outCode) + "}";
        String fileName = String.valueOf(this.notesPath) + '/' + notesFile + ".java";
        ParserTool.writeFile(fileName, outCode);
        System.out.println(String.valueOf(fileName) + "  has been generated.");
    }

    private String getHtmlNotes(String notesFile) throws PogoException {
        List<String> inCode = ParserTool.readFileLines(notesFile, false);
        StringBuilder sb = new StringBuilder();
        for (String line : inCode) {
            if ((line = this.checkLine(line)).endsWith(":")) {
                sb.append("\t\t\"<li><b>").append(line).append("</b><br>\" + \n");
                continue;
            }
            sb.append("\t\t\"&nbsp; &nbsp; &nbsp; ").append(line).append("<br>\" + \n");
        }
        return sb.toString();
    }

    private String checkLine(String line) {
        int end;
        String str = "";
        int start = 0;
        while ((end = line.indexOf("\"", start)) > 0) {
            str = String.valueOf(str) + line.substring(start, end) + "&rdquo;";
            start = end + 1;
        }
        str = String.valueOf(str) + line.substring(start);
        return str;
    }

    private String getHtmlHeader() {
        StringBuilder sb = new StringBuilder("\t\t\"<!DOCTYPE HTML PUBLIC \\\"-//W3C//DTD HTML 3.2//EN\\\">\\n\" + \n\t\t\"<html>\\n\" + \n\t\t\"<head>\\n\" + \n\t\t\"<title> Release Note </title>\\n\" + \n\t\t\"</head>\\n\" + \n\t\t\"<body text=\\\"#000000\\\" bgColor=\\\"#FFFFFF\\\" link=\\\"#0000FF\\\" vLink=\\\"#7F00FF\\\" aLink=\\\"#FF0000\\\">\\n\" + \n\t\t\"<p><!-------TITLE------></p>\\n\" + \n");
        if (this.title != null) {
            sb.append("\t\t\"<center>\t<h2>").append(this.title).append("</h2>\\n\" + \n");
            sb.append("\t\t\"\t(Generated ").append(UpdateRelease.getDate()).append(")</center><br>\\n\" + \n");
        }
        return sb.toString();
    }

    private String getHtmlFooter() {
        return "\t\t\"</body>\\n\" + \n\t\t\"</html>\\n\"\n\t;\n";
    }

    private String getComments() {
        return "/**\n * HTML code to display Release Notes for this package.\n * It is generated by Pogo classes from a text file.\n */\n\n";
    }

    private void patchReleaseNumber() throws PogoException {
        String code = ParserTool.readFile(this.fileName);
        int start = code.indexOf("revNumber =");
        if (start < 0 && (start = code.indexOf("releaseString =")) < 0) {
            throw new PogoException("String releaseString Not Found");
        }
        start = code.indexOf(34, start);
        int end = code.indexOf(34, ++start);
        String target = String.valueOf(this.release) + "  -  " + UpdateRelease.getDate();
        System.out.println("Replacing " + code.substring(start, end));
        System.out.println("    By    " + target);
        ParserTool.writeFile(this.fileName, String.valueOf(code.substring(0, start)) + target + code.substring(end));
    }

    private static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy  HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public void checkArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            switch (args[i]) {
                case "-release": {
                    if (i + 1 < args.length) {
                        this.release = args[i + 1];
                        break;
                    }
                    UpdateRelease.displaySyntax();
                    break;
                }
                case "-file": {
                    if (i + 1 < args.length) {
                        this.fileName = args[i + 1];
                        break;
                    }
                    UpdateRelease.displaySyntax();
                    break;
                }
                case "-note_path": {
                    if (i + 1 < args.length) {
                        this.notesPath = args[i + 1];
                        break;
                    }
                    UpdateRelease.displaySyntax();
                    break;
                }
                case "-package": {
                    if (i + 1 < args.length) {
                        this.packName = args[i + 1];
                        break;
                    }
                    UpdateRelease.displaySyntax();
                    break;
                }
                case "-title": {
                    if (i + 1 < args.length) {
                        this.title = "";
                        while (++i < args.length && args[i].charAt(0) != '-') {
                            this.title = String.valueOf(this.title) + args[i] + " ";
                        }
                        i -= 2;
                        break;
                    }
                    UpdateRelease.displaySyntax();
                    break;
                }
                default: {
                    UpdateRelease.displaySyntax();
                }
            }
            i += 2;
        }
        if (this.release == null && this.fileName != null || this.release != null && this.fileName == null) {
            UpdateRelease.displaySyntax();
        }
    }

    public static void displaySyntax() {
        System.out.println("UpdateRelease:");
        System.out.println("  -release <version>:      release to be patched");
        System.out.println("  -file <file name>:       file to patch release and date");
        System.out.println("  -note_path <path>:       where ReleaseNotes.java must be generated");
        System.out.println("  -package <package name>: package for ReleaseNotes.java class");
        System.out.println("  -title <title>:          title added in ReleaseNotes.java");
        System.out.println();
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            UpdateRelease.displaySyntax();
        }
        try {
            new UpdateRelease(args);
        }
        catch (PogoException e) {
            System.err.println(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

