/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.Pipe;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.tools.StateMachineTable;

public class StateMachineDialog
extends JDialog
implements PogoConst {
    private PogoDeviceClass pogoClass;
    private StateMachineTable commandTable;
    private StateMachineTable attributeTable;
    private StateMachineTable pipeTable;
    private int retVal = 0;
    private static final int MAX_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height;
    private JLabel attributeLabel;
    private JScrollPane attributeScrollPane;
    private JLabel commandLabel;
    private JScrollPane commandScrollPane;
    private JLabel pipeLabel;
    private JScrollPane pipeScrollPane;
    private JLabel titleLabel;

    public StateMachineDialog(JFrame jFrame, PogoDeviceClass pogoDeviceClass) {
        super((Frame)jFrame, true);
        this.pogoClass = pogoDeviceClass;
        this.initComponents();
        this.createOwnComponents();
        this.titleLabel.setText(pogoDeviceClass.getName() + " State Machine");
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void createOwnComponents() {
        Dimension[] dimensionArray = new Dimension[3];
        EList<Command> eList = this.pogoClass.getCommands();
        EList<Command> eList2 = this.pogoClass.getDynamicCommands();
        if (eList.size() > 2 || !eList2.isEmpty()) {
            this.commandTable = new StateMachineTable(this.pogoClass, 0);
            this.commandScrollPane.add(this.commandTable);
            this.commandScrollPane.setViewportView(this.commandTable);
            dimensionArray[0] = this.commandTable.getDimension(this);
            this.commandScrollPane.setPreferredSize(dimensionArray[0]);
        } else {
            this.commandLabel.setVisible(false);
        }
        EList<Attribute> eList3 = this.pogoClass.getAttributes();
        EList<Attribute> eList4 = this.pogoClass.getDynamicAttributes();
        if (!eList3.isEmpty() || !eList4.isEmpty()) {
            this.attributeTable = new StateMachineTable(this.pogoClass, 1);
            this.attributeScrollPane.add(this.attributeTable);
            this.attributeScrollPane.setViewportView(this.attributeTable);
            dimensionArray[1] = this.attributeTable.getDimension(this);
            this.attributeScrollPane.setPreferredSize(dimensionArray[1]);
        } else {
            this.attributeLabel.setVisible(false);
        }
        EList<Pipe> eList5 = this.pogoClass.getPipes();
        if (!eList5.isEmpty()) {
            this.pipeTable = new StateMachineTable(this.pogoClass, 2);
            this.pipeScrollPane.add(this.pipeTable);
            this.pipeScrollPane.setViewportView(this.pipeTable);
            dimensionArray[2] = this.pipeTable.getDimension(this);
            this.pipeScrollPane.setPreferredSize(dimensionArray[2]);
        } else {
            this.pipeLabel.setVisible(false);
        }
        this.checkSize(dimensionArray, new JScrollPane[]{this.commandScrollPane, this.attributeScrollPane, this.pipeScrollPane});
    }

    private void checkSize(Dimension[] dimensionArray, JScrollPane[] jScrollPaneArray) {
        this.pack();
        int n = this.getHeight();
        if (n > MAX_HEIGHT) {
            double d = (double)MAX_HEIGHT / (double)n * 0.8;
            for (int i = 0; i <= 2; ++i) {
                if (dimensionArray[i] == null || jScrollPaneArray[i] == null || dimensionArray[i].height <= (int)(d * 500.0)) continue;
                dimensionArray[i].height = (int)(d * 500.0);
                jScrollPaneArray[i].setPreferredSize(dimensionArray[i]);
            }
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel2 = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.commandLabel = new JLabel();
        this.commandScrollPane = new JScrollPane();
        this.attributeLabel = new JLabel();
        this.attributeScrollPane = new JScrollPane();
        this.pipeLabel = new JLabel();
        this.pipeScrollPane = new JScrollPane();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StateMachineDialog.this.closeDialog(windowEvent);
            }
        });
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateMachineDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StateMachineDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("State Machine");
        jPanel2.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel2, "North");
        jPanel3.setLayout(new GridBagLayout());
        this.commandLabel.setFont(new Font("Dialog", 1, 18));
        this.commandLabel.setText("Select Allowed Commands");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel3.add((Component)this.commandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 10, 10, 10);
        jPanel3.add((Component)this.commandScrollPane, gridBagConstraints);
        this.attributeLabel.setFont(new Font("Dialog", 1, 18));
        this.attributeLabel.setText("Select Allowed Attributes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel3.add((Component)this.attributeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 10, 10, 10);
        jPanel3.add((Component)this.attributeScrollPane, gridBagConstraints);
        this.pipeLabel.setFont(new Font("Dialog", 1, 18));
        this.pipeLabel.setText("Select Allowed Pipes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel3.add((Component)this.pipeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 10, 10, 10);
        jPanel3.add((Component)this.pipeScrollPane, gridBagConstraints);
        this.getContentPane().add((Component)jPanel3, "Center");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public PogoDeviceClass getPogoClass() {
        if (this.commandTable != null) {
            this.commandTable.updateExcluded();
        }
        if (this.attributeTable != null) {
            this.attributeTable.updateExcluded();
        }
        if (this.pipeTable != null) {
            this.pipeTable.updateExcluded();
        }
        return this.pogoClass;
    }
}

