/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.AdditionalFilesDialog;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.MultiClassesPanel;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class GenerateDialog
extends JDialog {
    private int mode = 0;
    private static int returnStatus;
    private DeviceClass deviceClass;
    private List<JRadioButton> radioButtons = new ArrayList<JRadioButton>();
    private boolean cmakeAvailable = false;
    private JRadioButton cMakeListsBtn;
    private JRadioButton codeBtn;
    private JLabel docLabel;
    private JRadioButton htmlBtn;
    private JLabel javaProjectLabel;
    private JLabel linuxLabel;
    private JRadioButton makefileBtn;
    private JTextField outPathText;
    private JRadioButton prPythonHLBtn;
    private JRadioButton projectBtn;
    private JRadioButton pyHlProjectBtn;
    private JRadioButton sphinxBtn;
    private JRadioButton vc10Btn;
    private JRadioButton vc12Btn;
    private JLabel warningLabel;
    private JPanel warningPanel;
    private JLabel windowsLabel;
    private JRadioButton xmiBtn;

    public GenerateDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        String string;
        this.initComponents();
        this.radioButtons.add(this.xmiBtn);
        this.radioButtons.add(this.codeBtn);
        this.radioButtons.add(this.makefileBtn);
        this.radioButtons.add(this.cMakeListsBtn);
        this.radioButtons.add(this.vc10Btn);
        this.radioButtons.add(this.vc12Btn);
        this.radioButtons.add(this.pyHlProjectBtn);
        this.radioButtons.add(this.prPythonHLBtn);
        this.radioButtons.add(this.projectBtn);
        this.radioButtons.add(this.sphinxBtn);
        this.radioButtons.add(this.htmlBtn);
        String string2 = PogoProperty.makefileHome;
        String string3 = "/cmake_tango.opt";
        String string4 = System.getProperty("DEBUG_MAKE");
        if (string4 != null) {
            string2 = string4;
        } else {
            string = "$(TANGO_HOME)";
            if (string3.startsWith(string)) {
                String string5 = System.getenv("TANGO_HOME");
                if (string5 == null) {
                    string5 = System.getProperty("TANGO_HOME");
                }
                if (string5 != null) {
                    string2 = string5;
                }
            }
        }
        this.cmakeAvailable = new File(string2 + '/' + string3).exists();
        string = System.getenv("DEBUG_MAKE");
        if (Utils.isTrue(string)) {
            this.codeBtn.setSelected(false);
            this.makefileBtn.setSelected(true);
        }
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        this.outPathText = new JTextField();
        JButton jButton3 = new JButton();
        JPanel jPanel3 = new JPanel();
        this.xmiBtn = new JRadioButton();
        this.codeBtn = new JRadioButton();
        this.prPythonHLBtn = new JRadioButton();
        this.makefileBtn = new JRadioButton();
        this.cMakeListsBtn = new JRadioButton();
        JLabel jLabel2 = new JLabel();
        this.htmlBtn = new JRadioButton();
        this.warningPanel = new JPanel();
        this.warningLabel = new JLabel();
        JLabel jLabel3 = new JLabel();
        JButton jButton4 = new JButton();
        this.vc10Btn = new JRadioButton();
        this.vc12Btn = new JRadioButton();
        this.windowsLabel = new JLabel();
        this.linuxLabel = new JLabel();
        this.docLabel = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.javaProjectLabel = new JLabel();
        this.projectBtn = new JRadioButton();
        this.pyHlProjectBtn = new JRadioButton();
        this.sphinxBtn = new JRadioButton();
        this.setTitle("Generation Preference  Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GenerateDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new FlowLayout(2));
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new GridBagLayout());
        jLabel.setFont(new Font("Arial", 1, 12));
        jLabel.setText("Output Path :    ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.outPathText.setMinimumSize(new Dimension(450, 25));
        this.outPathText.setPreferredSize(new Dimension(450, 25));
        this.outPathText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        this.outPathText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                GenerateDialog.this.outPathTextKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        jPanel2.add((Component)this.outPathText, gridBagConstraints);
        jButton3.setText("Browse");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDialog.this.browsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 40, 0);
        jPanel2.add((Component)jButton3, gridBagConstraints);
        this.getContentPane().add((Component)jPanel2, "North");
        jPanel3.setLayout(new GridBagLayout());
        this.xmiBtn.setSelected(true);
        this.xmiBtn.setText("XMI   file");
        this.xmiBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDialog.this.xmiBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.xmiBtn, gridBagConstraints);
        this.codeBtn.setSelected(true);
        this.codeBtn.setText("Code files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.codeBtn, gridBagConstraints);
        this.prPythonHLBtn.setSelected(true);
        this.prPythonHLBtn.setText("Protected Regions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.prPythonHLBtn, gridBagConstraints);
        this.makefileBtn.setText("Makefile");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.makefileBtn, gridBagConstraints);
        this.cMakeListsBtn.setText("CMakeLists");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.cMakeListsBtn, gridBagConstraints);
        jLabel2.setFont(new Font("Tahoma", 1, 14));
        jLabel2.setText("Files to be generated :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        this.htmlBtn.setText("html Pages");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.htmlBtn, gridBagConstraints);
        this.warningPanel.setBackground(new Color(255, 229, 126));
        this.warningLabel.setFont(new Font("Tahoma", 1, 14));
        this.warningLabel.setText("  class  is  abstract !!!");
        this.warningPanel.add(this.warningLabel);
        jLabel3.setText("             ");
        this.warningPanel.add(jLabel3);
        jButton4.setText("Details");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDialog.this.detailsBtnActionPerformed(actionEvent);
            }
        });
        this.warningPanel.add(jButton4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel3.add((Component)this.warningPanel, gridBagConstraints);
        this.vc10Btn.setText("VC10 Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.vc10Btn, gridBagConstraints);
        this.vc12Btn.setText("VC12 Project");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.vc12Btn, gridBagConstraints);
        this.windowsLabel.setFont(new Font("Tahoma", 1, 12));
        this.windowsLabel.setText("Windows:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)this.windowsLabel, gridBagConstraints);
        this.linuxLabel.setFont(new Font("Tahoma", 1, 12));
        this.linuxLabel.setText("Linux:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)this.linuxLabel, gridBagConstraints);
        this.docLabel.setFont(new Font("Tahoma", 1, 12));
        this.docLabel.setText("Documentation:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)this.docLabel, gridBagConstraints);
        jLabel4.setFont(new Font("Tahoma", 1, 12));
        jLabel4.setText("Device Class:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)jLabel4, gridBagConstraints);
        this.javaProjectLabel.setFont(new Font("Tahoma", 1, 12));
        this.javaProjectLabel.setText("Projects:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        jPanel3.add((Component)this.javaProjectLabel, gridBagConstraints);
        this.projectBtn.setText("Eclipse/Pom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.projectBtn, gridBagConstraints);
        this.pyHlProjectBtn.setText("Python Package");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.pyHlProjectBtn, gridBagConstraints);
        this.sphinxBtn.setText("Sphinx");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel3.add((Component)this.sphinxBtn, gridBagConstraints);
        this.getContentPane().add((Component)jPanel3, "Center");
    }

    private void browsActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(this.outPathText.getText());
        jFileChooser.addChoosableFileFilter(new PogoFileFilter("", "Directory"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this, "Target Dir.");
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null && file.isDirectory()) {
            this.outPathText.setText(file.getAbsolutePath());
        }
        this.outPathText.requestFocus();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        String string = this.outPathText.getText();
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                int n;
                if (this.makefileBtn.isSelected() || this.cMakeListsBtn.isSelected() || this.vc12Btn.isSelected() || this.vc10Btn.isSelected()) {
                    n = this.manageMakefile();
                    if (n == 0 && this.vc10Btn.isSelected()) {
                        n = this.manageWindowsPathCase();
                    }
                    this.doClose(n);
                }
                if ((n = Utils.getLanguage(this.deviceClass.getPogoDeviceClass().getDescription().getLanguage())) == 0 && this.projectBtn.isSelected()) {
                    if (this.checkMavenPathCase(file.getAbsolutePath())) {
                        this.doClose(0);
                    } else {
                        return;
                    }
                }
                this.doClose(0);
            } else {
                JOptionPane.showMessageDialog(this, string + " is not a directory !", "Error Window", 0);
            }
        } else if (JOptionPane.showConfirmDialog(this, string + " Does not exists !\n\n" + "   Would you like to create it ? ", "Error Window", 0) == 0) {
            try {
                if (file.mkdir()) {
                    System.out.println(string + " created");
                    this.doClose(0);
                } else {
                    JOptionPane.showMessageDialog(this, "Cannot create: " + string, "Error Window", 0);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Cannot create: " + string + "\n" + exception, "Error Window", 0);
            }
        }
    }

    private boolean checkMavenPathCase(String string) {
        if (string.endsWith("src/main/java")) {
            return true;
        }
        if (string.endsWith("src\\main\\java")) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "pom.xml file needs maven structure\nThe source files must be generated in path like --/--/src/main/java/\npom.xml will be generated on top of /src/ directory.", "Error", 0);
        return false;
    }

    private int manageWindowsPathCase() {
        if (Utils.osIsUnix()) {
            EList<Inheritance> eList = this.deviceClass.getPogoDeviceClass().getDescription().getInheritances();
            for (Inheritance inheritance : eList) {
                if (DeviceClass.isDefaultInheritance(inheritance)) continue;
                String string = inheritance.getSourcePath();
                String string2 = (String)JOptionPane.showInputDialog(this, "Inheritance class path for " + inheritance.getClassname() + "  is NOT a WINDOWS path !   " + "Please give a valid Windows path.", "Input Dialog", 1, null, null, string);
                if (string2 == null) {
                    return 2;
                }
                inheritance.setSourcePath(string2);
            }
        }
        return 0;
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose(2);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(2);
    }

    private String buidDetailsString(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() > 0) {
            if (list.size() > 1) {
                stringBuilder.append("The following ").append(string).append("s are abstract:\n");
                for (String string2 : list) {
                    stringBuilder.append("  - ").append(string2).append("\n");
                }
            } else {
                stringBuilder.append("The ").append(string).append("  ").append(list.get(0)).append("  is abstract.\n");
            }
        }
        return stringBuilder.toString();
    }

    private void detailsBtnActionPerformed(ActionEvent actionEvent) {
        List<String> list = this.deviceClass.getAbstractCommandNames();
        List<String> list2 = this.deviceClass.getAbstractAttributeNames();
        String string = this.buidDetailsString(list, "command");
        string = string + "\n";
        string = string + this.buidDetailsString(list2, "attribute");
        JOptionPane.showMessageDialog(this, string, "Details Window", 1);
    }

    private void outPathTextKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.doClose(2);
        }
    }

    private void xmiBtnActionPerformed(ActionEvent actionEvent) {
        this.xmiBtn.setSelected(true);
    }

    public int showDialog(DeviceClass deviceClass) {
        this.mode = 0;
        this.deviceClass = deviceClass;
        String string = deviceClass.getPogoDeviceClass().getDescription().getSourcePath();
        if (string == null || !new File(string).exists()) {
            string = PogoGUI.homeDir;
        }
        this.outPathText.setText(string);
        this.outPathText.setRequestFocusEnabled(true);
        this.outPathText.requestFocus();
        if (deviceClass.checkIfAbstractClass()) {
            this.makefileBtn.setEnabled(false);
            this.cMakeListsBtn.setEnabled(false);
            this.vc10Btn.setEnabled(false);
            this.vc12Btn.setEnabled(false);
            this.javaProjectLabel.setVisible(false);
            this.projectBtn.setVisible(false);
            this.pyHlProjectBtn.setVisible(false);
            this.prPythonHLBtn.setVisible(false);
            this.sphinxBtn.setVisible(false);
        }
        int n = Utils.getLanguage(deviceClass.getPogoDeviceClass().getDescription().getLanguage());
        switch (n) {
            case 1: {
                this.makefileBtn.setVisible(true);
                this.cMakeListsBtn.setVisible(this.cmakeAvailable);
                this.windowsLabel.setVisible(true);
                this.linuxLabel.setVisible(true);
                this.vc10Btn.setVisible(false);
                this.vc12Btn.setVisible(true);
                this.javaProjectLabel.setVisible(true);
                this.projectBtn.setText("Eclipse Project");
                this.projectBtn.setVisible(true);
                this.pyHlProjectBtn.setVisible(false);
                this.prPythonHLBtn.setVisible(false);
                this.sphinxBtn.setVisible(false);
                break;
            }
            case 0: {
                this.makefileBtn.setVisible(true);
                this.cMakeListsBtn.setVisible(false);
                this.windowsLabel.setVisible(false);
                this.linuxLabel.setVisible(true);
                this.vc10Btn.setVisible(false);
                this.vc12Btn.setVisible(false);
                this.javaProjectLabel.setVisible(true);
                this.projectBtn.setText("pom.xml");
                this.projectBtn.setVisible(true);
                this.pyHlProjectBtn.setVisible(false);
                this.prPythonHLBtn.setVisible(false);
                this.sphinxBtn.setVisible(false);
                break;
            }
            case 2: {
                this.makefileBtn.setVisible(false);
                this.cMakeListsBtn.setVisible(false);
                this.windowsLabel.setVisible(false);
                this.linuxLabel.setVisible(false);
                this.vc10Btn.setVisible(false);
                this.vc12Btn.setVisible(false);
                this.javaProjectLabel.setVisible(false);
                this.projectBtn.setVisible(false);
                this.pyHlProjectBtn.setVisible(false);
                this.prPythonHLBtn.setVisible(false);
                this.sphinxBtn.setVisible(false);
                break;
            }
            case 3: {
                this.makefileBtn.setVisible(false);
                this.cMakeListsBtn.setVisible(false);
                this.windowsLabel.setVisible(false);
                this.linuxLabel.setVisible(false);
                this.vc10Btn.setVisible(false);
                this.vc12Btn.setVisible(false);
                this.javaProjectLabel.setVisible(false);
                this.projectBtn.setVisible(false);
                this.pyHlProjectBtn.setVisible(true);
                this.prPythonHLBtn.setVisible(true);
                this.sphinxBtn.setVisible(true);
            }
        }
        boolean bl = deviceClass.checkIfAbstractClass();
        if (bl) {
            this.warningLabel.setText(deviceClass.getPogoDeviceClass().getName() + this.warningLabel.getText());
        } else {
            this.warningPanel.setVisible(false);
        }
        this.pack();
        this.setVisible(true);
        return returnStatus;
    }

    public int showDialog(PogoMultiClasses pogoMultiClasses) {
        this.mode = 1;
        String string = pogoMultiClasses.getSourcePath();
        if (string == null || !new File(string).exists()) {
            string = MultiClassesPanel.homeDir;
        }
        this.outPathText.setText(string);
        this.outPathText.setRequestFocusEnabled(true);
        this.outPathText.requestFocus();
        this.windowsLabel.setVisible(false);
        this.linuxLabel.setVisible(false);
        this.vc10Btn.setVisible(false);
        this.vc12Btn.setVisible(false);
        this.docLabel.setVisible(false);
        this.htmlBtn.setVisible(false);
        this.makefileBtn.setVisible(true);
        this.cMakeListsBtn.setVisible(this.cmakeAvailable);
        this.warningPanel.setVisible(false);
        this.javaProjectLabel.setVisible(false);
        this.projectBtn.setVisible(false);
        this.pyHlProjectBtn.setVisible(false);
        this.prPythonHLBtn.setVisible(false);
        this.sphinxBtn.setVisible(false);
        this.pack();
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int n) {
        returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    public String getPath() {
        return this.outPathText.getText();
    }

    public String getGenerated() {
        String string = "";
        for (JRadioButton jRadioButton : this.radioButtons) {
            if (!jRadioButton.isSelected()) continue;
            string = string + jRadioButton.getText() + ",";
        }
        if (string.length() == 0) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    public DeviceClass getDevClass() {
        this.deviceClass.getPogoDeviceClass().getDescription().setSourcePath(this.outPathText.getText());
        this.deviceClass.getPogoDeviceClass().getDescription().setFilestogenerate(this.getGenerated());
        return this.deviceClass;
    }

    private boolean mustBeOverWritten(String string) {
        String string2 = this.outPathText.getText();
        String string3 = string2 + "/" + string;
        File file = new File(string3);
        return file.exists() && JOptionPane.showConfirmDialog(this, string + " already exists !\n" + "Overwrite it ?", "Confirmation Window", 0) == 0;
    }

    private int manageMakefile() {
        Object object;
        String string = "Makefile";
        String string2 = "CMakeLists.txt";
        if (this.mode == 1) {
            string = string + ".multi";
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.makefileBtn.isSelected()) {
            bl = this.mustBeOverWritten(string);
        } else if (this.cMakeListsBtn.isSelected()) {
            bl2 = this.mustBeOverWritten(string2);
        } else {
            bl5 = true;
        }
        if (this.mode == 0 && this.vc10Btn.isSelected()) {
            bl4 = this.mustBeOverWritten("vc10_proj");
        } else {
            bl5 = true;
        }
        if (this.mode == 0 && this.vc12Btn.isSelected()) {
            bl3 = this.mustBeOverWritten("vc12_proj");
        } else {
            bl5 = true;
        }
        String string3 = this.outPathText.getText();
        if (this.mode == 0 && (bl5 || bl || bl2 || bl3 || bl4)) {
            object = this.deviceClass.getPogoDeviceClass().getDescription().getLanguage();
            EList<AdditionalFile> eList = this.deviceClass.getPogoDeviceClass().getAdditionalFiles();
            AdditionalFilesDialog additionalFilesDialog = new AdditionalFilesDialog(this, eList, string3, Utils.getFileExtension((String)object));
            if (additionalFilesDialog.showDialog() == 2) {
                return 2;
            }
        }
        if (bl && !((File)(object = new File(string3 + "/" + string))).renameTo(new File(((File)object).toString() + ".bck"))) {
            System.err.println("Cannot rename " + object);
        }
        if (bl2 && !((File)(object = new File(string3 + "/" + string2))).renameTo(new File(((File)object).toString() + ".bck"))) {
            System.err.println("Cannot rename " + object);
        }
        if (bl3 && !((File)(object = new File(string3 + "/vc12_proj"))).renameTo(new File(((File)object).toString() + ".bck"))) {
            System.err.println("Cannot rename " + object);
        }
        if (bl4 && !((File)(object = new File(string3 + "/vc10_proj"))).renameTo(new File(((File)object).toString() + ".bck"))) {
            System.err.println("Cannot rename " + object);
        }
        return 0;
    }
}

