/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.parser.antlr.ex.common;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.generator.parser.antlr.ex.common.IgnoreCaseString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordHelper
implements Adapter {
    private BiMap<CharSequence, String> keywordValueToToken;
    private boolean ignoreCase;
    public static final Comparator<String> keywordComparator = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            int result = s2.length() - s1.length();
            return result != 0 ? result : s1.compareTo(s2);
        }
    };

    public KeywordHelper(Grammar grammar, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.keywordValueToToken = this.createKeywordMap(grammar);
        grammar.eResource().getResourceSet().eAdapters().add(this);
    }

    public void discardHelper(Grammar grammar) {
        grammar.eResource().getResourceSet().eAdapters().remove(this);
    }

    public static KeywordHelper getHelper(EObject context) {
        for (Adapter candidate : context.eResource().getResourceSet().eAdapters()) {
            if (!(candidate instanceof KeywordHelper)) continue;
            return (KeywordHelper)candidate;
        }
        return null;
    }

    public String getRuleName(String keywordValue) {
        return (String)this.keywordValueToToken.get(this.createKey(keywordValue));
    }

    public String getKeywordValue(String ruleName) {
        return ((CharSequence)this.keywordValueToToken.inverse().get(ruleName)).toString();
    }

    public boolean isKeywordRule(String ruleName) {
        return this.keywordValueToToken.containsValue(ruleName);
    }

    public Set<String> getAllKeywords() {
        TreeSet<String> result = new TreeSet<String>(keywordComparator);
        for (CharSequence cs : this.keywordValueToToken.keySet()) {
            result.add(cs.toString());
        }
        return Collections.unmodifiableSet(result);
    }

    private BiMap<CharSequence, String> createKeywordMap(Grammar grammar) {
        List<ParserRule> parserRules = GrammarUtil.allParserRules(grammar);
        List<EnumRule> enumRules = GrammarUtil.allEnumRules(grammar);
        Iterator iter = Iterators.concat(EcoreUtil.getAllContents(parserRules), EcoreUtil.getAllContents(enumRules));
        UnmodifiableIterator<Keyword> filtered = Iterators.filter(iter, Keyword.class);
        Iterator<String> transformed = Iterators.transform(filtered, new Function<Keyword, String>(){

            @Override
            public String apply(Keyword from) {
                return from.getValue();
            }
        });
        TreeSet<String> treeSet = Sets.newTreeSet(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() == o2.length()) {
                    return o1.compareTo(o2);
                }
                return Integer.valueOf(o1.length()).compareTo(o2.length());
            }
        });
        Iterators.addAll(treeSet, transformed);
        HashBiMap<CharSequence, String> result = HashBiMap.create();
        int i = 1;
        for (String s : treeSet) {
            CharSequence key = this.createKey(s);
            if (result.containsKey(key)) continue;
            result.put(key, "KEYWORD_" + i);
            ++i;
        }
        return result;
    }

    private CharSequence createKey(String s) {
        if (this.ignoreCase) {
            return new IgnoreCaseString(s);
        }
        return s;
    }

    @Override
    public Notifier getTarget() {
        return null;
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return false;
    }

    @Override
    public void notifyChanged(Notification notification) {
    }

    @Override
    public void setTarget(Notifier newTarget) {
    }
}

