/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.access.binary.BinaryClass;
import org.eclipse.xtext.common.types.access.impl.DeclaredTypeFactory;
import org.eclipse.xtext.common.types.access.impl.ITypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingDeclaredTypeFactory
implements ITypeFactory<BinaryClass, JvmDeclaredType> {
    private static final Logger log = Logger.getLogger(CachingDeclaredTypeFactory.class);
    private final DeclaredTypeFactory delegate;
    private final Map<String, JvmDeclaredType> typeCache = Maps.newHashMap();

    public CachingDeclaredTypeFactory(DeclaredTypeFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public JvmDeclaredType createType(BinaryClass clazz) {
        try {
            JvmDeclaredType cachedResult = this.get(clazz);
            return EcoreUtil2.cloneWithProxies(cachedResult);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(e.getMessage(), e);
            }
            return this.delegate.createType(clazz);
        }
    }

    private JvmDeclaredType get(BinaryClass clazz) {
        String name = clazz.getName();
        JvmDeclaredType cachedResult = this.typeCache.get(name);
        if (cachedResult == null) {
            cachedResult = this.load(clazz);
            this.typeCache.put(name, cachedResult);
        }
        return cachedResult;
    }

    private JvmDeclaredType load(BinaryClass key) {
        if (log.isDebugEnabled()) {
            log.debug("Hit:" + key.getName());
        }
        return this.delegate.createType(key);
    }
}

